/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.chat.ClientTextConverter;
import su.plo.voice.client.utils.TextKt;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;
import su.plo.voice.universal.UMinecraft;
import su.plo.voice.universal.UResolution;
import su.plo.voice.universal.wrappers.message.UTextComponent;

public final class RenderUtil {
    private static final ClientTextConverter TEXT_CONVERTER = new ClientTextConverter();

    public static void enableScissor(int x, int y, int width, int height) {
        double scaleFactor = UResolution.getScaleFactor();
        double scaledX = (double)x * scaleFactor;
        double scaledY = (double)y * scaleFactor;
        double scaledWidth = (double)width * scaleFactor;
        double scaledHeight = (double)height * scaleFactor;
        RenderSystem.m_69488_((int)((int)scaledX), (int)((int)scaledY), (int)Math.max(0, (int)scaledWidth), (int)Math.max(0, (int)scaledHeight));
    }

    public static void disableScissor() {
        RenderSystem.m_69471_();
    }

    public static void fill(UMatrixStack stack, int x0, int y0, int x1, int y1, int color) {
        int n;
        if (x0 < x1) {
            n = x0;
            x0 = x1;
            x1 = n;
        }
        if (y0 < y1) {
            n = y0;
            y0 = y1;
            y1 = n;
        }
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float o = (float)(color & 0xFF) / 255.0f;
        UGraphics buffer = UGraphics.getFromTessellator();
        UGraphics.enableBlend();
        RenderUtil.defaultBlendFunc();
        buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        buffer.pos(stack, x0, y1, 0.0).color(g, h, o, f).endVertex();
        buffer.pos(stack, x1, y1, 0.0).color(g, h, o, f).endVertex();
        buffer.pos(stack, x1, y0, 0.0).color(g, h, o, f).endVertex();
        buffer.pos(stack, x0, y0, 0.0).color(g, h, o, f).endVertex();
        buffer.drawDirect();
        UGraphics.disableBlend();
    }

    public static void fillGradient(UMatrixStack stack, int startX, int startY, int endX, int endY, int colorStart, int colorEnd, int z, boolean defaultBlend) {
        int f = colorStart >> 24 & 0xFF;
        int g = colorStart >> 16 & 0xFF;
        int h = colorStart >> 8 & 0xFF;
        int i = colorStart & 0xFF;
        int j = colorEnd >> 24 & 0xFF;
        int k = colorEnd >> 16 & 0xFF;
        int l = colorEnd >> 8 & 0xFF;
        int m = colorEnd & 0xFF;
        RenderUtil.fillGradient(stack, startX, startY, endX, endY, g, h, i, f, k, l, m, j, z, defaultBlend);
    }

    public static void fillGradient(UMatrixStack stack, int startX, int startY, int endX, int endY, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha, int z, boolean defaultBlend) {
        if (defaultBlend) {
            UGraphics.enableBlend();
            RenderUtil.defaultBlendFunc();
        }
        UGraphics buffer = UGraphics.getFromTessellator();
        buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_COLOR);
        RenderUtil.fillGradient(stack, buffer, startX, startY, endX, endY, z, startRed, startBlue, startGreen, startAlpha, endRed, endBlue, endGreen, endAlpha);
        buffer.drawDirect();
        UGraphics.disableBlend();
    }

    private static void fillGradient(UMatrixStack stack, UGraphics buffer, int startX, int startY, int endX, int endY, int z, int startRed, int startBlue, int startGreen, int startAlpha, int endRed, int endBlue, int endGreen, int endAlpha) {
        buffer.pos(stack, endX, startY, z).color(startRed, startGreen, startBlue, startAlpha).endVertex();
        buffer.pos(stack, startX, startY, z).color(startRed, startGreen, startBlue, startAlpha).endVertex();
        buffer.pos(stack, startX, endY, z).color(endRed, endGreen, endBlue, endAlpha).endVertex();
        buffer.pos(stack, endX, endY, z).color(endRed, endGreen, endBlue, endAlpha).endVertex();
    }

    public static void blit(UMatrixStack stack, int x, int y, int u, int v, int width, int height) {
        RenderUtil.blit(stack, x, y, 0, (float)u, (float)v, width, height, 256, 256);
    }

    public static void blit(UMatrixStack stack, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blit(stack, x, x + width, y, y + height, z, width, height, u, v, textureWidth, textureHeight);
    }

    public static void blit(UMatrixStack stack, int x, int y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
        RenderUtil.blit(stack, x, x + width, y, y + height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
    }

    public static void blit(UMatrixStack stack, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        RenderUtil.blit(stack, x, y, width, height, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blit(UMatrixStack stack, int x0, int x1, int y0, int y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
        RenderUtil.blit(stack, x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
    }

    public static void blit(UMatrixStack stack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1) {
        UGraphics buffer = UGraphics.getFromTessellator();
        buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE);
        buffer.pos(stack, x0, y1, z).tex(u0, v1).endVertex();
        buffer.pos(stack, x1, y1, z).tex(u1, v1).endVertex();
        buffer.pos(stack, x1, y0, z).tex(u1, v0).endVertex();
        buffer.pos(stack, x0, y0, z).tex(u0, v0).endVertex();
        buffer.drawDirect();
    }

    public static void blitWithActiveShader(UMatrixStack stack, UGraphics.CommonVertexFormats format, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        UGraphics buffer = UGraphics.getFromTessellator();
        buffer.beginWithActiveShader(UGraphics.DrawMode.QUADS, format);
        buffer.pos(stack, x0, y1, z).tex(u0, v1).color(red, green, blue, alpha).endVertex();
        buffer.pos(stack, x1, y1, z).tex(u1, v1).color(red, green, blue, alpha).endVertex();
        buffer.pos(stack, x1, y0, z).tex(u1, v0).color(red, green, blue, alpha).endVertex();
        buffer.pos(stack, x0, y0, z).tex(u0, v0).color(red, green, blue, alpha).endVertex();
        buffer.drawDirect();
    }

    public static void blitColor(UMatrixStack stack, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        UGraphics buffer = UGraphics.getFromTessellator();
        buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
        buffer.pos(stack, x0, y1, z).tex(u0, v1).color(red, green, blue, alpha).endVertex();
        buffer.pos(stack, x1, y1, z).tex(u1, v1).color(red, green, blue, alpha).endVertex();
        buffer.pos(stack, x1, y0, z).tex(u1, v0).color(red, green, blue, alpha).endVertex();
        buffer.pos(stack, x0, y0, z).tex(u0, v0).color(red, green, blue, alpha).endVertex();
        buffer.drawDirect();
    }

    public static int drawCenteredString(UMatrixStack stack, String string, int x, int y, int color) {
        color = RenderUtil.adjustColor(color);
        float centeredX = x - UGraphics.getStringWidth(string) / 2;
        UGraphics.drawString(stack, string, centeredX, (float)y, color, true);
        return RenderUtil.getStringX(string, (int)centeredX, true);
    }

    public static int drawCenteredString(UMatrixStack stack, MinecraftTextComponent text, int x, int y, int color) {
        UTextComponent component = RenderUtil.getTextConverter().convertToUniversal(text);
        return RenderUtil.drawCenteredString(stack, component.getFormattedText(), x, y, color);
    }

    public static void drawCenteredOrderedString(UMatrixStack stack, MinecraftTextComponent text, int width, int x, int y, int color) {
        color = RenderUtil.adjustColor(color);
        String orderedText = RenderUtil.getOrderedString(text, width);
        UGraphics.drawString(stack, orderedText, (float)x - (float)UGraphics.getStringWidth(orderedText) / 2.0f, (float)y, color, true);
    }

    public static void drawOrderedString(UMatrixStack stack, MinecraftTextComponent text, int width, int x, int y, int color) {
        color = RenderUtil.adjustColor(color);
        UGraphics.drawString(stack, RenderUtil.getOrderedString(text, width), (float)x, (float)y, color, true);
    }

    public static int drawString(UMatrixStack stack, String string, int x, int y, int color) {
        color = RenderUtil.adjustColor(color);
        UGraphics.drawString(stack, string, (float)x, (float)y, color, false);
        return RenderUtil.getStringX(string, x, false);
    }

    public static int drawString(UMatrixStack stack, MinecraftTextComponent text, int x, int y, int color) {
        return RenderUtil.drawString(stack, text, x, y, color, true);
    }

    public static int drawString(UMatrixStack stack, MinecraftTextComponent text, int x, int y, int color, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        UTextComponent component = RenderUtil.getTextConverter().convertToUniversal(text);
        String formattedText = component.getFormattedText();
        UGraphics.drawString(stack, formattedText, (float)x, (float)y, color, dropShadow);
        return RenderUtil.getStringX(formattedText, x, dropShadow);
    }

    public static int drawStringLight(UMatrixStack stack, MinecraftTextComponent text, int x, int y, int color, int light, boolean seeThrough, boolean dropShadow) {
        color = RenderUtil.adjustColor(color);
        UTextComponent component = RenderUtil.getTextConverter().convertToUniversal(text);
        String formattedText = component.getFormattedText();
        Font.DisplayMode displayMode = seeThrough ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL;
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        UMinecraft.getFontRenderer().m_271703_(formattedText, (float)x, (float)y, color, dropShadow, stack.peek().getModel(), (MultiBufferSource)irendertypebuffer$impl, displayMode, 0, light);
        irendertypebuffer$impl.m_109911_();
        return RenderUtil.getStringX(formattedText, x, dropShadow);
    }

    public static int drawStringMultiLine(UMatrixStack stack, MinecraftTextComponent text, int x, int y, int color, int width) {
        color = RenderUtil.adjustColor(color);
        String string = RenderUtil.getFormattedString(text);
        List<String> lines = TextKt.getStringSplitToWidth(string, width, true, true);
        int lineHeight = UGraphics.getFontHeight();
        for (String orderedText : lines) {
            UGraphics.drawString(stack, orderedText, (float)x, (float)(y - lineHeight - 1), color, true);
            y += lineHeight;
        }
        return lines.size();
    }

    public static int drawStringMultiLineCentered(UMatrixStack stack, MinecraftTextComponent text, int width, int y, int yGap, int color) {
        color = RenderUtil.adjustColor(color);
        String string = RenderUtil.getFormattedString(text);
        List<String> lines = TextKt.getStringSplitToWidth(string, width, true, true);
        int lineHeight = UGraphics.getFontHeight();
        for (String orderedText : lines) {
            UGraphics.drawString(stack, orderedText, (float)width / 2.0f - (float)UGraphics.getStringWidth(orderedText) / 2.0f, (float)y + (float)lineHeight, color, true);
            y += lineHeight + yGap;
        }
        return lines.size();
    }

    public static int getStringX(String string, int x, boolean dropShadow) {
        return x + UGraphics.getStringWidth(string) + (dropShadow ? 1 : 0);
    }

    public static int adjustColor(int color) {
        return (color & 0xFC000000) == 0 ? color | 0xFF000000 : color;
    }

    public static String stringToWidth(String string, int width, boolean tail) {
        List<String> lines = TextKt.splitStringToWidthTruncated(string, width, 1, false, true, "...");
        return lines.get(tail ? lines.size() - 1 : 0);
    }

    public static String stringToWidth(String string, int width) {
        return RenderUtil.stringToWidth(string, width, false);
    }

    public static int getTextWidth(MinecraftTextComponent text) {
        UTextComponent component = RenderUtil.getTextConverter().convertToUniversal(text);
        return UGraphics.getStringWidth(component.getFormattedText());
    }

    public static String getOrderedString(MinecraftTextComponent text, int width) {
        return TextKt.getTruncatedString(RenderUtil.getFormattedString(text), width, "...");
    }

    public static String getFormattedString(MinecraftTextComponent text) {
        return RenderUtil.getTextConverter().convertToUniversal(text).getFormattedText();
    }

    public static void enableColorLogic() {
        RenderSystem.m_69479_();
    }

    public static void disableColorLogic() {
        RenderSystem.m_69462_();
    }

    public static void logicOp(String opcode) {
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.valueOf((String)opcode));
    }

    public static void enableCull() {
        RenderSystem.m_69481_();
    }

    public static void disableCull() {
        RenderSystem.m_69464_();
    }

    public static void enablePolygonOffset() {
        RenderSystem.m_69486_();
    }

    public static void disablePolygonOffset() {
        RenderSystem.m_69469_();
    }

    public static void polygonOffset(float factor, float units) {
        RenderSystem.m_69863_((float)factor, (float)units);
    }

    public static void lineWidth(float width) {
        RenderSystem.m_69832_((float)width);
    }

    public static boolean hasLightLayer() {
        return RenderSystem.m_157203_((int)2) != 0;
    }

    public static void turnOnLightLayer() {
        UMinecraft.getMinecraft().f_91063_.m_109154_().m_109896_();
    }

    public static void turnOffLightLayer() {
        UMinecraft.getMinecraft().f_91063_.m_109154_().m_109891_();
    }

    public static ClientTextConverter getTextConverter() {
        return TEXT_CONVERTER;
    }

    public static void defaultBlendFunc() {
        UGraphics.tryBlendFuncSeparate(770, 771, 1, 0);
    }

    private RenderUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

