/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.mod.client.render.TextureUtilKt;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.universal.UMinecraft;

public final class ModPlayerSkins {
    private static final Cache<String, ResourceLocation> skins = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build();

    public static synchronized void loadSkin(@NotNull UUID playerId, @NotNull String nick, @Nullable String fallback) {
        PlayerInfo playerInfo = UMinecraft.getNetHandler().m_104949_(playerId);
        if (playerInfo != null) {
            return;
        }
        ResourceLocation skinLocation = (ResourceLocation)skins.getIfPresent((Object)nick);
        if (skinLocation != null) {
            return;
        }
        if (fallback != null) {
            ResourceLocation fallbackIdentifier = new ResourceLocation("plasmovoice", "skins/" + Hashing.sha1().hashUnencodedChars((CharSequence)nick.toLowerCase()));
            TextureUtilKt.registerBase64Texture(fallback, fallbackIdentifier);
            skins.put((Object)nick, (Object)fallbackIdentifier);
        }
        GameProfile profile = new GameProfile(playerId, nick);
        SkinManager skinManager = UMinecraft.getMinecraft().m_91109_();
        Map textures = skinManager.m_118815_(profile);
        if (textures.isEmpty()) {
            skinManager.m_118817_(profile, (type, identifier, texture) -> {
                if (type.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                    skins.put((Object)profile.getName(), (Object)identifier);
                }
            }, false);
        } else {
            String hash = Hashing.sha1().hashUnencodedChars((CharSequence)((MinecraftProfileTexture)textures.get(MinecraftProfileTexture.Type.SKIN)).getHash()).toString();
            ResourceLocation identifier2 = new ResourceLocation("skins/" + hash);
            skins.put((Object)profile.getName(), (Object)identifier2);
        }
    }

    public static synchronized void loadSkin(@NotNull MinecraftGameProfile gameProfile) {
        PlayerInfo playerInfo = UMinecraft.getNetHandler().m_104949_(gameProfile.getId());
        if (playerInfo != null) {
            return;
        }
        ResourceLocation skinLocation = (ResourceLocation)skins.getIfPresent((Object)gameProfile.getName());
        if (skinLocation != null) {
            return;
        }
        GameProfile profile = new GameProfile(gameProfile.getId(), gameProfile.getName());
        gameProfile.getProperties().forEach(property -> profile.getProperties().put((Object)property.getName(), (Object)new Property(property.getName(), property.getValue(), property.getSignature())));
        skinLocation = UMinecraft.getMinecraft().m_91109_().m_240306_(profile);
        skins.put((Object)gameProfile.getName(), (Object)skinLocation);
    }

    @NotNull
    public static synchronized ResourceLocation getSkin(@NotNull UUID playerId, @NotNull String nick) {
        PlayerInfo playerInfo = UMinecraft.getNetHandler().m_104949_(playerId);
        if (playerInfo != null) {
            return playerInfo.m_105337_();
        }
        ResourceLocation skinLocation = (ResourceLocation)skins.getIfPresent((Object)nick);
        if (skinLocation != null) {
            return skinLocation;
        }
        return ModPlayerSkins.getDefaultSkin(playerId);
    }

    @NotNull
    public static ResourceLocation getDefaultSkin(@NotNull UUID playerId) {
        return DefaultPlayerSkin.m_118627_((UUID)playerId);
    }

    private ModPlayerSkins() {
    }
}

