/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.server;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.MinecraftServerLib;
import su.plo.lib.api.server.entity.MinecraftServerEntity;
import su.plo.lib.api.server.entity.MinecraftServerPlayerEntity;
import su.plo.lib.api.server.event.player.PlayerQuitEvent;
import su.plo.lib.api.server.permission.PermissionsManager;
import su.plo.lib.api.server.world.MinecraftServerWorld;
import su.plo.lib.mod.chat.ComponentTextConverter;
import su.plo.lib.mod.client.texture.ResourceCache;
import su.plo.lib.mod.server.chat.ServerComponentTextConverter;
import su.plo.lib.mod.server.command.ModCommandManager;
import su.plo.lib.mod.server.entity.ModServerEntity;
import su.plo.lib.mod.server.entity.ModServerPlayer;
import su.plo.lib.mod.server.world.ModServerWorld;
import su.plo.voice.api.server.config.ServerLanguages;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.server.player.PermissionSupplier;

public final class ModServerLib
implements MinecraftServerLib {
    public static ModServerLib INSTANCE;
    private final Map<ServerLevel, MinecraftServerWorld> worldByInstance = Maps.newConcurrentMap();
    private final Map<UUID, MinecraftServerPlayerEntity> playerById = Maps.newConcurrentMap();
    private MinecraftServer server;
    private PermissionSupplier permissions;
    private final ServerComponentTextConverter textConverter;
    private final ResourceCache resources = new ResourceCache();
    private final ModCommandManager commandManager;
    private final PermissionsManager permissionsManager = new PermissionsManager();

    public ModServerLib(@NotNull Supplier<ServerLanguages> languagesSupplier) {
        this.textConverter = new ServerComponentTextConverter(new ComponentTextConverter(), languagesSupplier);
        this.commandManager = new ModCommandManager(this, this.textConverter);
        PlayerQuitEvent.INSTANCE.registerListener(player -> this.playerById.remove(player.getUUID()));
    }

    @Override
    public void onInitialize() {
        INSTANCE = this;
    }

    @Override
    public void onShutdown() {
        this.server = null;
        this.permissions = null;
        this.commandManager.clear();
        this.permissionsManager.clear();
    }

    @Override
    public void executeInMainThread(@NotNull Runnable runnable) {
        this.server.execute(runnable);
    }

    @Override
    @NotNull
    public MinecraftServerWorld getWorld(@NotNull Object instance) {
        if (!(instance instanceof ServerLevel)) {
            throw new IllegalArgumentException("instance is not " + ServerLevel.class);
        }
        return this.worldByInstance.computeIfAbsent((ServerLevel)instance, level -> new ModServerWorld(level.m_46472_().m_135782_(), (ServerLevel)level));
    }

    @Override
    public Collection<MinecraftServerWorld> getWorlds() {
        if (this.server.m_129784_().size() == this.worldByInstance.size()) {
            return this.worldByInstance.values();
        }
        return StreamSupport.stream(this.server.m_129785_().spliterator(), false).map(this::getWorld).toList();
    }

    @Override
    @NotNull
    public MinecraftServerPlayerEntity getPlayerByInstance(@NotNull Object instance) {
        if (!(instance instanceof ServerPlayer)) {
            throw new IllegalArgumentException("instance is not " + ServerPlayer.class);
        }
        ServerPlayer serverInstance = (ServerPlayer)instance;
        MinecraftServerPlayerEntity serverPlayer = this.playerById.get(serverInstance.m_20148_());
        if (serverPlayer == null || ((ServerPlayer)serverPlayer.getInstance()).m_19879_() != serverInstance.m_19879_()) {
            serverPlayer = new ModServerPlayer(this, this.textConverter, this.permissions, this.resources, serverInstance);
            this.playerById.put(serverInstance.m_20148_(), serverPlayer);
        }
        return serverPlayer;
    }

    @Override
    public Optional<MinecraftServerPlayerEntity> getPlayerByName(@NotNull String name) {
        ServerPlayer player = this.server.m_6846_().m_11255_(name);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(this.getPlayerByInstance(player));
    }

    @Override
    public Optional<MinecraftServerPlayerEntity> getPlayerById(@NotNull UUID playerId) {
        MinecraftServerPlayerEntity serverPlayer = this.playerById.get(playerId);
        if (serverPlayer != null) {
            return Optional.of(serverPlayer);
        }
        ServerPlayer player = this.server.m_6846_().m_11259_(playerId);
        if (player == null) {
            return Optional.empty();
        }
        return Optional.of(this.getPlayerByInstance(player));
    }

    @Override
    public Optional<MinecraftGameProfile> getGameProfile(@NotNull UUID playerId) {
        return this.server.m_129927_().m_11002_(playerId).map(this::getGameProfile);
    }

    @Override
    public Optional<MinecraftGameProfile> getGameProfile(@NotNull String name) {
        return this.server.m_129927_().m_10996_(name).map(this::getGameProfile);
    }

    private MinecraftGameProfile getGameProfile(@NotNull GameProfile gameProfile) {
        return new MinecraftGameProfile(gameProfile.getId(), gameProfile.getName(), gameProfile.getProperties().values().stream().map(property -> new MinecraftGameProfile.Property(property.getName(), property.getValue(), property.getSignature())).collect(Collectors.toList()));
    }

    @Override
    @NotNull
    public Collection<MinecraftServerPlayerEntity> getPlayers() {
        return this.playerById.values();
    }

    @Override
    @NotNull
    public MinecraftServerEntity getEntity(@NotNull Object instance) {
        if (!(instance instanceof Entity)) {
            throw new IllegalArgumentException("instance is not " + Entity.class);
        }
        return new ModServerEntity(this, (Entity)instance);
    }

    @Override
    public int getPort() {
        return this.server.m_7010_();
    }

    @Override
    @NotNull
    public String getVersion() {
        return this.server.m_7630_();
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    public void setPermissions(PermissionSupplier permissions) {
        this.permissions = permissions;
    }

    public ServerComponentTextConverter getTextConverter() {
        return this.textConverter;
    }

    public ModCommandManager getCommandManager() {
        return this.commandManager;
    }

    @Override
    public PermissionsManager getPermissionsManager() {
        return this.permissionsManager;
    }
}

