/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.server.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.command.MinecraftCommand;
import su.plo.lib.api.server.command.MinecraftCommandSource;
import su.plo.lib.mod.server.command.ModCommandManager;
import su.plo.voice.BaseVoice;

public final class ModCommand
implements Command<CommandSourceStack>,
Predicate<CommandSourceStack>,
SuggestionProvider<CommandSourceStack> {
    private final ModCommandManager commandManager;
    private final MinecraftCommand command;

    public LiteralCommandNode<CommandSourceStack> register(CommandDispatcher<CommandSourceStack> dispatcher, String label) {
        RootCommandNode root = dispatcher.getRoot();
        LiteralCommandNode literal = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)label).requires((Predicate)this)).executes((Command)this)).build();
        ArgumentCommandNode defaultArgs = ((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests((SuggestionProvider)this).executes((Command)this)).build();
        literal.addChild((CommandNode)defaultArgs);
        root.addChild((CommandNode)literal);
        return literal;
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int spaceIndex;
        String[] args;
        MinecraftCommandSource source = this.commandManager.getCommandSource(context.getSource());
        if (!this.command.hasPermission(source, args = (spaceIndex = context.getInput().indexOf(32)) >= 0 ? context.getInput().substring(spaceIndex + 1).split(" ", -1) : new String[]{})) {
            source.sendMessage(MinecraftTextComponent.translatable("pv.error.no_permissions", new Object[0]));
            return 1;
        }
        try {
            this.command.execute(source, args);
        }
        catch (Exception e) {
            BaseVoice.LOGGER.error("Error while executing command", (Throwable)e);
            throw e;
        }
        return 1;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        int spaceIndex = context.getInput().indexOf(32);
        String[] args = context.getInput().substring(spaceIndex + 1).split(" ", -1);
        List<String> results = this.command.suggest(this.commandManager.getCommandSource(context.getSource()), args);
        builder = builder.createOffset(builder.getInput().lastIndexOf(32) + 1);
        for (String s : results) {
            builder.suggest(s);
        }
        return builder.buildFuture();
    }

    @Override
    public boolean test(CommandSourceStack source) {
        return this.command.hasPermission(this.commandManager.getCommandSource(source), null);
    }

    public ModCommand(ModCommandManager commandManager, MinecraftCommand command) {
        this.commandManager = commandManager;
        this.command = command;
    }
}

