/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.server.entity;

import com.google.common.collect.Sets;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.server.MinecraftServerLib;
import su.plo.lib.api.server.chat.ServerTextConverter;
import su.plo.lib.api.server.entity.MinecraftServerEntity;
import su.plo.lib.api.server.entity.MinecraftServerPlayerEntity;
import su.plo.lib.api.server.permission.PermissionTristate;
import su.plo.lib.api.server.world.MinecraftServerWorld;
import su.plo.lib.api.server.world.ServerPos3d;
import su.plo.lib.mod.client.texture.ResourceCache;
import su.plo.lib.mod.entity.ModPlayer;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.server.player.PermissionSupplier;

public final class ModServerPlayer
extends ModPlayer<ServerPlayer>
implements MinecraftServerPlayerEntity {
    private final MinecraftServerLib minecraftServer;
    private final ServerTextConverter<Component> textConverter;
    private final PermissionSupplier permissions;
    private final ResourceCache resources;
    private final Set<String> registeredChannels = Sets.newCopyOnWriteArraySet();
    private String language = "en_us";
    private MinecraftServerEntity spectatorTarget;

    public ModServerPlayer(@NotNull MinecraftServerLib minecraftServer, @NotNull ServerTextConverter<Component> textConverter, @NotNull PermissionSupplier permissions, @NotNull ResourceCache resources, @NotNull ServerPlayer player) {
        super(player);
        this.minecraftServer = minecraftServer;
        this.textConverter = textConverter;
        this.permissions = permissions;
        this.resources = resources;
    }

    @Override
    @NotNull
    public ServerPos3d getServerPosition() {
        return new ServerPos3d(this.minecraftServer.getWorld(((ServerPlayer)this.instance).m_9236_()), ((ServerPlayer)this.instance).m_20182_().m_7096_(), ((ServerPlayer)this.instance).m_20182_().m_7098_(), ((ServerPlayer)this.instance).m_20182_().m_7094_(), ((ServerPlayer)this.instance).m_146909_(), ((ServerPlayer)this.instance).m_146908_());
    }

    @Override
    @NotNull
    public ServerPos3d getServerPosition(@NotNull ServerPos3d position) {
        position.setWorld(this.minecraftServer.getWorld(((ServerPlayer)this.instance).m_9236_()));
        position.setX(((ServerPlayer)this.instance).m_20182_().m_7096_());
        position.setY(((ServerPlayer)this.instance).m_20182_().m_7098_());
        position.setZ(((ServerPlayer)this.instance).m_20182_().m_7094_());
        position.setYaw(((ServerPlayer)this.instance).m_146909_());
        position.setPitch(((ServerPlayer)this.instance).m_146908_());
        return position;
    }

    @Override
    @NotNull
    public MinecraftServerWorld getWorld() {
        return this.minecraftServer.getWorld(((ServerPlayer)this.instance).m_9236_());
    }

    @Override
    public boolean isOnline() {
        return !((ServerPlayer)this.instance).m_9232_();
    }

    @Override
    @NotNull
    public MinecraftGameProfile getGameProfile() {
        return this.minecraftServer.getGameProfile(((ServerPlayer)this.instance).m_20148_()).orElseThrow(() -> new IllegalStateException("Game profile not found"));
    }

    @Override
    public void sendPacket(@NotNull String channel, byte[] data) {
        ((ServerPlayer)this.instance).f_8906_.m_9829_((Packet)new ClientboundCustomPayloadPacket(this.resources.getLocation(channel), new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data))));
    }

    @Override
    public void kick(@NotNull MinecraftTextComponent reason) {
        ((ServerPlayer)this.instance).f_8906_.m_9942_(this.textConverter.convert(this, reason));
    }

    @Override
    public void sendMessage(@NotNull MinecraftTextComponent text) {
        ((ServerPlayer)this.instance).m_213846_(this.textConverter.convert(this, text));
    }

    @Override
    public void sendMessage(@NotNull String text) {
        ((ServerPlayer)this.instance).m_213846_((Component)Component.m_237113_((String)text));
    }

    @Override
    public void sendActionBar(@NotNull String text) {
        ((ServerPlayer)this.instance).f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237113_((String)text)));
    }

    @Override
    public void sendActionBar(@NotNull MinecraftTextComponent text) {
        ((ServerPlayer)this.instance).f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket(this.textConverter.convert(this, text)));
    }

    @Override
    public boolean canSee(@NotNull MinecraftServerPlayerEntity player) {
        ServerPlayer serverPlayer = (ServerPlayer)player.getInstance();
        return !serverPlayer.m_20177_((Player)this.instance);
    }

    @Override
    public Collection<String> getRegisteredChannels() {
        return this.registeredChannels;
    }

    @Override
    public Optional<MinecraftServerEntity> getSpectatorTarget() {
        if (((ServerPlayer)this.instance).m_8954_() == this.instance) {
            this.spectatorTarget = null;
        } else if (this.spectatorTarget == null || !((ServerPlayer)this.instance).m_8954_().equals(this.spectatorTarget.getInstance())) {
            this.spectatorTarget = this.minecraftServer.getEntity(((ServerPlayer)this.instance).m_8954_());
        }
        return Optional.ofNullable(this.spectatorTarget);
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        return this.permissions.hasPermission(this.instance, permission);
    }

    @Override
    @NotNull
    public PermissionTristate getPermission(@NotNull String permission) {
        return this.permissions.getPermission(this.instance, permission);
    }

    public void addChannel(@NotNull String channel) {
        this.registeredChannels.add(channel);
    }

    public void removeChannel(@NotNull String channel) {
        this.registeredChannels.remove(channel);
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

