/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.server.world;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.entity.MinecraftServerEntity;
import su.plo.lib.api.server.world.MinecraftServerWorld;

public final class ModServerWorld
implements MinecraftServerWorld {
    private final ResourceLocation key;
    private final ServerLevel level;

    @Override
    @NotNull
    public String getKey() {
        return this.key.toString();
    }

    @Override
    public void sendGameEvent(@NotNull MinecraftServerEntity entity, @NotNull String gameEvent) {
        Entity serverEntity = (Entity)entity.getInstance();
        this.level.m_7654_().execute(() -> this.level.m_220400_(serverEntity, this.parseGameEvent(gameEvent), serverEntity.m_20182_()));
    }

    @Override
    public <T> T getInstance() {
        return (T)this.level;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            ModServerWorld world = (ModServerWorld)object;
            return this.level == world.level;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.level);
    }

    private GameEvent parseGameEvent(@NotNull String gameEventName) {
        return (GameEvent)BuiltInRegistries.f_256726_.m_7745_(new ResourceLocation(gameEventName));
    }

    public ModServerWorld(ResourceLocation key, ServerLevel level) {
        this.key = key;
        this.level = level;
    }
}

