/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class SoundOcclusion {
    private static final double OCCLUSION_MULTIPLIER = 0.5;
    private static final double OCCLUSION_MAX = 0.98;

    public static double getOccludedPercent(Level world, Vec3 sound, Vec3 listener) {
        double occludedPercent = 0.0;
        sound = sound.m_82520_(0.01, 0.01, 0.01);
        if (Double.isNaN(sound.f_82479_) || Double.isNaN(sound.f_82480_) || Double.isNaN(sound.f_82481_)) {
            return occludedPercent;
        }
        if (Double.isNaN(listener.f_82479_) || Double.isNaN(listener.f_82480_) || Double.isNaN(listener.f_82481_)) {
            return occludedPercent;
        }
        BlockPos listenerPos = new BlockPos((int)Math.floor(listener.f_82479_), (int)Math.floor(listener.f_82480_), (int)Math.floor(listener.f_82481_));
        BlockPos soundPos = new BlockPos((int)Math.floor(sound.f_82479_), (int)Math.floor(sound.f_82480_), (int)Math.floor(sound.f_82481_));
        int i = 0;
        while (i++ < 200) {
            double newOcclusion;
            BlockHitResult rayTrace;
            Vec3 prevSound = sound;
            BlockPos prevSoundPos = soundPos;
            if (Double.isNaN(sound.f_82479_) || Double.isNaN(sound.f_82480_) || Double.isNaN(sound.f_82481_)) {
                return occludedPercent;
            }
            if (soundPos.equals((Object)listenerPos)) {
                return occludedPercent;
            }
            boolean shouldChangeX = listenerPos.m_123341_() != soundPos.m_123341_();
            boolean shouldChangeY = listenerPos.m_123342_() != soundPos.m_123342_();
            boolean shouldChangeZ = listenerPos.m_123343_() != soundPos.m_123343_();
            int nextX = soundPos.m_123341_() + (listenerPos.m_123341_() > soundPos.m_123341_() ? 1 : 0);
            int nextY = soundPos.m_123342_() + (listenerPos.m_123342_() > soundPos.m_123342_() ? 1 : 0);
            int nextZ = soundPos.m_123343_() + (listenerPos.m_123343_() > soundPos.m_123343_() ? 1 : 0);
            double xDifference = listener.f_82479_ - sound.f_82479_;
            double yDifference = listener.f_82480_ - sound.f_82480_;
            double zDifference = listener.f_82481_ - sound.f_82481_;
            double xPercentChange = shouldChangeX ? ((double)nextX - sound.f_82479_) / xDifference : Double.POSITIVE_INFINITY;
            double yPercentChange = shouldChangeY ? ((double)nextY - sound.f_82480_) / yDifference : Double.POSITIVE_INFINITY;
            double zPercentChange = shouldChangeZ ? ((double)nextZ - sound.f_82481_) / zDifference : Double.POSITIVE_INFINITY;
            BlockPos soundPosOffset = null;
            if (xPercentChange < yPercentChange && xPercentChange < zPercentChange) {
                sound = new Vec3((double)nextX, sound.f_82480_ + yDifference * xPercentChange, sound.f_82481_ + zDifference * xPercentChange);
                if (listenerPos.m_123341_() < soundPos.m_123341_()) {
                    soundPosOffset = new BlockPos(-1, 0, 0);
                }
            } else if (yPercentChange < zPercentChange) {
                sound = new Vec3(sound.f_82479_ + xDifference * yPercentChange, (double)nextY, sound.f_82481_ + zDifference * yPercentChange);
                if (listenerPos.m_123342_() < soundPos.m_123342_()) {
                    soundPosOffset = new BlockPos(0, -1, 0);
                }
            } else {
                sound = new Vec3(sound.f_82479_ + xDifference * zPercentChange, sound.f_82480_ + yDifference * zPercentChange, (double)nextZ);
                if (listenerPos.m_123343_() < soundPos.m_123343_()) {
                    soundPosOffset = new BlockPos(0, 0, -1);
                }
            }
            soundPos = new BlockPos((int)Math.floor(sound.f_82479_), (int)Math.floor(sound.f_82480_), (int)Math.floor(sound.f_82481_));
            if (soundPosOffset != null) {
                soundPos = soundPos.m_121955_((Vec3i)soundPosOffset);
            }
            if (i <= 1) continue;
            BlockState state = world.m_8055_(prevSoundPos);
            Material material = state.m_60767_();
            VoxelShape collisionShape = state.m_60812_((BlockGetter)world, prevSoundPos);
            if (state.m_60795_() || state.m_60808_((BlockGetter)world, prevSoundPos).m_83281_() || collisionShape == Shapes.m_83040_() || (rayTrace = collisionShape.m_83220_(prevSound, listener, prevSoundPos)) == null) continue;
            double d = newOcclusion = material.m_76333_() ? 0.5 : 0.25;
            occludedPercent = occludedPercent > 0.0 ? (occludedPercent += newOcclusion / 4.0) : (occludedPercent += newOcclusion);
            if (!(occludedPercent > 0.98)) continue;
            return 0.98;
        }
        return occludedPercent;
    }

    private SoundOcclusion() {
    }
}

