/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.capture;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sun.jna.Platform;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.sound.sampled.AudioFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.chat.MinecraftTextClickEvent;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.api.chat.MinecraftTextHoverEvent;
import su.plo.lib.api.chat.MinecraftTextStyle;
import su.plo.lib.mod.client.chat.ClientChatUtil;
import su.plo.voice.api.audio.codec.AudioEncoder;
import su.plo.voice.api.audio.codec.CodecException;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.AudioCapture;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.audio.capture.ClientActivationManager;
import su.plo.voice.api.client.audio.device.DeviceManager;
import su.plo.voice.api.client.audio.device.DeviceType;
import su.plo.voice.api.client.audio.device.InputDevice;
import su.plo.voice.api.client.connection.ServerConnection;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureEvent;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureInitializeEvent;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureProcessedEvent;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureStartEvent;
import su.plo.voice.api.client.event.audio.capture.AudioCaptureStopEvent;
import su.plo.voice.api.client.socket.UdpClient;
import su.plo.voice.api.encryption.Encryption;
import su.plo.voice.api.encryption.EncryptionException;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.api.util.Params;
import su.plo.voice.client.audio.filter.StereoToMonoFilter;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.mac.AVAuthorizationStatus;
import su.plo.voice.client.mac.AVCaptureDevice;
import su.plo.voice.proto.data.audio.capture.CaptureInfo;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.player.VoicePlayerInfo;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerAudioEndPacket;
import su.plo.voice.proto.packets.udp.serverbound.PlayerAudioPacket;

public final class VoiceAudioCapture
implements AudioCapture {
    private static final Logger LOGGER = LogManager.getLogger(VoiceAudioCapture.class);
    private final PlasmoVoiceClient voiceClient;
    private final DeviceManager devices;
    private final ClientActivationManager activations;
    private final VoiceClientConfig config;
    private final Set<UUID> activationStreams = Sets.newHashSet();
    private final Map<UUID, Long> activationSequenceNumbers = Maps.newHashMap();
    private AudioEncoder monoEncoder;
    private AudioEncoder stereoEncoder;
    private volatile Encryption encryption;
    private Thread thread;

    public VoiceAudioCapture(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.devices = voiceClient.getDeviceManager();
        this.activations = voiceClient.getActivationManager();
        this.config = config;
    }

    @Override
    public Optional<AudioEncoder> getDefaultMonoEncoder() {
        return Optional.ofNullable(this.monoEncoder);
    }

    @Override
    public Optional<AudioEncoder> getDefaultStereoEncoder() {
        return Optional.ofNullable(this.stereoEncoder);
    }

    @Override
    public Optional<Encryption> getEncryption() {
        return Optional.ofNullable(this.encryption);
    }

    @Override
    public Optional<InputDevice> getDevice() {
        Collection devices = this.devices.getDevices(DeviceType.INPUT);
        return Optional.ofNullable(devices.stream().findFirst().orElse(null));
    }

    @Override
    public void initialize(@NotNull ServerInfo serverInfo) {
        CaptureInfo capture;
        AVAuthorizationStatus authorizationStatus;
        AudioCaptureInitializeEvent event = new AudioCaptureInitializeEvent(this);
        this.voiceClient.getEventBus().call(event);
        if (event.isCancelled()) {
            return;
        }
        if (Platform.isMac() && (authorizationStatus = AVCaptureDevice.INSTANCE.getAuthorizationStatus()) == AVAuthorizationStatus.RESTRICTED) {
            ClientChatUtil.sendChatMessage(MinecraftTextComponent.translatable("message.plasmovoice.macos_incompatible_launcher", MinecraftTextComponent.literal("Prism Launcher").withStyle(MinecraftTextStyle.YELLOW).clickEvent(MinecraftTextClickEvent.clickEvent(MinecraftTextClickEvent.Action.OPEN_URL, "https://prismlauncher.org")).hoverEvent(MinecraftTextHoverEvent.showText(MinecraftTextComponent.literal("https://prismlauncher.org")))));
        }
        AudioFormat format = serverInfo.getVoiceInfo().getFormat((Boolean)this.config.getVoice().getStereoCapture().value());
        if (!this.getDevice().isPresent()) {
            try {
                InputDevice device = this.voiceClient.getDeviceManager().openInputDevice(format, Params.EMPTY);
                this.devices.replace(null, device);
            }
            catch (Exception e) {
                LOGGER.error("Failed to open input device", (Throwable)e);
            }
        }
        if ((capture = serverInfo.getVoiceInfo().getCaptureInfo()).getEncoderInfo() != null) {
            CodecInfo codec = capture.getEncoderInfo();
            Params.Builder params = Params.builder();
            codec.getParams().forEach(params::set);
            this.monoEncoder = serverInfo.createOpusEncoder(false);
            this.stereoEncoder = serverInfo.createOpusEncoder(true);
        }
        if (serverInfo.getEncryption().isPresent()) {
            this.encryption = serverInfo.getEncryption().get();
        }
        LOGGER.info("Audio capture initialized");
    }

    @Override
    public void start() {
        AudioCaptureStartEvent event = new AudioCaptureStartEvent(this);
        this.voiceClient.getEventBus().call(event);
        if (event.isCancelled()) {
            return;
        }
        if (this.thread != null) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.thread = new Thread(this::run);
        this.thread.setName("Voice Audio Capture");
        this.thread.start();
    }

    @Override
    public void stop() {
        AudioCaptureStopEvent event = new AudioCaptureStopEvent(this);
        this.voiceClient.getEventBus().call(event);
        if (event.isCancelled()) {
            return;
        }
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @Override
    public boolean isActive() {
        return this.thread != null;
    }

    @Override
    public boolean isServerMuted() {
        return this.voiceClient.getServerConnection().map(connection -> connection.getClientPlayer().map(VoicePlayerInfo::isMuted).orElse(false)).orElse(false);
    }

    private void run() {
        while (!this.thread.isInterrupted()) {
            try {
                Optional<InputDevice> device = this.getDevice();
                Optional<ServerInfo> serverInfo = this.voiceClient.getServerInfo();
                if (!(device.isPresent() && device.get().isOpen() && this.voiceClient.getUdpClientManager().isConnected() && serverInfo.isPresent() && this.activations.getParentActivation().isPresent())) {
                    Thread.sleep(1000L);
                    continue;
                }
                device.get().start();
                if (!device.get().isStarted()) {
                    Thread.sleep(1000L);
                    continue;
                }
                short[] samples = device.get().read();
                if (samples == null) {
                    Thread.sleep(5L);
                    continue;
                }
                AudioCaptureEvent captureEvent = new AudioCaptureEvent(this, device.get(), samples);
                if (!this.voiceClient.getEventBus().call(captureEvent)) continue;
                ClientActivation parentActivation = this.activations.getParentActivation().get();
                if (captureEvent.isSendEnd() || ((Boolean)this.config.getVoice().getMicrophoneDisabled().value()).booleanValue() || ((Boolean)this.config.getVoice().getDisabled().value()).booleanValue() || this.isServerMuted()) {
                    if (parentActivation.isActive()) {
                        parentActivation.reset();
                        this.sendVoiceEndPacket(parentActivation);
                    }
                    this.activations.getActivations().forEach(activation -> {
                        if (activation.isActive()) {
                            activation.reset();
                            this.sendVoiceEndPacket((ClientActivation)activation);
                        }
                    });
                    this.voiceClient.getEventBus().call(new AudioCaptureProcessedEvent(this, device.get(), samples, null));
                    continue;
                }
                ClientActivation.Result parentResult = parentActivation.process(samples, null);
                EncodedCapture encoded = new EncodedCapture();
                boolean transitiveReached = false;
                for (ClientActivation activation2 : this.activations.getActivations()) {
                    if (activation2.isDisabled() && !activation2.isActive() || activation2.equals(parentActivation)) continue;
                    if (transitiveReached) {
                        activation2.reset();
                        continue;
                    }
                    ClientActivation.Result activationResult = activation2.process(samples, parentResult);
                    if (activation2.getType() == ClientActivation.Type.INHERIT) {
                        this.processActivation(device.get(), activation2, activationResult, samples, encoded);
                    } else if (activation2.getType() == ClientActivation.Type.VOICE) {
                        this.processActivation(device.get(), activation2, activationResult, samples, encoded);
                    } else {
                        this.processActivation(device.get(), activation2, activationResult, samples, encoded);
                    }
                    if (!activationResult.isActivated() || activation2.isTransitive()) continue;
                    transitiveReached = true;
                }
                if (parentActivation.getId().equals(VoiceActivation.PROXIMITY_ID)) {
                    if (!transitiveReached) {
                        this.processActivation(device.get(), parentActivation, parentResult, samples, encoded);
                    } else if (this.activationStreams.remove(parentActivation.getId())) {
                        this.processActivation(device.get(), parentActivation, ClientActivation.Result.END, null, encoded);
                    }
                }
                this.voiceClient.getEventBus().call(new AudioCaptureProcessedEvent(this, device.get(), samples, encoded.monoProcessed));
            }
            catch (InterruptedException ignored) {
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        this.cleanup();
    }

    private void cleanup() {
        Optional<InputDevice> device;
        this.activationSequenceNumbers.clear();
        if (this.monoEncoder != null) {
            this.monoEncoder.close();
        }
        if (this.stereoEncoder != null) {
            this.stereoEncoder.close();
        }
        if ((device = this.getDevice()).isPresent() && device.get().isOpen()) {
            device.get().close();
            this.devices.remove(device.get());
        }
        this.thread = null;
    }

    private void processActivation(@NotNull InputDevice device, @NotNull ClientActivation activation, @NotNull ClientActivation.Result result, short[] samples, @NotNull EncodedCapture encoded) {
        byte[] encodedData;
        boolean isStereo;
        boolean bl = isStereo = (Boolean)this.config.getVoice().getStereoCapture().value() != false && activation.isStereoSupported();
        if (result.isActivated() && samples != null) {
            if (isStereo && encoded.stereo == null) {
                processedSamples = new short[samples.length];
                System.arraycopy(samples, 0, processedSamples, 0, samples.length);
                AudioEncoder stereoEncoder = activation.getStereoEncoder().orElse(this.stereoEncoder);
                processedSamples = device.processFilters(processedSamples, filter -> filter instanceof StereoToMonoFilter);
                encoded.stereoProcessed = processedSamples;
                encoded.stereo = this.encode(stereoEncoder, processedSamples);
            } else if (!isStereo && encoded.mono == null) {
                processedSamples = new short[samples.length];
                System.arraycopy(samples, 0, processedSamples, 0, samples.length);
                AudioEncoder monoEncoder = activation.getMonoEncoder().orElse(this.monoEncoder);
                processedSamples = device.processFilters(processedSamples);
                encoded.monoProcessed = processedSamples;
                encoded.mono = this.encode(monoEncoder, processedSamples);
            }
        }
        byte[] byArray = encodedData = isStereo ? encoded.stereo : encoded.mono;
        if (result == ClientActivation.Result.ACTIVATED) {
            this.sendVoicePacket(activation, isStereo, encodedData);
            this.activationStreams.add(activation.getId());
        } else if (result == ClientActivation.Result.END) {
            if (encodedData != null) {
                this.sendVoicePacket(activation, isStereo, encodedData);
            }
            this.sendVoiceEndPacket(activation);
            this.activationStreams.remove(activation.getId());
        }
    }

    private byte[] encode(@Nullable AudioEncoder encoder, short[] samples) {
        byte[] encoded;
        if (encoder != null) {
            try {
                encoded = encoder.encode(samples);
            }
            catch (CodecException e) {
                LOGGER.error("Failed to encode audio data", (Throwable)e);
                return null;
            }
        } else {
            encoded = AudioUtil.shortsToBytes(samples);
        }
        if (this.encryption != null) {
            try {
                encoded = this.encryption.encrypt(encoded);
            }
            catch (EncryptionException e) {
                LOGGER.error("Failed to encrypt audio data", (Throwable)e);
                return null;
            }
        }
        return encoded;
    }

    private void sendVoicePacket(@NotNull ClientActivation activation, boolean isStereo, byte[] encoded) {
        if (activation.getTranslation().equals("pv.activation.parent")) {
            return;
        }
        Optional<UdpClient> udpClient = this.voiceClient.getUdpClientManager().getClient();
        if (!udpClient.isPresent()) {
            return;
        }
        udpClient.get().sendPacket(new PlayerAudioPacket(this.getSequenceNumber(activation), encoded, activation.getId(), (short)activation.getDistance(), isStereo));
    }

    private void sendVoiceEndPacket(ClientActivation activation) {
        Optional<ServerConnection> connection;
        if (activation.getTranslation().equals("pv.activation.parent")) {
            return;
        }
        if (this.monoEncoder != null) {
            this.monoEncoder.reset();
        }
        if (this.stereoEncoder != null) {
            this.stereoEncoder.reset();
        }
        if (!(connection = this.voiceClient.getServerConnection()).isPresent()) {
            return;
        }
        connection.get().sendPacket(new PlayerAudioEndPacket(this.getSequenceNumber(activation), activation.getId(), (short)activation.getDistance()));
    }

    private long getSequenceNumber(@NotNull ClientActivation activation) {
        long sequenceNumber = this.activationSequenceNumbers.getOrDefault(activation.getId(), 0L) + 1L;
        this.activationSequenceNumbers.put(activation.getId(), sequenceNumber);
        return sequenceNumber;
    }

    public void setEncryption(Encryption encryption) {
        this.encryption = encryption;
    }

    static class EncodedCapture {
        private byte[] mono;
        private short[] monoProcessed;
        private byte[] stereo;
        private short[] stereoProcessed;

        EncodedCapture() {
        }
    }
}

