/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.capture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.Config;
import su.plo.config.entry.BooleanConfigEntry;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.audio.codec.AudioEncoder;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.config.keybind.KeyBinding;
import su.plo.voice.api.client.connection.ServerInfo;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.config.capture.ConfigClientActivation;
import su.plo.voice.client.config.keybind.ConfigKeyBindings;
import su.plo.voice.client.config.keybind.KeyBindingConfigEntry;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.capture.CaptureInfo;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.packets.tcp.serverbound.PlayerActivationDistancesPacket;
import su.plo.voice.universal.UChat;

@Config
public final class VoiceClientActivation
extends VoiceActivation
implements ClientActivation {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final IntConfigEntry configDistance;
    private final ConfigEntry<ClientActivation.Type> configType;
    private final BooleanConfigEntry configToggle;
    private final KeyBindingConfigEntry pttKey;
    private final KeyBindingConfigEntry toggleKey;
    private final KeyBindingConfigEntry distanceIncreaseKey;
    private final KeyBindingConfigEntry distanceDecreaseKey;
    private final AtomicBoolean disabled = new AtomicBoolean(false);
    private boolean active;
    private long lastActivation;
    @Nullable
    private AudioEncoder monoEncoder;
    @Nullable
    private AudioEncoder stereoEncoder;

    public VoiceClientActivation(@NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull ConfigClientActivation activationConfig, @NotNull IntConfigEntry activationDistance, @NotNull Activation activation, @NotNull String icon) {
        super(activation.getName(), activation.getTranslation(), icon, new ArrayList<Integer>(activation.getDistances()), activation.getDefaultDistance(), activation.isProximity(), activation.isStereoSupported(), activation.isTransitive(), activation.getEncoderInfo().orElse(null), activation.getWeight());
        this.voiceClient = voiceClient;
        this.config = config;
        ConfigKeyBindings hotKeys = config.getKeyBindings();
        this.configDistance = activationDistance;
        this.configType = activationConfig.getConfigType();
        this.configToggle = activationConfig.getConfigToggle();
        this.pttKey = this.createHotKey(hotKeys, activation, "ptt", true);
        this.toggleKey = this.createHotKey(hotKeys, activation, "toggle", false);
        this.distanceIncreaseKey = this.createHotKey(hotKeys, activation, "distance_increase", false);
        this.distanceDecreaseKey = this.createHotKey(hotKeys, activation, "distance_decrease", false);
        ((KeyBinding)this.toggleKey.value()).clearPressListener();
        ((KeyBinding)this.toggleKey.value()).addPressListener(this::onToggle);
        ((KeyBinding)this.distanceIncreaseKey.value()).clearPressListener();
        ((KeyBinding)this.distanceIncreaseKey.value()).addPressListener(this::onDistanceIncrease);
        ((KeyBinding)this.distanceDecreaseKey.value()).clearPressListener();
        ((KeyBinding)this.distanceDecreaseKey.value()).addPressListener(this::onDistanceDecrease);
        this.configDistance.clearChangeListeners();
        this.configDistance.addChangeListener(this::onDistanceChange);
        if (this.encoderInfo != null) {
            CaptureInfo captureInfo = voiceClient.getServerInfo().map(ServerInfo::getVoiceInfo).map(ServerInfo.VoiceInfo::getCaptureInfo).orElseThrow(() -> new IllegalStateException("not connected to voice server"));
            int sampleRate = captureInfo.getSampleRate();
            this.monoEncoder = voiceClient.getCodecManager().createEncoder(this.encoderInfo, captureInfo.getSampleRate(), false, sampleRate / 1000 * 20, captureInfo.getMtuSize());
            this.stereoEncoder = voiceClient.getCodecManager().createEncoder(this.encoderInfo, captureInfo.getSampleRate(), true, sampleRate / 1000 * 20, captureInfo.getMtuSize());
        }
    }

    @Override
    public ClientActivation.Type getType() {
        return this.configType.value();
    }

    @Override
    public KeyBinding getPttKey() {
        return (KeyBinding)this.pttKey.value();
    }

    public KeyBindingConfigEntry getPttConfigEntry() {
        return this.pttKey;
    }

    @Override
    public KeyBinding getToggleKey() {
        return (KeyBinding)this.toggleKey.value();
    }

    @Override
    public KeyBinding getDistanceIncreaseKey() {
        return (KeyBinding)this.distanceIncreaseKey.value();
    }

    public KeyBindingConfigEntry getDistanceIncreaseConfigEntry() {
        return this.distanceIncreaseKey;
    }

    @Override
    public KeyBinding getDistanceDecreaseKey() {
        return (KeyBinding)this.distanceDecreaseKey.value();
    }

    @Override
    public Optional<AudioEncoder> getMonoEncoder() {
        return Optional.ofNullable(this.monoEncoder);
    }

    @Override
    public Optional<AudioEncoder> getStereoEncoder() {
        return Optional.ofNullable(this.stereoEncoder);
    }

    public KeyBindingConfigEntry getDistanceDecreaseConfigEntry() {
        return this.distanceDecreaseKey;
    }

    public KeyBindingConfigEntry getToggleConfigEntry() {
        return this.toggleKey;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled.set(disabled);
    }

    @Override
    public boolean isDisabled() {
        return this.getType() == ClientActivation.Type.VOICE && (Boolean)this.configToggle.value() != false || this.disabled.get();
    }

    @Override
    public int getDistance() {
        return (Integer)this.configDistance.value();
    }

    @Override
    @NotNull
    public ClientActivation.Result process(short[] samples, @Nullable ClientActivation.Result result) {
        if (this.isDisabled()) {
            if (this.active) {
                this.active = false;
                return ClientActivation.Result.END;
            }
            return ClientActivation.Result.NOT_ACTIVATED;
        }
        if (this.getType() == ClientActivation.Type.PUSH_TO_TALK) {
            return this.handlePTT();
        }
        if (this.getType() == ClientActivation.Type.VOICE) {
            return this.handleVoice(samples, result);
        }
        if (this.getType() == ClientActivation.Type.INHERIT) {
            return this.handleInherit(result);
        }
        return ClientActivation.Result.NOT_ACTIVATED;
    }

    @Override
    public void reset() {
        this.active = false;
        this.lastActivation = 0L;
    }

    @Override
    public void cleanup() {
        this.getMonoEncoder().ifPresent(AudioEncoder::close);
        this.getStereoEncoder().ifPresent(AudioEncoder::close);
        ((KeyBinding)this.toggleKey.value()).clearPressListener();
        ((KeyBinding)this.distanceIncreaseKey.value()).clearPressListener();
        ((KeyBinding)this.distanceDecreaseKey.value()).clearPressListener();
        this.configDistance.clearChangeListeners();
        this.monoEncoder = null;
        this.stereoEncoder = null;
    }

    @NotNull
    private ClientActivation.Result handlePTT() {
        boolean pressed = this.getPttKey().isPressed();
        if (pressed) {
            if (!this.active) {
                this.active = true;
            }
            this.lastActivation = System.currentTimeMillis();
        } else if (this.active && System.currentTimeMillis() - this.lastActivation > 350L) {
            this.active = false;
            return ClientActivation.Result.END;
        }
        return this.active ? ClientActivation.Result.ACTIVATED : ClientActivation.Result.NOT_ACTIVATED;
    }

    @NotNull
    private ClientActivation.Result handleVoice(short[] samples, @Nullable ClientActivation.Result result) {
        if (((Boolean)this.configToggle.value()).booleanValue()) {
            if (this.active) {
                this.active = false;
                return ClientActivation.Result.END;
            }
            return ClientActivation.Result.NOT_ACTIVATED;
        }
        if (result != null) {
            if (result == ClientActivation.Result.ACTIVATED) {
                this.active = true;
                this.lastActivation = System.currentTimeMillis();
                return result;
            }
            if (result == ClientActivation.Result.END) {
                this.active = false;
                return result;
            }
        }
        boolean lastActivated = System.currentTimeMillis() - this.lastActivation <= 500L;
        boolean voiceDetected = AudioUtil.containsMinAudioLevel(samples, (double)((Double)this.config.getVoice().getActivationThreshold().value()));
        if (lastActivated || voiceDetected) {
            if (voiceDetected) {
                this.lastActivation = System.currentTimeMillis();
            }
            if (!this.active) {
                this.active = true;
            }
            return ClientActivation.Result.ACTIVATED;
        }
        if (this.active) {
            this.active = false;
            return ClientActivation.Result.END;
        }
        return ClientActivation.Result.NOT_ACTIVATED;
    }

    @NotNull
    private ClientActivation.Result handleInherit(@Nullable ClientActivation.Result result) {
        if (result == null) {
            return ClientActivation.Result.NOT_ACTIVATED;
        }
        if (((Boolean)this.configToggle.value()).booleanValue()) {
            if (this.active) {
                this.active = false;
                return ClientActivation.Result.END;
            }
            return ClientActivation.Result.NOT_ACTIVATED;
        }
        boolean bl = this.active = result == ClientActivation.Result.ACTIVATED;
        if (this.active) {
            this.lastActivation = System.currentTimeMillis();
        }
        return result;
    }

    private void onToggle(@NotNull KeyBinding.Action action) {
        if (action != KeyBinding.Action.DOWN || this.getType() == ClientActivation.Type.PUSH_TO_TALK) {
            return;
        }
        this.configToggle.invert();
        UChat.actionBar(RenderUtil.getTextConverter().convert(MinecraftTextComponent.translatable("message.plasmovoice.activation.toggle", MinecraftTextComponent.translatable(this.translation, new Object[0]), (Boolean)this.configToggle.value() == false ? MinecraftTextComponent.translatable("message.plasmovoice.on", new Object[0]) : MinecraftTextComponent.translatable("message.plasmovoice.off", new Object[0]))));
    }

    private void onDistanceIncrease(@NotNull KeyBinding.Action action) {
        if (action != KeyBinding.Action.DOWN) {
            return;
        }
        int index = (this.distances.indexOf(this.getDistance()) + 1) % this.distances.size();
        this.configDistance.set((Integer)this.distances.get(index));
        this.sendDistanceChangedMessage();
    }

    private void onDistanceDecrease(@NotNull KeyBinding.Action action) {
        if (action != KeyBinding.Action.DOWN) {
            return;
        }
        int index = this.distances.indexOf(this.getDistance()) - 1;
        if (index < 0) {
            index = this.distances.size() - 1;
        }
        this.configDistance.set((Integer)this.distances.get(index));
        this.sendDistanceChangedMessage();
    }

    private void onDistanceChange(int distance) {
        this.voiceClient.getServerConnection().ifPresent(connection -> {
            HashMap distanceByActivationId = Maps.newHashMap();
            distanceByActivationId.put(this.id, distance);
            connection.sendPacket(new PlayerActivationDistancesPacket(distanceByActivationId));
        });
    }

    private void sendDistanceChangedMessage() {
        UChat.actionBar(RenderUtil.getTextConverter().convert(MinecraftTextComponent.translatable("message.plasmovoice.distance_changed", MinecraftTextComponent.translatable(this.translation, new Object[0]), this.getDistance())));
    }

    private KeyBindingConfigEntry createHotKey(@NotNull ConfigKeyBindings hotKeys, @NotNull Activation activation, @NotNull String suffix, boolean anyContext) {
        String keyName = "key.plasmovoice." + activation.getName() + "." + suffix;
        Optional<KeyBindingConfigEntry> key = hotKeys.getConfigKeyBinding(keyName);
        if (!key.isPresent()) {
            hotKeys.register(keyName, (List<KeyBinding.Key>)ImmutableList.of(), "hidden", anyContext);
            key = hotKeys.getConfigKeyBinding(keyName);
        }
        if (!key.isPresent()) {
            throw new IllegalStateException("Failed to register keybinding " + activation.getName() + "." + suffix);
        }
        return key.get();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public long getLastActivation() {
        return this.lastActivation;
    }
}

