/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.codec.opus;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.audio.codec.CodecSupplier;
import su.plo.voice.client.audio.codec.opus.BaseOpusDecoder;
import su.plo.voice.client.audio.codec.opus.BaseOpusEncoder;
import su.plo.voice.client.audio.codec.opus.JavaOpusDecoder;
import su.plo.voice.client.audio.codec.opus.JavaOpusEncoder;
import su.plo.voice.client.audio.codec.opus.NativeOpusDecoder;
import su.plo.voice.client.audio.codec.opus.NativeOpusEncoder;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.codec.opus.OpusEncoderInfo;

public final class OpusCodecSupplier
implements CodecSupplier<BaseOpusEncoder, BaseOpusDecoder> {
    @Override
    @NotNull
    public BaseOpusEncoder createEncoder(int sampleRate, boolean stereo, int bufferSize, int mtuSize, @NotNull CodecInfo codecInfo) {
        BaseOpusEncoder encoder;
        OpusEncoderInfo opusEncoderInfo;
        try {
            opusEncoderInfo = new OpusEncoderInfo(codecInfo);
        }
        catch (IOException e) {
            throw new IllegalStateException("Bad codec info received", e);
        }
        try {
            Class.forName("su.plo.opus.Opus");
            encoder = new NativeOpusEncoder(sampleRate, stereo, bufferSize, opusEncoderInfo.getMode(), mtuSize);
            encoder.open();
        }
        catch (ClassNotFoundException ignored) {
            encoder = null;
        }
        catch (Exception | LinkageError e) {
            encoder = null;
            BaseVoice.LOGGER.warn("Failed to load native opus. Falling back to pure java impl", e);
        }
        if (encoder == null) {
            try {
                encoder = new JavaOpusEncoder(sampleRate, stereo, bufferSize, opusEncoderInfo.getMode(), mtuSize);
                encoder.open();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to open java opus encoder", e);
            }
        }
        encoder.setBitrate(opusEncoderInfo.getBitrate());
        BaseVoice.LOGGER.info("Opus encoder bitrate is {}", (Object)encoder.getBitrate());
        return encoder;
    }

    @Override
    @NotNull
    public BaseOpusDecoder createDecoder(int sampleRate, boolean stereo, int bufferSize, int mtuSize, @NotNull CodecInfo codecInfo) {
        try {
            Class.forName("su.plo.opus.Opus");
            NativeOpusDecoder decoder = new NativeOpusDecoder(sampleRate, stereo, bufferSize, mtuSize);
            decoder.open();
            return decoder;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception | LinkageError e) {
            BaseVoice.LOGGER.warn("Failed to load native opus. Falling back to pure java impl", e);
        }
        try {
            JavaOpusDecoder decoder = new JavaOpusDecoder(sampleRate, stereo, bufferSize, mtuSize);
            decoder.open();
            return decoder;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to open java opus encoder", e);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return "opus";
    }
}

