/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.line;

import com.google.common.collect.Sets;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.voice.api.client.audio.line.ClientSourceLine;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.proto.data.audio.line.VoiceSourceLine;
import su.plo.voice.proto.data.player.MinecraftGameProfile;

public class VoiceClientSourceLine
extends VoiceSourceLine
implements ClientSourceLine {
    private final DoubleConfigEntry volumeEntry;

    public VoiceClientSourceLine(@NotNull DoubleConfigEntry volumeEntry, @NotNull SourceLine line, @NotNull String icon) {
        super(line.getName(), line.getTranslation(), icon, line.getDefaultVolume(), line.getWeight(), line.hasPlayers() ? Sets.newConcurrentHashSet(line.getPlayers()) : null);
        this.volumeEntry = volumeEntry;
    }

    @Override
    public void setVolume(double volume) {
        this.volumeEntry.set(volume);
    }

    @Override
    public double getVolume() {
        return this.volumeEntry.getMax();
    }

    public DoubleConfigEntry getVolumeConfigEntry() {
        return this.volumeEntry;
    }

    @Override
    public void addPlayer(@NotNull MinecraftGameProfile playerId) {
        if (this.players == null) {
            this.players = Sets.newConcurrentHashSet();
        }
        this.players.add(playerId);
    }

    @Override
    public boolean removePlayer(@NotNull UUID playerId) {
        return this.players.removeIf(player -> player.getId().equals(playerId));
    }

    @Override
    public void clearPlayers() {
        this.players.clear();
    }
}

