/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.device.AlAudioDevice;
import su.plo.voice.api.client.audio.device.DeviceException;
import su.plo.voice.api.client.audio.device.DeviceType;
import su.plo.voice.api.client.audio.device.source.AlSource;
import su.plo.voice.api.client.audio.device.source.DeviceSource;
import su.plo.voice.api.client.audio.device.source.SourceGroup;
import su.plo.voice.api.client.audio.source.LoopbackSource;
import su.plo.voice.api.util.AudioUtil;
import su.plo.voice.api.util.Params;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.universal.UMinecraft;

public final class ClientLoopbackSource
implements LoopbackSource {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;
    private final boolean relative;
    private final float[] position = new float[3];
    private SourceGroup sourceGroup;
    private boolean stereo;
    private DoubleConfigEntry volumeEntry;

    @Override
    public Optional<SourceGroup> getSourceGroup() {
        return Optional.ofNullable(this.sourceGroup);
    }

    @Override
    public void initialize(boolean stereo) throws DeviceException {
        this.stereo = stereo;
        this.sourceGroup = this.voiceClient.getDeviceManager().createSourceGroup(DeviceType.OUTPUT);
        this.sourceGroup.create(stereo, Params.EMPTY);
        for (DeviceSource source : this.sourceGroup.getSources()) {
            if (!(source instanceof AlSource)) continue;
            AlSource alSource = (AlSource)source;
            alSource.setCloseTimeoutMs(0L);
            AlAudioDevice device = alSource.getDevice();
            device.runInContextBlocking(() -> {
                alSource.setFloat(4110, 4.0f);
                if (this.relative) {
                    alSource.setInt(514, 1);
                }
                alSource.play();
            });
        }
    }

    @Override
    public void close() {
        if (this.sourceGroup == null) {
            return;
        }
        this.sourceGroup.clear();
    }

    @Override
    public void write(short[] samples) {
        if (this.sourceGroup == null) {
            return;
        }
        if (!this.relative) {
            LocalPlayer player = UMinecraft.getPlayer();
            if (player == null) {
                return;
            }
            this.position[0] = (float)player.m_20185_();
            this.position[1] = (float)(player.m_20186_() + (double)player.m_20192_());
            this.position[2] = (float)player.m_20189_();
        }
        float volume = ((Double)this.config.getVoice().getVolume().value()).floatValue();
        if (this.volumeEntry != null) {
            volume *= ((Double)this.volumeEntry.value()).floatValue();
        }
        if (((Boolean)this.config.getAdvanced().getExponentialVolumeSlider().value()).booleanValue()) {
            volume = (float)Math.pow(volume, 3.0);
        }
        this.updateSources(volume);
        for (DeviceSource source : this.sourceGroup.getSources()) {
            samples = source.getDevice().processFilters(samples);
            source.write(AudioUtil.shortsToBytes(samples));
        }
    }

    private void updateSources(float volume) {
        for (DeviceSource source : this.sourceGroup.getSources()) {
            if (!(source instanceof AlSource)) continue;
            AlSource alSource = (AlSource)source;
            AlAudioDevice device = alSource.getDevice();
            device.runInContextBlocking(() -> {
                alSource.setVolume(volume);
                if (!this.relative) {
                    alSource.setFloatArray(4100, this.position);
                }
            });
        }
    }

    public ClientLoopbackSource(PlasmoVoiceClient voiceClient, VoiceClientConfig config, boolean relative) {
        this.voiceClient = voiceClient;
        this.config = config;
        this.relative = relative;
    }

    @Override
    public boolean isStereo() {
        return this.stereo;
    }

    @Override
    public void setVolumeEntry(DoubleConfigEntry volumeEntry) {
        this.volumeEntry = volumeEntry;
    }
}

