/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.audio.source;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.client.BaseVoiceClient;
import su.plo.voice.client.audio.source.BaseClientAudioSource;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.utils.MathKt;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.data.audio.source.StaticSourceInfo;
import su.plo.voice.proto.data.pos.Pos3d;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lsu/plo/voice/client/audio/source/ClientStaticSource;", "Lsu/plo/voice/client/audio/source/BaseClientAudioSource;", "Lsu/plo/voice/proto/data/audio/source/StaticSourceInfo;", "voiceClient", "Lsu/plo/voice/client/BaseVoiceClient;", "config", "Lsu/plo/voice/client/config/VoiceClientConfig;", "sourceInfo", "(Lsu/plo/voice/client/BaseVoiceClient;Lsu/plo/voice/client/config/VoiceClientConfig;Lsu/plo/voice/proto/data/audio/source/StaticSourceInfo;)V", "getLookAngle", "Lnet/minecraft/world/phys/Vec3;", "getPosition", "client"})
public final class ClientStaticSource
extends BaseClientAudioSource<StaticSourceInfo> {
    public ClientStaticSource(@NotNull BaseVoiceClient voiceClient, @NotNull VoiceClientConfig config, @NotNull StaticSourceInfo sourceInfo) {
        Intrinsics.checkNotNullParameter((Object)voiceClient, (String)"voiceClient");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)sourceInfo, (String)"sourceInfo");
        super(voiceClient, config, (SourceInfo)sourceInfo);
    }

    @Override
    @NotNull
    protected Vec3 getPosition() {
        Pos3d pos3d = ((StaticSourceInfo)this.getSourceInfo()).getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)pos3d, (String)"sourceInfo.position");
        return MathKt.toVec3(pos3d);
    }

    @Override
    @NotNull
    protected Vec3 getLookAngle() {
        Pos3d pos3d = ((StaticSourceInfo)this.getSourceInfo()).getLookAngle();
        Intrinsics.checkNotNullExpressionValue((Object)pos3d, (String)"sourceInfo.lookAngle");
        return MathKt.toVec3(pos3d);
    }
}

