/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.config.keybind;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.client.config.keybind.KeyBinding;
import su.plo.voice.api.client.config.keybind.KeyBindings;

public final class VoiceKeyBinding
implements KeyBinding {
    private final Set<KeyBinding.OnPress> onPress = new CopyOnWriteArraySet<KeyBinding.OnPress>();
    private final Set<KeyBinding.OnKeysChange> onKeysChange = new CopyOnWriteArraySet<KeyBinding.OnKeysChange>();
    private final KeyBindings keyBindings;
    private final String name;
    private final Set<KeyBinding.Key> keys = new CopyOnWriteArraySet<KeyBinding.Key>();
    private final boolean anyContext;
    private boolean pressed;

    public VoiceKeyBinding(@NotNull KeyBindings keyBindings, @NotNull String name, @NotNull List<KeyBinding.Key> keys, boolean anyContext) {
        this.keyBindings = (KeyBindings)Preconditions.checkNotNull((Object)keyBindings, (Object)"keyBindings");
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull(keys, (Object)"keys");
        this.keys.addAll(keys);
        this.anyContext = anyContext;
    }

    @Override
    public Set<KeyBinding.Key> getKeys() {
        return this.keys;
    }

    @Override
    public void setKeys(@NotNull Set<KeyBinding.Key> newKeys) {
        this.keys.clear();
        this.keys.addAll(newKeys);
        this.onKeysChange.forEach(action -> action.onKeysChange(newKeys));
        this.resetState();
    }

    @Override
    public void resetState() {
        this.pressed = false;
    }

    @Override
    public void updateState(@NotNull KeyBinding.Action keyAction) {
        if (this.getKeys().size() > 0) {
            if (keyAction == KeyBinding.Action.DOWN && !this.pressed && this.keyBindings.getPressedKeys().containsAll(this.keys)) {
                this.pressed = true;
                this.onPress.forEach(action -> action.onPress(KeyBinding.Action.DOWN));
            } else if (this.pressed && !this.keyBindings.getPressedKeys().containsAll(this.keys)) {
                this.pressed = false;
                this.onPress.forEach(action -> action.onPress(KeyBinding.Action.UP));
            }
        }
    }

    @Override
    public void addPressListener(@NotNull KeyBinding.OnPress onPress) {
        this.onPress.add(onPress);
    }

    @Override
    public void removePressListener(@NotNull KeyBinding.OnPress onPress) {
        this.onPress.remove(onPress);
    }

    @Override
    public void clearPressListener() {
        this.onPress.clear();
    }

    @Override
    public void addKeysChangeListener(@NotNull KeyBinding.OnKeysChange onKeysChange) {
        this.onKeysChange.add(onKeysChange);
    }

    @Override
    public void removeKeysChangeListener(@NotNull KeyBinding.OnKeysChange onKeysChange) {
        this.onKeysChange.remove(onKeysChange);
    }

    @NotNull
    public VoiceKeyBinding copy() {
        return new VoiceKeyBinding(this.keyBindings, this.name, new ArrayList<KeyBinding.Key>(this.keys), this.anyContext);
    }

    @Override
    public void clearKeysChangeListeners() {
        this.onKeysChange.clear();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof KeyBinding) {
            KeyBinding keyBinding = (KeyBinding)object;
            return this.hashCode() == keyBinding.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.keys.hashCode());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAnyContext() {
        return this.anyContext;
    }

    @Override
    public boolean isPressed() {
        return this.pressed;
    }
}

