/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.EnumConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.gui.screen.ScreenWrapper;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UKeyboard;
import su.plo.voice.universal.UMatrixStack;

public abstract class HudPositionScreen<E extends Enum<E>>
extends GuiScreen {
    protected static final int BUTTON_OFFSET = 25;
    protected static final int BUTTON_WIDTH = 100;
    protected final VoiceSettingsScreen parent;
    protected final EnumConfigEntry<E> entry;
    protected final MinecraftTextComponent chooseText;

    public HudPositionScreen(@NotNull VoiceSettingsScreen parent, @NotNull EnumConfigEntry<E> entry, @NotNull MinecraftTextComponent chooseText) {
        this.parent = parent;
        this.entry = entry;
        this.chooseText = chooseText;
    }

    @Override
    public void render(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        this.screen.renderBackground(stack);
        super.render(stack, mouseX, mouseY, delta);
        RenderUtil.drawString(stack, this.chooseText, this.screen.f_96543_ / 2 - RenderUtil.getTextWidth(this.chooseText) / 2, this.screen.f_96544_ / 2 - UGraphics.getFontHeight(), 0xFFFFFF);
    }

    @Override
    public boolean keyPressed(int keyCode, @Nullable UKeyboard.Modifiers modifiers) {
        if (keyCode == UKeyboard.KEY_ESCAPE) {
            this.parent.setPreventEscClose(true);
            ScreenWrapper.openScreen(this.parent);
            return true;
        }
        return super.keyPressed(keyCode, modifiers);
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    protected abstract Button createPositionButton(int var1, int var2, E var3);
}

