/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.particle.BlockDustParticle2D;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;
import su.plo.voice.universal.USound;
import su.plo.voice.util.RandomUtil;

public final class VoiceSettingsAboutFeature {
    private static final ResourceLocation LOCATION_BLOCKS = new ResourceLocation("textures/atlas/blocks.png");
    private final VoiceSettingsScreen parent;
    private final List<BlockDustParticle2D> particles = Lists.newArrayList();
    private int clickCount;
    private long lastClick;

    public void tick() {
        this.particles.removeAll(this.particles.stream().filter(particle -> {
            particle.tick();
            return !particle.isAlive();
        }).collect(Collectors.toList()));
        if (System.currentTimeMillis() - this.lastClick > 5000L) {
            this.clickCount = 0;
        }
    }

    public void titleClicked() {
        if (this.clickCount > 10) {
            this.parent.getNavigation().openTab(-1);
            this.lastClick = 0L;
            this.clickCount = 0;
            USound.INSTANCE.playButtonPress();
            return;
        }
        this.lastClick = System.currentTimeMillis();
        ++this.clickCount;
        USound.INSTANCE.playSoundStatic(SoundEvents.f_11995_, 1.0f, 1.0f);
        for (int i = 0; i < 2 + RandomUtil.randomInt(3); ++i) {
            BlockDustParticle2D particle = new BlockDustParticle2D(14 + RandomUtil.randomInt(this.parent.getTitleWidth()), 15 + RandomUtil.randomInt(UGraphics.getFontHeight()), 0.0, 0.0, Blocks.f_50493_.m_49966_());
            particle.setMaxAge(10 + RandomUtil.randomInt(25));
            particle.setVelocity(RandomUtil.randomFloat(-0.25f, 0.25f), -0.25);
            particle.setGravityStrength(4.0f);
            particle.setScale(RandomUtil.randomFloat(1.5f, 2.5f));
            this.particles.add(particle);
        }
    }

    public void render(@NotNull UMatrixStack stack, float delta) {
        UGraphics buffer = UGraphics.getFromTessellator();
        for (BlockDustParticle2D particle : this.particles) {
            UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
            UGraphics.depthFunc(515);
            UGraphics.disableDepth();
            UGraphics.enableBlend();
            RenderUtil.defaultBlendFunc();
            UGraphics.depthMask(true);
            UGraphics.bindTexture(0, LOCATION_BLOCKS);
            buffer.beginWithDefaultShader(UGraphics.DrawMode.QUADS, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR);
            particle.buildGeometry(stack, buffer, delta);
            buffer.drawDirect();
        }
    }

    public VoiceSettingsAboutFeature(VoiceSettingsScreen parent) {
        this.parent = parent;
    }
}

