/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.EnumConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.screen.ScreenWrapper;
import su.plo.voice.api.client.config.overlay.OverlayPosition;
import su.plo.voice.client.gui.settings.HudPositionScreen;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;

public final class OverlayPositionScreen
extends HudPositionScreen<OverlayPosition> {
    private final OverlayPosition disabledPosition;

    public OverlayPositionScreen(@NotNull VoiceSettingsScreen parent, @NotNull EnumConfigEntry<OverlayPosition> entry, @Nullable OverlayPosition disabledPosition) {
        super(parent, entry, MinecraftTextComponent.translatable("gui.plasmovoice.overlay.position.choose", new Object[0]));
        this.disabledPosition = disabledPosition;
    }

    @Override
    public void init() {
        super.init();
        int width = this.screen.f_96543_;
        int height = this.screen.f_96544_;
        this.addRenderWidget(this.createPositionButton(25, 25, OverlayPosition.TOP_LEFT));
        this.addRenderWidget(this.createPositionButton(width - 25 - 100, 25, OverlayPosition.TOP_RIGHT));
        this.addRenderWidget(this.createPositionButton(25, height - 20 - 25, OverlayPosition.BOTTOM_LEFT));
        this.addRenderWidget(this.createPositionButton(width - 25 - 100, height - 20 - 25, OverlayPosition.BOTTOM_RIGHT));
    }

    @Override
    protected Button createPositionButton(int x, int y, OverlayPosition overlayPosition) {
        Button button = new Button(x, y, 100, 20, MinecraftTextComponent.translatable(overlayPosition.getTranslation(), new Object[0]), btn -> {
            this.entry.set(overlayPosition);
            ScreenWrapper.openScreen(null);
        }, Button.NO_TOOLTIP);
        button.setActive(overlayPosition != this.disabledPosition);
        return button;
    }
}

