/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.tab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.config.entry.ConfigEntry;
import su.plo.config.entry.DoubleConfigEntry;
import su.plo.config.entry.IntConfigEntry;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.AbstractScrollbar;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.gui.components.IconButton;
import su.plo.lib.mod.client.gui.components.TextFieldWidget;
import su.plo.lib.mod.client.gui.widget.GuiAbstractWidget;
import su.plo.lib.mod.client.gui.widget.GuiWidgetListener;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.gui.settings.VoiceSettingsScreen;
import su.plo.voice.client.gui.settings.widget.DropDownWidget;
import su.plo.voice.client.gui.settings.widget.HotKeyWidget;
import su.plo.voice.client.gui.settings.widget.IntSliderWidget;
import su.plo.voice.client.gui.settings.widget.ToggleButton;
import su.plo.voice.client.gui.settings.widget.UpdatableWidget;
import su.plo.voice.client.gui.settings.widget.VolumeSliderWidget;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;

public abstract class TabWidget
extends AbstractScrollbar<VoiceSettingsScreen> {
    protected static final int ELEMENT_WIDTH = 124;
    protected final PlasmoVoiceClient voiceClient;
    protected final VoiceClientConfig config;

    public TabWidget(@NotNull VoiceSettingsScreen parent, @NotNull PlasmoVoiceClient voiceClient, @NotNull VoiceClientConfig config) {
        super(parent, 303, 0, 0);
        this.voiceClient = voiceClient;
        this.config = config;
    }

    public void tick() {
        for (AbstractScrollbar.Entry entry : this.entries) {
            for (GuiWidgetListener guiWidgetListener : entry.widgets()) {
                if (!(guiWidgetListener instanceof TextFieldWidget)) continue;
                ((TextFieldWidget)guiWidgetListener).tick();
            }
        }
    }

    @Override
    public void init() {
        this.clearEntries();
        this.y0 = ((VoiceSettingsScreen)this.parent).getNavigation().getHeight() + 4;
        this.y1 = ((VoiceSettingsScreen)this.parent).getHeight() - 4;
    }

    public void removed() {
        this.setScrollTop(0.0);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarPosition() && mouseX < (double)(this.getScrollbarPosition() + 6);
        Optional<AbstractScrollbar.Entry> entry = this.getEntryAtPosition(mouseX, mouseY);
        for (AbstractScrollbar.Entry e : this.entries) {
            if (entry.isPresent() && entry.get() == e || e.widgets().size() < 1) continue;
            if ((e.widgets().get(0) instanceof DropDownWidget || e.widgets().get(0) instanceof HotKeyWidget) && e.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            if (!(e.widgets().get(0) instanceof TextFieldWidget) || !e.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocused(e);
            this.setDragging(true);
            return true;
        }
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (entry.isPresent() && entry.get().mouseClicked(mouseX, mouseY, button)) {
            this.setFocused(entry.get());
            this.setDragging(true);
            return true;
        }
        return this.scrolling;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        Optional<AbstractScrollbar.Entry> entry = this.getEntryAtPosition(mouseX, mouseY);
        for (AbstractScrollbar.Entry e : this.entries) {
            if (entry.isPresent() && entry.get() == e || !(e instanceof OptionEntry) || !(e.widgets().get(0) instanceof HotKeyWidget)) continue;
            e.mouseReleased(mouseX, mouseY, button);
        }
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    @Override
    public void render(@NotNull UMatrixStack stack, int mouseX, int mouseY, float delta) {
        super.render(stack, mouseX, mouseY, delta);
    }

    public void setTooltip(@Nullable MinecraftTextComponent tooltip) {
        ((VoiceSettingsScreen)this.parent).setTooltip(tooltip);
    }

    protected void updateOptionEntries(Predicate<UpdatableWidget> predicate) {
        for (AbstractScrollbar.Entry entry : this.entries) {
            if (!(entry instanceof OptionEntry)) continue;
            for (GuiWidgetListener guiWidgetListener : entry.widgets()) {
                UpdatableWidget updatableWidget;
                if (!(guiWidgetListener instanceof UpdatableWidget) || !predicate.test(updatableWidget = (UpdatableWidget)guiWidgetListener)) continue;
                updatableWidget.updateValue();
            }
        }
    }

    protected OptionEntry<ToggleButton> createToggleEntry(@NotNull MinecraftTextComponent text, @Nullable MinecraftTextComponent tooltip, @NotNull ConfigEntry<Boolean> entry) {
        ToggleButton toggleButton = new ToggleButton(entry, 0, 0, 124, 20);
        toggleButton.setActive(!entry.isDisabled());
        return new OptionEntry(this, text, (GuiAbstractWidget)toggleButton, entry, tooltip);
    }

    protected OptionEntry<VolumeSliderWidget> createVolumeSlider(@NotNull MinecraftTextComponent text, @Nullable MinecraftTextComponent tooltip, @NotNull DoubleConfigEntry entry, @NotNull String suffix) {
        VolumeSliderWidget volumeSlider = new VolumeSliderWidget(this.voiceClient.getKeyBindings(), entry, suffix, 0, 0, 124, 20);
        return new OptionEntry(this, text, (GuiAbstractWidget)volumeSlider, (ConfigEntry)entry, tooltip);
    }

    protected OptionEntry<IntSliderWidget> createIntSliderWidget(@NotNull MinecraftTextComponent text, @Nullable MinecraftTextComponent tooltip, @NotNull IntConfigEntry entry, @NotNull String suffix) {
        IntSliderWidget volumeSlider = new IntSliderWidget(entry, suffix, 0, 0, 124, 20);
        return new OptionEntry(this, text, (GuiAbstractWidget)volumeSlider, (ConfigEntry)entry, tooltip);
    }

    public class OptionEntry<W extends GuiAbstractWidget>
    extends AbstractScrollbar.Entry {
        protected final MinecraftTextComponent text;
        protected final MinecraftTextComponent tooltip;
        protected final W element;
        protected final IconButton resetButton;
        @Nullable
        protected final OptionResetAction<W> resetAction;
        protected final ConfigEntry<?> entry;
        private final List<? extends GuiWidgetListener> widgets;
        final /* synthetic */ TabWidget this$0;

        public OptionEntry(@NotNull MinecraftTextComponent text, @NotNull W widget, @NotNull ConfigEntry<?> entry, OptionResetAction<W> action) {
            this(this$0, text, (GuiAbstractWidget)widget, entry, null, action, 24);
        }

        public OptionEntry(@NotNull MinecraftTextComponent text, @NotNull W widget, @Nullable ConfigEntry<?> entry, MinecraftTextComponent tooltip) {
            this(this$0, text, (GuiAbstractWidget)widget, entry, tooltip, null, 24);
        }

        public OptionEntry(@NotNull MinecraftTextComponent text, @NotNull W widget, ConfigEntry<?> entry) {
            this(this$0, text, (GuiAbstractWidget)widget, entry, null, null, 24);
        }

        public OptionEntry(@NotNull MinecraftTextComponent text, @NotNull W widget, @Nullable ConfigEntry<?> entry, @Nullable MinecraftTextComponent tooltip, OptionResetAction<W> resetAction) {
            this(this$0, text, (GuiAbstractWidget)widget, entry, tooltip, resetAction, 24);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public OptionEntry(@NotNull MinecraftTextComponent text, @NotNull W widget, @Nullable ConfigEntry<?> entry, @Nullable MinecraftTextComponent tooltip, OptionResetAction<W> resetAction, int height) {
            this.this$0 = (TabWidget)this$0;
            super(height);
            this.text = text;
            this.element = widget;
            this.entry = entry;
            this.tooltip = tooltip;
            this.resetAction = resetAction;
            this.resetButton = new IconButton(0, 0, 20, 20, this::onReset, Button.NO_TOOLTIP, new ResourceLocation("plasmovoice:textures/icons/reset.png"), true);
            this.widgets = Lists.newArrayList((Object[])new GuiAbstractWidget[]{this.element, this.resetButton});
        }

        @Override
        public void render(@NotNull UMatrixStack stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            this.renderText(stack, index, x, y, entryWidth, mouseX, mouseY, hovered, delta);
            int elementY = y + this.height / 2 - ((GuiAbstractWidget)this.element).getHeight() / 2;
            this.renderElement(stack, index, x, y, entryWidth, mouseX, mouseY, hovered, delta, elementY);
            this.renderResetButton(stack, index, x, y, entryWidth, mouseX, mouseY, hovered, delta, elementY);
            if (hovered && mouseX < ((GuiAbstractWidget)this.element).getX()) {
                this.this$0.setTooltip(this.tooltip);
            }
        }

        @Override
        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            for (GuiWidgetListener entry : this.widgets()) {
                if (!(entry instanceof HotKeyWidget) || !entry.mouseReleased(mouseX, mouseY, button)) continue;
                return true;
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }

        @Override
        public List<? extends GuiWidgetListener> widgets() {
            return this.widgets;
        }

        protected void renderText(@NotNull UMatrixStack stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            RenderUtil.drawString(stack, this.text, x, y + this.height / 2 - UGraphics.getFontHeight() / 2, 0xFFFFFF);
        }

        protected void renderElement(@NotNull UMatrixStack stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta, int elementY) {
            ((GuiAbstractWidget)this.element).setX(x + entryWidth - ((GuiAbstractWidget)this.element).getWidth() - 24);
            ((GuiAbstractWidget)this.element).setY(elementY);
            ((GuiAbstractWidget)this.element).render(stack, mouseX, mouseY, delta);
        }

        protected void renderResetButton(@NotNull UMatrixStack stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta, int elementY) {
            this.resetButton.setX(x + entryWidth - 20);
            this.resetButton.setY(elementY);
            this.resetButton.setActive(this.entry != null && !this.isDefault());
            this.resetButton.render(stack, mouseX, mouseY, delta);
        }

        protected boolean isDefault() {
            return this.entry.isDefault();
        }

        protected void onReset(@NotNull Button button) {
            if (this.entry == null) {
                return;
            }
            this.entry.reset();
            if (this.element instanceof UpdatableWidget) {
                ((UpdatableWidget)this.element).updateValue();
            }
            if (this.resetAction != null) {
                this.resetAction.onReset((IconButton)button, this.element);
            }
        }
    }

    static interface OptionResetAction<T extends GuiAbstractWidget> {
        public void onReset(@NotNull IconButton var1, T var2);
    }

    public class ButtonOptionEntry<W extends GuiAbstractWidget>
    extends OptionEntry<W> {
        protected final List<GuiAbstractWidget> widgets;
        protected final List<Button> buttons;
        final /* synthetic */ TabWidget this$0;

        public ButtonOptionEntry(@NotNull MinecraftTextComponent text, @NotNull W widget, @NotNull List<Button> buttons, @Nullable ConfigEntry<?> entry, @Nullable MinecraftTextComponent tooltip, OptionResetAction<W> resetAction) {
            this(this$0, text, (GuiAbstractWidget)widget, buttons, entry, tooltip, resetAction, 24);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public ButtonOptionEntry(@NotNull MinecraftTextComponent text, @NotNull W widget, @NotNull List<Button> buttons, @Nullable ConfigEntry<?> entry, @Nullable MinecraftTextComponent tooltip, OptionResetAction<W> resetAction, int height) {
            this.this$0 = (TabWidget)this$0;
            super((TabWidget)this$0, text, widget, entry, tooltip, resetAction, height);
            this.buttons = buttons;
            this.widgets = Lists.newArrayList((Object[])new GuiAbstractWidget[]{this.element, this.resetButton});
            this.widgets.addAll(buttons);
        }

        @Override
        protected void renderElement(@NotNull UMatrixStack stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta, int elementY) {
            if (this.buttons.size() == 0) {
                super.renderElement(stack, index, x, y, entryWidth, mouseX, mouseY, hovered, delta, elementY);
                return;
            }
            List visibleButtons = this.buttons.stream().filter(GuiAbstractWidget::isVisible).collect(Collectors.toList());
            int visibleButtonsWidth = visibleButtons.stream().map(GuiAbstractWidget::getWidth).reduce(0, Integer::sum);
            this.element.setX(x + entryWidth - this.element.getWidth() - visibleButtons.size() * 4 - this.resetButton.getWidth() - 4 - visibleButtonsWidth);
            this.element.setY(elementY);
            this.element.render(stack, mouseX, mouseY, delta);
            for (int i = 0; i < visibleButtons.size(); ++i) {
                Button button = (Button)visibleButtons.get(i);
                button.setX(x + entryWidth - button.getWidth() - (i + 1) * 24 - i * 8);
                button.setY(elementY);
                button.render(stack, mouseX, mouseY, delta);
            }
        }

        @Override
        public List<? extends GuiWidgetListener> widgets() {
            return this.widgets;
        }
    }

    public final class FullWidthEntry<W extends GuiAbstractWidget>
    extends AbstractScrollbar.Entry {
        private final W element;
        private final List<? extends GuiWidgetListener> widgets;
        final /* synthetic */ TabWidget this$0;

        public FullWidthEntry(W element) {
            this(this$0, (GuiAbstractWidget)element, 24);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public FullWidthEntry(W element, int height) {
            this.this$0 = (TabWidget)this$0;
            super(height);
            this.element = element;
            this.widgets = ImmutableList.of(element);
        }

        @Override
        public void render(@NotNull UMatrixStack stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            ((GuiAbstractWidget)this.element).setX(x);
            ((GuiAbstractWidget)this.element).setY(y);
            ((GuiAbstractWidget)this.element).setWidth(entryWidth);
            ((GuiAbstractWidget)this.element).render(stack, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiWidgetListener> widgets() {
            return this.widgets;
        }
    }

    public final class CategoryEntry
    extends AbstractScrollbar.Entry {
        private static final int COLOR = 0xFFFFFF;
        private final MinecraftTextComponent text;
        private final int textWidth;

        public CategoryEntry(MinecraftTextComponent text) {
            super(24);
            this.text = text;
            this.textWidth = RenderUtil.getTextWidth(text);
        }

        public CategoryEntry(MinecraftTextComponent text, int height) {
            super(height);
            this.text = text;
            this.textWidth = RenderUtil.getTextWidth(text);
        }

        @Override
        public void render(@NotNull UMatrixStack stack, int index, int x, int y, int entryWidth, int mouseX, int mouseY, boolean hovered, float delta) {
            int elementX = x + TabWidget.this.containerWidth / 2 - RenderUtil.getTextWidth(this.text) / 2;
            int elementY = y + this.height / 2 - UGraphics.getFontHeight() / 2;
            RenderUtil.drawString(stack, this.text, elementX, elementY, 0xFFFFFF);
        }
    }
}

