/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.gui.settings.widget;

import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.chat.MinecraftTextComponent;
import su.plo.lib.mod.client.gui.components.Button;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.shader.SolidColorShader;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;

public final class TabButton
extends Button {
    private final boolean shadow;
    private final int shadowColor;
    private final ResourceLocation iconLocation;
    private final ResourceLocation disabledIconLocation;

    public TabButton(int x, int y, int width, int height, @NotNull MinecraftTextComponent text, @NotNull ResourceLocation iconLocation, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, boolean shadow) {
        this(x, y, width, height, text, iconLocation, pressAction, tooltipAction, shadow, -1);
    }

    public TabButton(int x, int y, int width, int height, @NotNull MinecraftTextComponent text, @NotNull ResourceLocation iconLocation, @NotNull Button.OnPress pressAction, @NotNull Button.OnTooltip tooltipAction, boolean shadow, int shadowColor) {
        super(x, y, width, height, text, pressAction, tooltipAction);
        this.shadow = shadow;
        this.shadowColor = shadowColor;
        this.iconLocation = iconLocation;
        this.disabledIconLocation = new ResourceLocation(iconLocation.m_135827_(), iconLocation.m_135815_().replace(".png", "_disabled.png"));
    }

    @Override
    protected void renderText(@NotNull UMatrixStack stack, int mouseX, int mouseY) {
        UGraphics.bindTexture(0, this.getIconLocation());
        if (this.shadow) {
            int shadowColor = this.active ? this.shadowColor : -6250336;
            SolidColorShader.bind();
            RenderUtil.blitWithActiveShader(stack, UGraphics.CommonVertexFormats.POSITION_TEXTURE_COLOR, this.x + 7, this.x + 7 + 8, this.y + 7, this.y + 7 + 8, 0, 0.0f, 1.0f, 0.0f, 1.0f, (int)((double)(shadowColor >> 16 & 0xFF) * 0.25), (int)((double)(shadowColor >> 8 & 0xFF) * 0.25), (int)((double)(shadowColor & 0xFF) * 0.25), shadowColor >> 24 & 0xFF);
            SolidColorShader.unbind();
        }
        RenderUtil.blit(stack, this.x + 6, this.y + 6, 0.0f, 0.0f, 8, 8, 8, 8);
        int textColor = this.active ? COLOR_WHITE : COLOR_GRAY;
        RenderUtil.drawString(stack, this.getText(), this.x + 16, this.y + (this.height - 8) / 2, textColor | (int)Math.ceil(this.alpha * 255.0f) << 24);
    }

    private ResourceLocation getIconLocation() {
        return this.active ? this.iconLocation : this.disabledIconLocation;
    }
}

