/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.client.event.render.EntityRenderEvent;
import su.plo.voice.client.event.render.PlayerRenderEvent;
import su.plo.voice.client.render.ModCamera;
import su.plo.voice.client.render.ModRenderer;
import su.plo.voice.universal.UMatrixStack;

public final class ModEntityRenderer
extends ModRenderer {
    public ModEntityRenderer(@NotNull PlasmoVoiceClient voiceClient) {
        super(voiceClient);
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, @NotNull Camera camera, int light, @NotNull Entity entity, boolean hasLabel) {
        if (entity instanceof AbstractClientPlayer) {
            this.render(poseStack, multiBufferSource, camera, light, (AbstractClientPlayer)entity, hasLabel);
            return;
        }
        this.voiceClient.getEventBus().call(new EntityRenderEvent(new UMatrixStack(poseStack), new ModCamera(camera.m_90583_(), camera.m_90589_(), camera.m_90590_()), entity, light, hasLabel));
    }

    private void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, @NotNull Camera camera, int light, @NotNull AbstractClientPlayer player, boolean hasLabel) {
        boolean isFakePlayer = false;
        if (Minecraft.m_91087_().f_91074_ != null) {
            isFakePlayer = !Minecraft.m_91087_().m_91403_().m_105143_().contains(player.m_20148_());
        }
        this.voiceClient.getEventBus().call(new PlayerRenderEvent(new UMatrixStack(poseStack), new ModCamera(camera.m_90583_(), camera.m_90589_(), camera.m_90590_()), (Player)player, light, hasLabel, isFakePlayer));
    }
}

