/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.cape;

import com.google.common.hash.Hashing;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.render.texture.ModPlayerSkins;
import su.plo.voice.client.meta.PlasmoVoiceMeta;
import su.plo.voice.client.meta.developer.Developer;
import su.plo.voice.client.render.cape.SkinManagerAccessor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lsu/plo/voice/client/render/cape/DeveloperCapeManager;", "", "()V", "loadedCapes", "", "", "Lnet/minecraft/resources/ResourceLocation;", "clearLoadedCapes", "", "getCapeLocation", "playerName", "registerTextures", "client"})
public final class DeveloperCapeManager {
    @NotNull
    public static final DeveloperCapeManager INSTANCE = new DeveloperCapeManager();
    @NotNull
    private static final Map<String, ResourceLocation> loadedCapes = new ConcurrentHashMap();

    private DeveloperCapeManager() {
    }

    public final void clearLoadedCapes() {
        loadedCapes.clear();
    }

    public final void registerTextures(@NotNull String playerName) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
            Iterable $this$none$iv = PlasmoVoiceMeta.Companion.getMETA().getDevelopers();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Developer developer = (Developer)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)developer.getName(), (Object)playerName) || developer.getAliases().contains(playerName))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        String string = playerName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        ResourceLocation capeLocation = new ResourceLocation("plasmovoice", "developer_capes/" + (String)string);
        Util.m_183991_().execute(() -> DeveloperCapeManager.registerTextures$lambda-3(playerName, capeLocation));
    }

    @Nullable
    public final ResourceLocation getCapeLocation(@NotNull String playerName) {
        Intrinsics.checkNotNullParameter((Object)playerName, (String)"playerName");
        return loadedCapes.get(playerName);
    }

    private static final void registerTextures$lambda-3$lambda-2$lambda-1() {
    }

    private static final void registerTextures$lambda-3$lambda-2(ResourceLocation $capeLocation, File $capeFile, MinecraftProfileTexture $texture, String $playerName) {
        Intrinsics.checkNotNullParameter((Object)$capeLocation, (String)"$capeLocation");
        Intrinsics.checkNotNullParameter((Object)$capeFile, (String)"$capeFile");
        Intrinsics.checkNotNullParameter((Object)$texture, (String)"$texture");
        Intrinsics.checkNotNullParameter((Object)$playerName, (String)"$playerName");
        Minecraft.m_91087_().f_90987_.m_118495_($capeLocation, (AbstractTexture)new HttpTexture($capeFile, $texture.getUrl(), ModPlayerSkins.getDefaultSkin(UUID.randomUUID()), false, DeveloperCapeManager::registerTextures$lambda-3$lambda-2$lambda-1));
        loadedCapes.put($playerName, $capeLocation);
    }

    private static final void registerTextures$lambda-3(String $playerName, ResourceLocation $capeLocation) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$playerName, (String)"$playerName");
        Intrinsics.checkNotNullParameter((Object)$capeLocation, (String)"$capeLocation");
        URL url = new URL("https://plasmovoice.com/capes/" + $playerName + ".png");
        MinecraftProfileTexture texture = new MinecraftProfileTexture(url.toString(), (Map)new HashMap());
        String string2 = Hashing.sha1().hashUnencodedChars((CharSequence)texture.getHash()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sha1().hashUnencodedChars(texture.hash).toString()");
        String string3 = string2;
        SkinManager skinManager = Minecraft.m_91087_().m_91109_();
        if (skinManager == null) {
            throw new NullPointerException("null cannot be cast to non-null type su.plo.voice.client.render.cape.SkinManagerAccessor");
        }
        File skinsFolder = ((SkinManagerAccessor)skinManager).getSkinsCacheFolder();
        if (string3.length() > 2) {
            String string4 = string3.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            string = string4;
        } else {
            string = "xx";
        }
        File hashFolder = new File(skinsFolder, string);
        File capeFile = new File(hashFolder, string3);
        if (capeFile.exists() && System.currentTimeMillis() - capeFile.lastModified() > 86400000L) {
            capeFile.delete();
        }
        RenderSystem.m_69879_(() -> DeveloperCapeManager.registerTextures$lambda-3$lambda-2($capeLocation, capeFile, texture, $playerName));
    }
}

