/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.client.render.voice;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.voice.api.client.PlasmoVoiceClient;
import su.plo.voice.api.client.audio.capture.ClientActivation;
import su.plo.voice.api.client.config.IconPosition;
import su.plo.voice.api.client.event.render.HudActivationRenderEvent;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.client.config.VoiceClientConfig;
import su.plo.voice.client.event.render.HudRenderEvent;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.universal.UGraphics;
import su.plo.voice.universal.UMatrixStack;
import su.plo.voice.universal.UMinecraft;
import su.plo.voice.universal.UResolution;

public final class HudIconRenderer {
    private final PlasmoVoiceClient voiceClient;
    private final VoiceClientConfig config;

    @EventSubscribe
    public void onHudRender(@NotNull HudRenderEvent event) {
        if (!(this.voiceClient.getServerInfo().isPresent() && this.voiceClient.getUdpClientManager().getClient().isPresent() && UMinecraft.getPlayer() != null && ((Boolean)this.config.getOverlay().getShowActivationIcon().value()).booleanValue())) {
            return;
        }
        if (this.voiceClient.getUdpClientManager().getClient().get().isTimedOut()) {
            this.renderIcon(event.getStack(), new ResourceLocation("plasmovoice:textures/icons/microphone_disconnected.png"));
            return;
        }
        if (((Boolean)this.config.getVoice().getDisabled().value()).booleanValue()) {
            this.renderIcon(event.getStack(), new ResourceLocation("plasmovoice:textures/icons/speaker_disabled.png"));
            return;
        }
        if (this.voiceClient.getAudioCapture().isServerMuted()) {
            this.renderIcon(event.getStack(), new ResourceLocation("plasmovoice:textures/icons/microphone_muted.png"));
            return;
        }
        if (((Boolean)this.config.getVoice().getMicrophoneDisabled().value()).booleanValue()) {
            this.renderIcon(event.getStack(), new ResourceLocation("plasmovoice:textures/icons/microphone_disabled.png"));
            return;
        }
        List activations = (List)this.voiceClient.getActivationManager().getActivations();
        Activation currentActivation = null;
        for (int index = activations.size() - 1; index >= 0; --index) {
            ClientActivation activation = (ClientActivation)activations.get(index);
            HudActivationRenderEvent renderEvent = new HudActivationRenderEvent(activation, activation.isActive());
            this.voiceClient.getEventBus().call(renderEvent);
            if (!renderEvent.isRender()) continue;
            currentActivation = activation;
            if (!activation.isTransitive()) break;
        }
        if (currentActivation != null) {
            this.renderIcon(event.getStack(), new ResourceLocation(currentActivation.getIcon()));
        }
    }

    private void renderIcon(@NotNull UMatrixStack stack, @NotNull ResourceLocation iconLocation) {
        IconPosition iconPosition = (IconPosition)((Object)this.config.getOverlay().getActivationIconPosition().value());
        UGraphics.bindTexture(0, iconLocation);
        UGraphics.color4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtil.blit(stack, this.calcIconX(iconPosition.getX()), this.calcIconY(iconPosition.getY()), 0.0f, 0.0f, 16, 16, 16, 16);
    }

    private int calcIconX(Integer x) {
        if (x == null) {
            return UResolution.getScaledWidth() / 2 - 8;
        }
        if (x < 0) {
            return UResolution.getScaledWidth() + x - 16;
        }
        return x;
    }

    private int calcIconY(Integer y) {
        if (y == null) {
            return UResolution.getScaledHeight() - 32;
        }
        if (y < 0) {
            return UResolution.getScaledHeight() + y - 16;
        }
        return y;
    }

    public HudIconRenderer(PlasmoVoiceClient voiceClient, VoiceClientConfig config) {
        this.voiceClient = voiceClient;
        this.config = config;
    }
}

