/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.player;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.Collections;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.proto.packets.PacketSerializable;
import su.plo.voice.proto.packets.PacketUtil;

public class VoicePlayerInfo
implements PacketSerializable {
    private UUID playerId;
    private String playerNick;
    private boolean muted;
    private boolean voiceDisabled;
    private boolean microphoneMuted;

    @Override
    public void deserialize(ByteArrayDataInput in) {
        this.playerId = PacketUtil.readUUID(in);
        this.playerNick = in.readUTF();
        this.muted = in.readBoolean();
        this.voiceDisabled = in.readBoolean();
        this.microphoneMuted = in.readBoolean();
    }

    @Override
    public void serialize(ByteArrayDataOutput out) {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.playerId));
        out.writeUTF((String)Preconditions.checkNotNull((Object)this.playerNick));
        out.writeBoolean(this.muted);
        out.writeBoolean(this.voiceDisabled);
        out.writeBoolean(this.microphoneMuted);
    }

    @NotNull
    public MinecraftGameProfile toGameProfile() {
        return new MinecraftGameProfile(this.playerId, this.playerNick, Collections.emptyList());
    }

    public VoicePlayerInfo(UUID playerId, String playerNick, boolean muted, boolean voiceDisabled, boolean microphoneMuted) {
        this.playerId = playerId;
        this.playerNick = playerNick;
        this.muted = muted;
        this.voiceDisabled = voiceDisabled;
        this.microphoneMuted = microphoneMuted;
    }

    public VoicePlayerInfo() {
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getPlayerNick() {
        return this.playerNick;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public boolean isVoiceDisabled() {
        return this.voiceDisabled;
    }

    public boolean isMicrophoneMuted() {
        return this.microphoneMuted;
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
    }

    public void setPlayerNick(String playerNick) {
        this.playerNick = playerNick;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public void setVoiceDisabled(boolean voiceDisabled) {
        this.voiceDisabled = voiceDisabled;
    }

    public void setMicrophoneMuted(boolean microphoneMuted) {
        this.microphoneMuted = microphoneMuted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoicePlayerInfo)) {
            return false;
        }
        VoicePlayerInfo other = (VoicePlayerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMuted() != other.isMuted()) {
            return false;
        }
        if (this.isVoiceDisabled() != other.isVoiceDisabled()) {
            return false;
        }
        if (this.isMicrophoneMuted() != other.isMicrophoneMuted()) {
            return false;
        }
        UUID this$playerId = this.getPlayerId();
        UUID other$playerId = other.getPlayerId();
        if (this$playerId == null ? other$playerId != null : !((Object)this$playerId).equals(other$playerId)) {
            return false;
        }
        String this$playerNick = this.getPlayerNick();
        String other$playerNick = other.getPlayerNick();
        return !(this$playerNick == null ? other$playerNick != null : !this$playerNick.equals(other$playerNick));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VoicePlayerInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMuted() ? 79 : 97);
        result = result * 59 + (this.isVoiceDisabled() ? 79 : 97);
        result = result * 59 + (this.isMicrophoneMuted() ? 79 : 97);
        UUID $playerId = this.getPlayerId();
        result = result * 59 + ($playerId == null ? 43 : ((Object)$playerId).hashCode());
        String $playerNick = this.getPlayerNick();
        result = result * 59 + ($playerNick == null ? 43 : $playerNick.hashCode());
        return result;
    }

    public String toString() {
        return "VoicePlayerInfo(playerId=" + this.getPlayerId() + ", playerNick=" + this.getPlayerNick() + ", muted=" + this.isMuted() + ", voiceDisabled=" + this.isVoiceDisabled() + ", microphoneMuted=" + this.isMicrophoneMuted() + ")";
    }
}

