/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.data.pos;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.proto.packets.PacketSerializable;

public class Pos3d
implements PacketSerializable {
    private double x;
    private double y;
    private double z;

    public Pos3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void deserialize(ByteArrayDataInput in) {
        this.x = in.readDouble();
        this.y = in.readDouble();
        this.z = in.readDouble();
    }

    @Override
    public void serialize(ByteArrayDataOutput out) {
        out.writeDouble(this.x);
        out.writeDouble(this.y);
        out.writeDouble(this.z);
    }

    public double distanceSquared(@NotNull Pos3d o) {
        double xDiff = this.x - o.x;
        double yDiff = this.y - o.y;
        double zDiff = this.z - o.z;
        return xDiff * xDiff + yDiff * yDiff + zDiff * zDiff;
    }

    public Pos3d() {
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pos3d)) {
            return false;
        }
        Pos3d other = (Pos3d)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        return Double.compare(this.getZ(), other.getZ()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pos3d;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        return result;
    }

    public String toString() {
        return "Pos3d(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }
}

