/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.UUID;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class SourceLinePlayerAddPacket
implements Packet<ClientPacketTcpHandler> {
    private UUID lineId;
    private MinecraftGameProfile player;

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.lineId = PacketUtil.readUUID(in);
        this.player = new MinecraftGameProfile();
        this.player.deserialize(in);
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.lineId));
        ((MinecraftGameProfile)Preconditions.checkNotNull((Object)this.player)).serialize(out);
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public SourceLinePlayerAddPacket(UUID lineId, MinecraftGameProfile player) {
        this.lineId = lineId;
        this.player = player;
    }

    public SourceLinePlayerAddPacket() {
    }

    public String toString() {
        return "SourceLinePlayerAddPacket(lineId=" + this.getLineId() + ", player=" + this.getPlayer() + ")";
    }

    public UUID getLineId() {
        return this.lineId;
    }

    public MinecraftGameProfile getPlayer() {
        return this.player;
    }
}

