/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.proto.packets.tcp.clientbound;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketUtil;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;

public final class SourceLinePlayersListPacket
implements Packet<ClientPacketTcpHandler> {
    private UUID lineId;
    private List<MinecraftGameProfile> players;

    public SourceLinePlayersListPacket(@NotNull UUID lineId) {
        this.lineId = lineId;
        this.players = ImmutableList.of();
    }

    @Override
    public void read(ByteArrayDataInput in) throws IOException {
        this.lineId = PacketUtil.readUUID(in);
        this.players = Lists.newArrayList();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            MinecraftGameProfile player = new MinecraftGameProfile();
            player.deserialize(in);
            this.players.add(player);
        }
    }

    @Override
    public void write(ByteArrayDataOutput out) throws IOException {
        PacketUtil.writeUUID(out, (UUID)Preconditions.checkNotNull((Object)this.lineId));
        out.writeInt(((List)Preconditions.checkNotNull(this.players)).size());
        for (MinecraftGameProfile player : this.players) {
            player.serialize(out);
        }
    }

    @Override
    public void handle(ClientPacketTcpHandler handler) {
        handler.handle(this);
    }

    public SourceLinePlayersListPacket(UUID lineId, List<MinecraftGameProfile> players) {
        this.lineId = lineId;
        this.players = players;
    }

    public SourceLinePlayersListPacket() {
    }

    public String toString() {
        return "SourceLinePlayersListPacket(lineId=" + this.getLineId() + ", players=" + this.getPlayers() + ")";
    }

    public UUID getLineId() {
        return this.lineId;
    }

    public List<MinecraftGameProfile> getPlayers() {
        return this.players;
    }
}

