/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.event.EventNetworkChannel;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.nodes.PermissionDynamicContext;
import net.minecraftforge.server.permission.nodes.PermissionNode;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.api.server.MinecraftServerLib;
import su.plo.lib.api.server.event.player.PlayerJoinEvent;
import su.plo.lib.api.server.event.player.PlayerQuitEvent;
import su.plo.lib.api.server.permission.PermissionDefault;
import su.plo.lib.api.server.permission.PermissionTristate;
import su.plo.lib.mod.server.ModServerLib;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.connection.ModServerChannelHandler;
import su.plo.voice.server.connection.ModServerServiceChannelHandler;
import su.plo.voice.server.player.PermissionSupplier;
import su.plo.voice.ustats.UStats;
import su.plo.voice.ustats.mod.ModUStatsPlatform;
import su.plo.voice.util.version.ModrinthLoader;

public final class ModVoiceServer
extends BaseVoiceServer {
    public static final ResourceLocation CHANNEL = new ResourceLocation("plasmo:voice/v2");
    public static final ResourceLocation FLAG_CHANNEL = new ResourceLocation("plasmo:voice/v2/installed");
    public static final ResourceLocation SERVICE_CHANNEL = new ResourceLocation("plasmo:voice/v2/service");
    private final String modId = "plasmovoice";
    private final ModServerLib minecraftServerLib = new ModServerLib(this::getLanguages);
    private MinecraftServer server;
    private ModServerChannelHandler handler;
    private ModServerServiceChannelHandler serviceHandler;
    private UStats uStats;
    private final EventNetworkChannel channel;
    private final EventNetworkChannel serviceChannel;

    public ModVoiceServer(@NotNull ModrinthLoader loader, @NotNull EventNetworkChannel channel, @NotNull EventNetworkChannel serviceChannel) {
        super(loader);
        this.channel = channel;
        this.serviceChannel = serviceChannel;
    }

    private void onInitialize(MinecraftServer server) {
        this.server = server;
        this.minecraftServerLib.setServer(server);
        this.minecraftServerLib.setPermissions(this.createPermissionSupplier());
        this.minecraftServerLib.onInitialize();
        super.onInitialize();
        this.uStats = new UStats(USTATS_PROJECT_UUID, this.getVersion(), new ModUStatsPlatform(server), this.getConfigFolder());
    }

    private void onShutdown(MinecraftServer server) {
        super.onShutdown();
        this.server = null;
        this.minecraftServerLib.onShutdown();
        this.handler.clear();
        this.uStats.close();
    }

    private void onCommandRegister(@NotNull CommandDispatcher<CommandSourceStack> dispatcher) {
        this.registerDefaultCommandsAndPermissions();
        this.minecraftServerLib.getCommandManager().registerCommands(dispatcher);
    }

    @Override
    @NotNull
    public File getConfigFolder() {
        return new File("config/plasmovoice/server");
    }

    @Override
    @NotNull
    public File getConfigsFolder() {
        return new File("config");
    }

    @Override
    @NotNull
    public MinecraftServerLib getMinecraftServer() {
        return this.minecraftServerLib;
    }

    @Override
    @NotNull
    public String getVersion() {
        return ModList.get().getModFileById("plasmovoice").versionString();
    }

    @Override
    protected PermissionSupplier createPermissionSupplier() {
        return new PermissionSupplier(){

            @Override
            public boolean hasPermission(@NotNull Object player, @NotNull String permission) {
                if (!(player instanceof ServerPlayer)) {
                    throw new IllegalArgumentException("player is not " + ServerPlayer.class);
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PermissionDefault permissionDefault = ModVoiceServer.this.minecraftServerLib.getPermissionsManager().getPermissionDefault(permission);
                boolean isOp = ModVoiceServer.this.server.m_6846_().m_11303_(serverPlayer.m_36316_());
                return this.getPermission(serverPlayer, permission).booleanValue(permissionDefault.getValue(isOp));
            }

            @Override
            @NotNull
            public PermissionTristate getPermission(@NotNull Object player, @NotNull String permission) {
                if (!(player instanceof ServerPlayer)) {
                    throw new IllegalArgumentException("player is not " + ServerPlayer.class);
                }
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Optional<PermissionNode> permissionNode = PermissionAPI.getRegisteredNodes().stream().filter(node -> node.getNodeName().equals(permission)).findAny();
                if (permissionNode.isEmpty()) {
                    return PermissionTristate.UNDEFINED;
                }
                Boolean value = (Boolean)permissionNode.get().getDefaultResolver().resolve(serverPlayer, serverPlayer.m_20148_(), new PermissionDynamicContext[0]);
                if (value == null) {
                    return PermissionTristate.UNDEFINED;
                }
                return value != false ? PermissionTristate.TRUE : PermissionTristate.FALSE;
            }
        };
    }

    @SubscribeEvent
    public void onServerStart(ServerStartedEvent event) {
        if (this.handler == null) {
            this.handler = new ModServerChannelHandler(this);
            this.channel.addListener(this.handler::receive);
        }
        if (this.serviceHandler == null) {
            this.serviceHandler = new ModServerServiceChannelHandler(this);
            this.serviceChannel.addListener(this.serviceHandler::receive);
        }
        this.onInitialize(event.getServer());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        this.onShutdown(event.getServer());
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ((PlayerJoinEvent.Callback)PlayerJoinEvent.INSTANCE.getInvoker()).onPlayerJoin(this.minecraftServerLib.getPlayerByInstance(event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ((PlayerQuitEvent.Callback)PlayerQuitEvent.INSTANCE.getInvoker()).onPlayerQuit(this.minecraftServerLib.getPlayerByInstance(event.getEntity()));
        }
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent event) {
        this.onCommandRegister((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

