/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.capture;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.server.permission.PermissionDefault;
import su.plo.voice.api.event.EventBus;
import su.plo.voice.api.event.EventSubscribe;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.ProximityServerActivationHelper;
import su.plo.voice.api.server.audio.capture.ServerActivation;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.event.player.PlayerActivationDistanceUpdateEvent;
import su.plo.voice.proto.data.audio.capture.Activation;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.line.SourceLine;
import su.plo.voice.server.config.VoiceServerConfig;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lsu/plo/voice/server/audio/capture/ProximityServerActivation;", "", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;)V", "proximityHelper", "Lsu/plo/voice/api/server/audio/capture/ProximityServerActivationHelper;", "onActivationDistanceChange", "", "event", "Lsu/plo/voice/api/server/event/player/PlayerActivationDistanceUpdateEvent;", "register", "config", "Lsu/plo/voice/server/config/VoiceServerConfig;", "common"})
public final class ProximityServerActivation {
    @NotNull
    private final PlasmoVoiceServer voiceServer;
    @Nullable
    private ProximityServerActivationHelper proximityHelper;

    public ProximityServerActivation(@NotNull PlasmoVoiceServer voiceServer) {
        Intrinsics.checkNotNullParameter((Object)voiceServer, (String)"voiceServer");
        this.voiceServer = voiceServer;
    }

    public final void register(@NotNull VoiceServerConfig config) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ProximityServerActivationHelper proximityServerActivationHelper = this.proximityHelper;
        if (proximityServerActivationHelper != null) {
            it = proximityServerActivationHelper;
            boolean bl = false;
            this.voiceServer.getEventBus().unregister((Object)this.voiceServer, it);
            this.voiceServer.getActivationManager().unregister((Activation)((ProximityServerActivationHelper)it).getActivation());
            this.voiceServer.getSourceLineManager().unregister((SourceLine)((ProximityServerActivationHelper)it).getSourceLine());
        }
        ServerActivation.Builder builder = this.voiceServer.getActivationManager().createBuilder((Object)this.voiceServer, "proximity", "pv.activation.proximity", "plasmovoice:textures/icons/microphone.png", "pv.activation.proximity", 1);
        it = builder.setDistances((List<Integer>)config.voice().proximity().distances()).setDefaultDistance(config.voice().proximity().defaultDistance()).setProximity(true).setTransitive(true).setStereoSupported(false).setPermissionDefault(PermissionDefault.TRUE).build();
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"builder\n            .set\u2026RUE)\n            .build()");
        Object activation = it;
        ServerSourceLine sourceLine = (ServerSourceLine)this.voiceServer.getSourceLineManager().createBuilder((Object)this.voiceServer, "proximity", "pv.activation.proximity", "plasmovoice:textures/icons/speaker.png", 1).build();
        this.proximityHelper = new ProximityServerActivationHelper(this.voiceServer, (ServerActivation)activation, sourceLine, null, 8, null);
        EventBus eventBus = this.voiceServer.getEventBus();
        ProximityServerActivationHelper proximityServerActivationHelper2 = this.proximityHelper;
        Intrinsics.checkNotNull((Object)proximityServerActivationHelper2);
        eventBus.register(this.voiceServer, proximityServerActivationHelper2);
    }

    @EventSubscribe
    public final void onActivationDistanceChange(@NotNull PlayerActivationDistanceUpdateEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getActivation().getId(), (Object)VoiceActivation.PROXIMITY_ID)) {
            return;
        }
        if (event.getOldDistance() == -1) {
            return;
        }
        event.getPlayer().visualizeDistance(event.getDistance());
    }
}

