/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.line;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoBaseVoiceServer;
import su.plo.voice.api.server.audio.line.BaseServerSourceLine;
import su.plo.voice.api.server.audio.line.ServerSourceLinePlayersSets;
import su.plo.voice.api.server.audio.source.ServerAudioSource;
import su.plo.voice.api.server.audio.source.ServerDirectSource;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.line.VoiceSourceLine;
import su.plo.voice.proto.data.player.MinecraftGameProfile;
import su.plo.voice.server.audio.line.VoiceServerSourceLinePlayersSets;
import su.plo.voice.server.audio.source.VoiceServerDirectSource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002BE\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010 \u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\u001a\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0'2\u0006\u0010(\u001a\u00020\u001aH\u0016J\u0010\u0010)\u001a\u00020\u00022\u0006\u0010*\u001a\u00020+H\u0016J\u0012\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0-H\u0016J\u0010\u0010.\u001a\u00020!2\u0006\u0010(\u001a\u00020\u001aH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006/"}, d2={"Lsu/plo/voice/server/audio/line/VoiceBaseServerSourceLine;", "Lsu/plo/voice/api/server/audio/line/BaseServerSourceLine;", "Lsu/plo/voice/proto/data/audio/line/VoiceSourceLine;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "name", "", "translation", "icon", "defaultVolume", "", "weight", "", "withPlayers", "", "(Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;DIZ)V", "getAddon", "()Lsu/plo/voice/api/addon/AddonContainer;", "playersSets", "Lsu/plo/voice/api/server/audio/line/ServerSourceLinePlayersSets;", "getPlayersSets", "()Lsu/plo/voice/api/server/audio/line/ServerSourceLinePlayersSets;", "sourceById", "", "Ljava/util/UUID;", "Lsu/plo/voice/api/server/audio/source/ServerAudioSource;", "getSourceById", "()Ljava/util/Map;", "getVoiceServer", "()Lsu/plo/voice/api/server/PlasmoBaseVoiceServer;", "clear", "", "createDirectSource", "Lsu/plo/voice/api/server/audio/source/ServerDirectSource;", "stereo", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "Ljava/util/Optional;", "sourceId", "getSourceLineForPlayer", "player", "Lsu/plo/voice/api/server/player/VoicePlayer;", "getSources", "", "removeSource", "server-common"})
public abstract class VoiceBaseServerSourceLine
extends VoiceSourceLine
implements BaseServerSourceLine {
    @NotNull
    private final PlasmoBaseVoiceServer voiceServer;
    @NotNull
    private final AddonContainer addon;
    @Nullable
    private final ServerSourceLinePlayersSets playersSets;
    @NotNull
    private final Map<UUID, ServerAudioSource<?>> sourceById;

    public VoiceBaseServerSourceLine(@NotNull PlasmoBaseVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull String name, @NotNull String translation, @NotNull String icon, double defaultVolume, int weight, boolean withPlayers) {
        Intrinsics.checkNotNullParameter((Object)voiceServer, (String)"voiceServer");
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)translation, (String)"translation");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        super(name, translation, icon, defaultVolume, weight, null);
        this.voiceServer = voiceServer;
        this.addon = addon;
        this.playersSets = withPlayers ? (ServerSourceLinePlayersSets)new VoiceServerSourceLinePlayersSets(this) : null;
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"newConcurrentMap()");
        this.sourceById = concurrentMap;
    }

    @NotNull
    protected PlasmoBaseVoiceServer getVoiceServer() {
        return this.voiceServer;
    }

    @Override
    @NotNull
    public AddonContainer getAddon() {
        return this.addon;
    }

    @Override
    @Nullable
    public ServerSourceLinePlayersSets getPlayersSets() {
        return this.playersSets;
    }

    @NotNull
    protected final Map<UUID, ServerAudioSource<?>> getSourceById() {
        return this.sourceById;
    }

    @Override
    @NotNull
    public VoiceSourceLine getSourceLineForPlayer(@NotNull VoicePlayer player) {
        VoiceSourceLine voiceSourceLine;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ServerSourceLinePlayersSets serverSourceLinePlayersSets = this.getPlayersSets();
        if (serverSourceLinePlayersSets == null) {
            voiceSourceLine = this;
        } else {
            VoiceSourceLine voiceSourceLine2;
            VoiceSourceLine voiceSourceLine3;
            ServerSourceLinePlayersSets it = serverSourceLinePlayersSets;
            boolean bl = false;
            VoiceSourceLine it2 = voiceSourceLine3 = new VoiceSourceLine(this.name, this.translation, this.icon, this.defaultVolume, this.weight, it.getPlayersSet(player).getPlayers().stream().map(VoiceBaseServerSourceLine::getSourceLineForPlayer$lambda-2$lambda-0).collect(Collectors.toSet()));
            boolean bl2 = false;
            this.players = Sets.newHashSet();
            voiceSourceLine = voiceSourceLine2 = voiceSourceLine3;
        }
        return voiceSourceLine;
    }

    @Override
    @NotNull
    public ServerDirectSource createDirectSource(boolean stereo, @Nullable CodecInfo decoderInfo) {
        VoiceServerDirectSource voiceServerDirectSource;
        VoiceServerDirectSource it = voiceServerDirectSource = new VoiceServerDirectSource(this.getVoiceServer(), this.getVoiceServer().getUdpConnectionManager(), this.getAddon(), this, decoderInfo, stereo);
        boolean bl = false;
        Map<UUID, ServerAudioSource<?>> map = this.getSourceById();
        UUID uUID = it.getId();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"it.id");
        map.put(uUID, it);
        return voiceServerDirectSource;
    }

    @Override
    public void removeSource(@NotNull UUID sourceId) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        this.sourceById.remove(sourceId);
    }

    @Override
    @NotNull
    public Optional<ServerAudioSource<?>> getSourceById(@NotNull UUID sourceId) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Optional<ServerAudioSource<?>> optional = Optional.ofNullable(this.sourceById.get(sourceId));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(sourceById[sourceId])");
        return optional;
    }

    @Override
    @NotNull
    public Collection<ServerAudioSource<?>> getSources() {
        return this.sourceById.values();
    }

    @Override
    public void clear() {
        this.sourceById.clear();
    }

    private static final MinecraftGameProfile getSourceLineForPlayer$lambda-2$lambda-0(VoicePlayer linePlayer) {
        return linePlayer.getInstance().getGameProfile();
    }
}

