/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.server.world.ServerPos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerPlayerSource;
import su.plo.voice.api.server.player.VoicePlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.PlayerSourceInfo;
import su.plo.voice.server.audio.source.VoiceServerPositionalSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001cH\u0002R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerPlayerSource;", "Lsu/plo/voice/server/audio/source/VoiceServerPositionalSource;", "Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;", "Lsu/plo/voice/api/server/audio/source/ServerPlayerSource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "line", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "player", "Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;ZLsu/plo/voice/api/server/player/VoiceServerPlayer;)V", "getPlayer", "()Lsu/plo/voice/api/server/player/VoiceServerPlayer;", "playerPosition", "Lsu/plo/lib/api/server/world/ServerPos3d;", "position", "getPosition", "()Lsu/plo/lib/api/server/world/ServerPos3d;", "sourceInfo", "getSourceInfo", "()Lsu/plo/voice/proto/data/audio/source/PlayerSourceInfo;", "filterSelf", "Lsu/plo/voice/api/server/player/VoicePlayer;", "filterVanish", "common"})
public final class VoiceServerPlayerSource
extends VoiceServerPositionalSource<PlayerSourceInfo>
implements ServerPlayerSource {
    @NotNull
    private final VoiceServerPlayer player;
    @NotNull
    private final ServerPos3d playerPosition;

    public VoiceServerPlayerSource(@NotNull PlasmoVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull ServerSourceLine line, @Nullable CodecInfo decoderInfo, boolean stereo, @NotNull VoiceServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)voiceServer, (String)"voiceServer");
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        super(voiceServer, addon, uUID, line, decoderInfo, stereo);
        this.player = player;
        this.playerPosition = new ServerPos3d();
        this.addFilter(this::filterSelf);
        this.addFilter(this::filterVanish);
    }

    @Override
    @NotNull
    public VoiceServerPlayer getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public ServerPos3d getPosition() {
        ServerPos3d serverPos3d = this.getPlayer().getInstance().getServerPosition(this.playerPosition);
        Intrinsics.checkNotNullExpressionValue((Object)serverPos3d, (String)"player.instance.getServerPosition(playerPosition)");
        return serverPos3d;
    }

    @Override
    @NotNull
    public PlayerSourceInfo getSourceInfo() {
        return new PlayerSourceInfo(this.addon.getId(), this.id, this.line.getId(), this.name, (byte)this.state.get(), this.decoderInfo, this.stereo, this.iconVisible, this.angle, this.getPlayer().createPlayerInfo());
    }

    private final boolean filterSelf(VoicePlayer player) {
        return !Intrinsics.areEqual((Object)player, (Object)this.getPlayer());
    }

    private final boolean filterVanish(VoicePlayer player) {
        return ((VoiceServerPlayer)player).getInstance().canSee(this.getPlayer().getInstance());
    }
}

