/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.audio.source;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.api.server.world.ServerPos3d;
import su.plo.voice.api.addon.AddonContainer;
import su.plo.voice.api.event.Event;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.line.ServerSourceLine;
import su.plo.voice.api.server.audio.source.ServerPositionalSource;
import su.plo.voice.api.server.event.audio.source.ServerSourceAudioPacketEvent;
import su.plo.voice.api.server.event.audio.source.ServerSourcePacketEvent;
import su.plo.voice.api.server.socket.UdpServerConnection;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.audio.source.SourceInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.SourceInfoPacket;
import su.plo.voice.proto.packets.udp.clientbound.SourceAudioPacket;
import su.plo.voice.server.audio.source.BaseServerAudioSource;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001d*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004:\u0001\u001dB7\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0014\u001a\u00020\fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010\u001b\u001a\u00020\u00102\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerPositionalSource;", "S", "Lsu/plo/voice/proto/data/audio/source/SourceInfo;", "Lsu/plo/voice/server/audio/source/BaseServerAudioSource;", "Lsu/plo/voice/api/server/audio/source/ServerPositionalSource;", "voiceServer", "Lsu/plo/voice/api/server/PlasmoVoiceServer;", "addon", "Lsu/plo/voice/api/addon/AddonContainer;", "id", "Ljava/util/UUID;", "serverSourceLine", "Lsu/plo/voice/api/server/audio/line/ServerSourceLine;", "decoderInfo", "Lsu/plo/voice/proto/data/audio/codec/CodecInfo;", "stereo", "", "(Lsu/plo/voice/api/server/PlasmoVoiceServer;Lsu/plo/voice/api/addon/AddonContainer;Ljava/util/UUID;Lsu/plo/voice/api/server/audio/line/ServerSourceLine;Lsu/plo/voice/proto/data/audio/codec/CodecInfo;Z)V", "playerPosition", "Lsu/plo/lib/api/server/world/ServerPos3d;", "getLine", "sendAudioPacket", "packet", "Lsu/plo/voice/proto/packets/udp/clientbound/SourceAudioPacket;", "distance", "", "activationId", "sendPacket", "Lsu/plo/voice/proto/packets/Packet;", "Companion", "common"})
public abstract class VoiceServerPositionalSource<S extends SourceInfo>
extends BaseServerAudioSource<S>
implements ServerPositionalSource<S> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlasmoVoiceServer voiceServer;
    @NotNull
    private final ServerSourceLine serverSourceLine;
    @NotNull
    private final ServerPos3d playerPosition;
    private static final int DISTANCE_MULTIPLIER = 2;

    public VoiceServerPositionalSource(@NotNull PlasmoVoiceServer voiceServer, @NotNull AddonContainer addon, @NotNull UUID id, @NotNull ServerSourceLine serverSourceLine, @Nullable CodecInfo decoderInfo, boolean stereo) {
        Intrinsics.checkNotNullParameter((Object)voiceServer, (String)"voiceServer");
        Intrinsics.checkNotNullParameter((Object)addon, (String)"addon");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)serverSourceLine, (String)"serverSourceLine");
        super(addon, id, serverSourceLine, decoderInfo, stereo);
        this.voiceServer = voiceServer;
        this.serverSourceLine = serverSourceLine;
        this.playerPosition = new ServerPos3d();
    }

    @Override
    public boolean sendAudioPacket(@NotNull SourceAudioPacket packet, short distance) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        return this.sendAudioPacket(packet, distance, null);
    }

    @Override
    public boolean sendAudioPacket(@NotNull SourceAudioPacket packet, short distance, @Nullable UUID activationId) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        ServerSourceAudioPacketEvent event = new ServerSourceAudioPacketEvent(this, packet, distance, activationId);
        if (!this.voiceServer.getEventBus().call((Event)event)) {
            return false;
        }
        packet.setSourceState((byte)this.state.get());
        int listenersDistance = event.getDistance() * 2;
        if (this.dirty.compareAndSet(true, false)) {
            this.sendPacket(new SourceInfoPacket((SourceInfo)this.getSourceInfo()), (short)listenersDistance);
        }
        ServerPos3d sourcePosition = this.getPosition();
        double distanceSquared = listenersDistance * listenersDistance;
        for (UdpServerConnection connection : this.voiceServer.getUdpConnectionManager().getConnections()) {
            if (this.notMatchFilters(connection.getPlayer())) continue;
            connection.getPlayer().getInstance().getServerPosition(this.playerPosition);
            if (!Intrinsics.areEqual((Object)sourcePosition.getWorld(), (Object)this.playerPosition.getWorld()) || !(sourcePosition.distanceSquared(this.playerPosition) <= distanceSquared)) continue;
            connection.sendPacket(packet);
        }
        return true;
    }

    @Override
    public boolean sendPacket(@NotNull Packet<?> packet, short distance) {
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        ServerSourcePacketEvent event = new ServerSourcePacketEvent(this, packet, distance);
        if (!this.voiceServer.getEventBus().call((Event)event)) {
            return false;
        }
        int listenersDistance = event.getDistance() * 2;
        ServerPos3d sourcePosition = this.getPosition();
        double distanceSquared = listenersDistance * listenersDistance;
        for (UdpServerConnection connection : this.voiceServer.getUdpConnectionManager().getConnections()) {
            if (this.notMatchFilters(connection.getPlayer())) continue;
            connection.getPlayer().getInstance().getServerPosition(this.playerPosition);
            if (!Intrinsics.areEqual((Object)sourcePosition.getWorld(), (Object)this.playerPosition.getWorld()) || !(sourcePosition.distanceSquared(this.playerPosition) <= distanceSquared)) continue;
            connection.getPlayer().sendPacket(packet);
        }
        return true;
    }

    @Override
    @NotNull
    public ServerSourceLine getLine() {
        return this.serverSourceLine;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsu/plo/voice/server/audio/source/VoiceServerPositionalSource$Companion;", "", "()V", "DISTANCE_MULTIPLIER", "", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

