/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import su.plo.lib.mod.server.entity.ModServerPlayer;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.PacketHandler;
import su.plo.voice.proto.packets.tcp.PacketTcpCodec;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.connection.BaseServerChannelHandler;
import su.plo.voice.server.connection.PlayerChannelHandler;

public final class ModServerChannelHandler
extends BaseServerChannelHandler {
    public static ModServerChannelHandler INSTANCE;

    public ModServerChannelHandler(@NotNull BaseVoiceServer voiceServer) {
        super(voiceServer);
        INSTANCE = this;
    }

    @Override
    protected void handleRegisterChannels(List<String> channels, VoiceServerPlayer player) {
        super.handleRegisterChannels(channels, player);
        channels.forEach(channel -> ((ModServerPlayer)player.getInstance()).addChannel((String)channel));
    }

    private void receive(ServerPlayer player, FriendlyByteBuf buf) {
        byte[] data = ByteBufUtil.getBytes((ByteBuf)buf.duplicate());
        try {
            PacketTcpCodec.decode(ByteStreams.newDataInput((byte[])data)).ifPresent(packet -> {
                VoiceServerPlayer voicePlayer = this.voiceServer.getPlayerManager().wrap(player);
                PlayerChannelHandler channel = this.channels.computeIfAbsent(player.m_20148_(), playerId -> new PlayerChannelHandler(this.voiceServer, voicePlayer));
                channel.handlePacket((Packet<PacketHandler>)packet);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onChannelRegister(@NotNull ServerPlayer serverPlayer, @NotNull ServerboundCustomPayloadPacket packet) {
        FriendlyByteBuf buf = packet.m_179590_();
        ArrayList<ResourceLocation> channels = new ArrayList<ResourceLocation>();
        StringBuilder active = new StringBuilder();
        while (buf.isReadable()) {
            byte b = buf.readByte();
            if (b != 0) {
                active.append(AsciiString.b2c((byte)b));
                continue;
            }
            try {
                channels.add(new ResourceLocation(active.toString()));
            }
            catch (ResourceLocationException ex) {
                continue;
            }
            active = new StringBuilder();
        }
        VoiceServerPlayer player = this.voiceServer.getPlayerManager().wrap(serverPlayer);
        this.handleRegisterChannels(channels.stream().map(ResourceLocation::toString).collect(Collectors.toList()), player);
    }

    public void receive(@NotNull NetworkEvent event) {
        NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
        if (context.getDirection() != NetworkDirection.PLAY_TO_SERVER || event.getPayload() == null) {
            return;
        }
        this.receive(context.getSender(), event.getPayload());
        context.setPacketHandled(true);
    }
}

