/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.IOException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.connection.BaseServerServiceChannelHandler;

public final class ModServerServiceChannelHandler
extends BaseServerServiceChannelHandler {
    public ModServerServiceChannelHandler(@NotNull BaseVoiceServer voiceServer) {
        super(voiceServer);
    }

    private void receive(ServerPlayer player, FriendlyByteBuf buf) {
        byte[] data = ByteBufUtil.getBytes((ByteBuf)buf.duplicate());
        try {
            VoiceServerPlayer voicePlayer = this.voiceServer.getPlayerManager().wrap(player);
            this.handlePacket(voicePlayer, data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void receive(@NotNull NetworkEvent event) {
        NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
        if (context.getDirection() != NetworkDirection.PLAY_TO_SERVER || event.getPayload() == null) {
            return;
        }
        this.receive(context.getSender(), event.getPayload());
        context.setPacketHandled(true);
    }
}

