/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server.connection;

import com.google.common.collect.Maps;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.crypto.Cipher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.server.config.ServerConfig;
import su.plo.voice.api.server.connection.TcpServerConnectionManager;
import su.plo.voice.api.server.player.VoiceServerPlayer;
import su.plo.voice.proto.data.audio.capture.CaptureInfo;
import su.plo.voice.proto.data.audio.capture.VoiceActivation;
import su.plo.voice.proto.data.audio.codec.CodecInfo;
import su.plo.voice.proto.data.encryption.EncryptionInfo;
import su.plo.voice.proto.packets.Packet;
import su.plo.voice.proto.packets.tcp.clientbound.ClientPacketTcpHandler;
import su.plo.voice.proto.packets.tcp.clientbound.ConfigPacket;
import su.plo.voice.proto.packets.tcp.clientbound.ConnectionPacket;
import su.plo.voice.proto.packets.tcp.clientbound.PlayerInfoRequestPacket;
import su.plo.voice.proto.packets.tcp.clientbound.PlayerInfoUpdatePacket;
import su.plo.voice.proto.packets.tcp.clientbound.PlayerListPacket;
import su.plo.voice.server.BaseVoiceServer;
import su.plo.voice.server.config.VoiceServerConfig;

public final class VoiceTcpServerConnectionManager
implements TcpServerConnectionManager {
    private final BaseVoiceServer voiceServer;
    private final Object playerStateLock = new Object();

    public VoiceTcpServerConnectionManager(@NotNull BaseVoiceServer voiceServer) {
        this.voiceServer = voiceServer;
    }

    @Override
    public void broadcast(@NotNull Packet<ClientPacketTcpHandler> packet, @Nullable Predicate<VoiceServerPlayer> filter) {
        for (VoiceServerPlayer player : this.voiceServer.getPlayerManager().getPlayers()) {
            if (filter != null && !filter.test(player) || !player.hasVoiceChat()) continue;
            player.sendPacket(packet);
        }
    }

    @Override
    public void connect(@NotNull VoiceServerPlayer player) {
        int port;
        if (!this.voiceServer.getUdpServer().isPresent() || this.voiceServer.getConfig() == null) {
            return;
        }
        UUID secret = this.voiceServer.getUdpConnectionManager().getSecretByPlayerId(player.getInstance().getUUID());
        VoiceServerConfig.Host host = this.voiceServer.getConfig().host();
        ServerConfig.Host.Public hostPublic = host.hostPublic();
        String ip = host.ip();
        if (hostPublic != null) {
            ip = hostPublic.ip();
        }
        int n = port = hostPublic != null ? hostPublic.port() : host.port();
        if (port == 0 && (port = host.port()) == 0) {
            port = this.voiceServer.getUdpServer().get().getRemoteAddress().get().getPort();
        }
        player.sendPacket(new ConnectionPacket(secret, ip, port));
        BaseVoice.DEBUG_LOGGER.log("Sent connection packet to {}", player.getInstance().getName());
    }

    @Override
    public void requestPlayerInfo(@NotNull VoiceServerPlayer player) {
        player.sendPacket(new PlayerInfoRequestPacket());
        BaseVoice.DEBUG_LOGGER.log("Sent player info request packet to {}", player.getInstance().getName());
    }

    @Override
    public void sendConfigInfo(@NotNull VoiceServerPlayer receiver) {
        EncryptionInfo aesEncryption;
        if (!this.voiceServer.getUdpServer().isPresent() || this.voiceServer.getConfig() == null) {
            return;
        }
        VoiceServerConfig config = this.voiceServer.getConfig();
        ServerConfig.Voice voiceConfig = config.voice();
        ServerConfig.Voice.Opus opusConfig = voiceConfig.opus();
        HashMap codecParams = Maps.newHashMap();
        codecParams.put("mode", opusConfig.mode());
        codecParams.put("bitrate", String.valueOf(opusConfig.bitrate()));
        try {
            PublicKey publicKey = receiver.getPublicKey().orElseThrow(() -> new IllegalStateException(receiver + " has empty public key"));
            Cipher encryptCipher = Cipher.getInstance("RSA");
            encryptCipher.init(1, publicKey);
            aesEncryption = new EncryptionInfo("AES/CBC/PKCS5Padding", encryptCipher.doFinal(voiceConfig.aesEncryptionKey()));
        }
        catch (Exception e) {
            BaseVoice.LOGGER.error("Failed to encode encryption data: {}", (Object)e.toString());
            e.printStackTrace();
            return;
        }
        ConfigPacket packet = new ConfigPacket(UUID.fromString(config.serverId()), new CaptureInfo(voiceConfig.sampleRate(), voiceConfig.mtuSize(), new CodecInfo("opus", codecParams)), aesEncryption, this.voiceServer.getSourceLineManager().getLines().stream().map(line -> line.getSourceLineForPlayer(receiver)).collect(Collectors.toSet()), this.voiceServer.getActivationManager().getActivations().stream().filter(activation -> activation.checkPermissions(receiver)).map(activation -> (VoiceActivation)((Object)activation)).collect(Collectors.toSet()), this.getPlayerPermissions(receiver));
        receiver.sendPacket(packet);
        BaseVoice.DEBUG_LOGGER.log("Sent {} to {}", packet, receiver.getInstance().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendPlayerList(@NotNull VoiceServerPlayer receiver) {
        Object object = this.playerStateLock;
        synchronized (object) {
            receiver.sendPacket(new PlayerListPacket(this.voiceServer.getUdpConnectionManager().getConnections().stream().filter(connection -> receiver.getInstance().canSee(connection.getPlayer().getInstance())).map(connection -> connection.getPlayer().createPlayerInfo()).collect(Collectors.toList())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void broadcastPlayerInfoUpdate(@NotNull VoiceServerPlayer player) {
        Object object = this.playerStateLock;
        synchronized (object) {
            this.broadcast(new PlayerInfoUpdatePacket(player.createPlayerInfo()), (VoiceServerPlayer player1) -> player1.getInstance().canSee(player.getInstance()));
        }
    }

    private Map<String, Boolean> getPlayerPermissions(@NotNull VoiceServerPlayer player) {
        HashMap permissions = Maps.newHashMap();
        this.voiceServer.getPlayerManager().getSynchronizedPermissions().forEach(permission -> permissions.put(permission, player.getInstance().hasPermission((String)permission)));
        return permissions;
    }
}

