/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.universal;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import su.plo.voice.universal.UMinecraft;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u001bH\u0002J+\u0010\u001f\u001a\u00020\u00042\u0012\u0010 \u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0!\"\u00020\u001b2\b\b\u0002\u0010\"\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bH\u0007R&\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0005\u0010\u0007R&\u0010\b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\b\u0010\u0007R&\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\n\u0010\u0007R&\u0010\f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\f\u0010\u0007R&\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u000e\u0010\u0007R&\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006'"}, d2={"Lsu/plo/voice/universal/UDesktop;", "", "()V", "<set-?>", "", "isGnome", "isGnome$annotations", "()Z", "isKde", "isKde$annotations", "isLinux", "isLinux$annotations", "isMac", "isMac$annotations", "isWindows", "isWindows$annotations", "isXdg", "isXdg$annotations", "browse", "uri", "Ljava/net/URI;", "browseDesktop", "edit", "file", "Ljava/io/File;", "editDesktop", "getClipboardString", "", "open", "openDesktop", "openSystemSpecific", "runCommand", "command", "", "checkExitStatus", "([Ljava/lang/String;Z)Z", "setClipboardString", "", "str", "universalcraft"})
public final class UDesktop {
    @NotNull
    public static final UDesktop INSTANCE;
    private static boolean isLinux;
    private static boolean isXdg;
    private static boolean isKde;
    private static boolean isGnome;
    private static boolean isMac;
    private static boolean isWindows;

    private UDesktop() {
    }

    public static final boolean isLinux() {
        return isLinux;
    }

    @JvmStatic
    public static /* synthetic */ void isLinux$annotations() {
    }

    public static final boolean isXdg() {
        return isXdg;
    }

    @JvmStatic
    public static /* synthetic */ void isXdg$annotations() {
    }

    public static final boolean isKde() {
        return isKde;
    }

    @JvmStatic
    public static /* synthetic */ void isKde$annotations() {
    }

    public static final boolean isGnome() {
        return isGnome;
    }

    @JvmStatic
    public static /* synthetic */ void isGnome$annotations() {
    }

    public static final boolean isMac() {
        return isMac;
    }

    @JvmStatic
    public static /* synthetic */ void isMac$annotations() {
    }

    public static final boolean isWindows() {
        return isWindows;
    }

    @JvmStatic
    public static /* synthetic */ void isWindows$annotations() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean browse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (INSTANCE.browseDesktop(uri)) return true;
        String string = uri.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
        if (!INSTANCE.openSystemSpecific(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean open(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (INSTANCE.openDesktop(file)) return true;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        if (!INSTANCE.openSystemSpecific(string)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean edit(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (INSTANCE.editDesktop(file)) return true;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        if (!INSTANCE.openSystemSpecific(string)) return false;
        return true;
    }

    private final boolean openSystemSpecific(String file) {
        boolean bl;
        block9: {
            if (isLinux) {
                Object[] objectArray = new String[]{"xdg-open", "kde-open", "gnome-open"};
                Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        String[] stringArray = new String[]{it, file};
                        if (!INSTANCE.runCommand(stringArray, true)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            } else if (isMac) {
                String[] stringArray = new String[]{"open", file};
                bl = UDesktop.runCommand$default(this, stringArray, false, 2, null);
            } else if (isWindows) {
                String[] stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", file};
                bl = UDesktop.runCommand$default(this, stringArray, false, 2, null);
            } else {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean browseDesktop(URI uri) {
        boolean bl;
        if (!Desktop.isDesktopSupported()) {
            bl = false;
        } else {
            boolean bl2;
            try {
                if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                    return false;
                }
                Desktop.getDesktop().browse(uri);
                bl2 = true;
            }
            catch (Throwable e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean openDesktop(File file) {
        boolean bl;
        if (!Desktop.isDesktopSupported()) {
            bl = false;
        } else {
            boolean bl2;
            try {
                if (!Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                    return false;
                }
                Desktop.getDesktop().open(file);
                bl2 = true;
            }
            catch (Throwable e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean editDesktop(File file) {
        boolean bl;
        if (!Desktop.isDesktopSupported()) {
            bl = false;
        } else {
            boolean bl2;
            try {
                if (!Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
                    return false;
                }
                Desktop.getDesktop().edit(file);
                bl2 = true;
            }
            catch (Throwable e) {
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    private final boolean runCommand(String[] command, boolean checkExitStatus) {
        boolean bl;
        try {
            Process process2 = Runtime.getRuntime().exec(command);
            if (process2 == null) {
                return false;
            }
            Process process3 = process2;
            bl = checkExitStatus ? (process3.waitFor(3L, TimeUnit.SECONDS) ? process3.exitValue() == 0 : true) : process3.isAlive();
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean runCommand$default(UDesktop uDesktop, String[] stringArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return uDesktop.runCommand(stringArray, bl);
    }

    @JvmStatic
    @NotNull
    public static final String getClipboardString() {
        String string = UMinecraft.getMinecraft().f_91068_.m_90876_();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMinecraft().keyboardHandler.clipboard");
        return string;
    }

    @JvmStatic
    public static final void setClipboardString(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        UMinecraft.getMinecraft().f_91068_.m_90911_(str);
    }

    static {
        String string;
        INSTANCE = new UDesktop();
        try {
            string = System.getProperty("os.name");
        }
        catch (SecurityException e) {
            string = null;
        }
        String osName = string;
        isLinux = osName != null && (StringsKt.startsWith$default((String)osName, (String)"Linux", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)osName, (String)"LINUX", (boolean)false, (int)2, null));
        isMac = osName != null && StringsKt.startsWith$default((String)osName, (String)"Mac", (boolean)false, (int)2, null);
        boolean bl = isWindows = osName != null && StringsKt.startsWith$default((String)osName, (String)"Windows", (boolean)false, (int)2, null);
        if (isLinux) {
            String string2 = System.getenv("XDG_SESSION_ID");
            if (string2 != null) {
                String it = string2;
                boolean bl2 = false;
                isXdg = ((CharSequence)it).length() > 0;
            }
            string = System.getenv("GDMSESSION");
            if (string != null) {
                String string3 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
                if (string3 != null) {
                    String it = string3;
                    boolean bl3 = false;
                    isGnome = StringsKt.contains$default((CharSequence)it, (CharSequence)"gnome", (boolean)false, (int)2, null);
                    isKde = StringsKt.contains$default((CharSequence)it, (CharSequence)"kde", (boolean)false, (int)2, null);
                }
            }
        } else {
            isXdg = false;
            isKde = false;
            isGnome = false;
        }
    }
}

