/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.util.version;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Optional;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import su.plo.voice.util.version.ModrinthLoader;
import su.plo.voice.util.version.SemanticVersion;

public final class ModrinthVersion {
    private static final Gson GSON = new Gson();
    private final SemanticVersion version;
    private final String downloadLink;

    public static Optional<ModrinthVersion> checkForUpdates(@NonNull String voiceVersion, @NonNull String minecraftVersion, @NonNull ModrinthLoader loader) throws IOException {
        if (voiceVersion == null) {
            throw new NullPointerException("voiceVersion is marked non-null but is null");
        }
        if (minecraftVersion == null) {
            throw new NullPointerException("minecraftVersion is marked non-null but is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        SemanticVersion version = SemanticVersion.parse(voiceVersion);
        return ModrinthVersion.getLatest(minecraftVersion, loader, !version.isRelease(), null).filter(latestVersion -> !version.isRelease() && !latestVersion.version().equals(version) && !latestVersion.version().isOutdated(version) || version.isOutdated(latestVersion.version()));
    }

    public static Optional<ModrinthVersion> from(@NonNull String stringVersion, @NonNull String minecraftVersion, @NonNull ModrinthLoader loader) throws IOException {
        if (stringVersion == null) {
            throw new NullPointerException("stringVersion is marked non-null but is null");
        }
        if (minecraftVersion == null) {
            throw new NullPointerException("minecraftVersion is marked non-null but is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        JsonArray versions = ModrinthVersion.getVersions(minecraftVersion, loader);
        for (JsonElement jsonElement : versions) {
            JsonArray files;
            JsonObject version = jsonElement.getAsJsonObject();
            String versionNumber = version.get("version_number").getAsString();
            if (!versionNumber.contains(stringVersion) || (files = version.get("files").getAsJsonArray()).size() == 0) continue;
            return Optional.of(new ModrinthVersion(SemanticVersion.parse(versionNumber), files.get(0).getAsJsonObject().get("url").getAsString()));
        }
        return Optional.empty();
    }

    public static Optional<ModrinthVersion> getLatest(@NonNull String minecraftVersion, @NonNull ModrinthLoader loader, boolean alpha, @Nullable SemanticVersion targetVersion) throws IOException {
        if (minecraftVersion == null) {
            throw new NullPointerException("minecraftVersion is marked non-null but is null");
        }
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        JsonArray versions = ModrinthVersion.getVersions(minecraftVersion, loader);
        for (JsonElement jsonElement : versions) {
            JsonObject version = jsonElement.getAsJsonObject();
            String versionType = version.get("version_type").getAsString();
            if (versionType.equals("alpha") && !alpha) continue;
            String versionNumber = version.get("version_number").getAsString();
            JsonArray files = version.get("files").getAsJsonArray();
            if (files.size() == 0) continue;
            SemanticVersion semanticVersion = SemanticVersion.parse(versionNumber);
            if (targetVersion != null && semanticVersion.major() != targetVersion.major()) continue;
            return Optional.of(new ModrinthVersion(semanticVersion, files.get(0).getAsJsonObject().get("url").getAsString()));
        }
        return Optional.empty();
    }

    /*
     * Exception decompiling
     */
    private static JsonArray getVersions(@NonNull String minecraftVersion, @NonNull ModrinthLoader loader) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SemanticVersion version() {
        return this.version;
    }

    public String downloadLink() {
        return this.downloadLink;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModrinthVersion)) {
            return false;
        }
        ModrinthVersion other = (ModrinthVersion)o;
        SemanticVersion this$version = this.version();
        SemanticVersion other$version = other.version();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$downloadLink = this.downloadLink();
        String other$downloadLink = other.downloadLink();
        return !(this$downloadLink == null ? other$downloadLink != null : !this$downloadLink.equals(other$downloadLink));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SemanticVersion $version = this.version();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $downloadLink = this.downloadLink();
        result = result * 59 + ($downloadLink == null ? 43 : $downloadLink.hashCode());
        return result;
    }

    public String toString() {
        return "ModrinthVersion(version=" + this.version() + ", downloadLink=" + this.downloadLink() + ")";
    }

    public ModrinthVersion(SemanticVersion version, String downloadLink) {
        this.version = version;
        this.downloadLink = downloadLink;
    }
}

