/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.gml.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class Reflections {
    private static final Unsafe UNSAFE;
    private static final MethodHandles.Lookup HANDLE;

    public static <T> T getStaticField(Field field) {
        return (T)UNSAFE.getObject(UNSAFE.staticFieldBase(field), UNSAFE.staticFieldOffset(field));
    }

    public static <T> MethodCaller<T> methodSpecial(Class<?> clazz, String name, MethodType methodType) throws Exception {
        MethodHandle handle = HANDLE.findSpecial(clazz, name, methodType, clazz);
        return Reflections.caller(handle);
    }

    public static <T> MethodCaller<T> constructor(Class<?> clazz, MethodType methodType) throws Exception {
        MethodHandle handle = HANDLE.findConstructor(clazz, methodType);
        return Reflections.caller(handle);
    }

    private static <T> MethodCaller<T> caller(MethodHandle handle) {
        return args -> {
            if (args.length == 0) {
                return handle.invoke();
            }
            return handle.invokeWithArguments(args);
        };
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (Unsafe)theUnsafe.get(null);
            HANDLE = (MethodHandles.Lookup)Reflections.getStaticField(MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP"));
        }
        catch (Exception exception) {
            throw new RuntimeException("hmmmmm");
        }
    }

    public static interface MethodCaller<T> {
        public T call(Object ... var1) throws Throwable;
    }
}

