/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.widget;

import com.legacy.structure_gel.core.util.SGText;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraftforge.common.util.Lazy;

public class SuggestionEditBox
extends EditBox {
    private final SuggestionComponent<?> suggestions;

    public <T> SuggestionEditBox(Font font, int x, int y, int width, int height, Component name, int maxSuggestionLines, Supplier<Collection<T>> suggestions, Function<T, String> toString) {
        super(font, x, y, width, height, name);
        this.suggestions = new SuggestionComponent<T>((EditBox)this, suggestions, toString, maxSuggestionLines);
        this.m_94151_(s -> {});
    }

    public SuggestionEditBox(Font font, int x, int y, int width, int height, Component name, int maxSuggestionLines, Collection<?> suggestions) {
        this(font, x, y, width, height, name, maxSuggestionLines, () -> suggestions, Object::toString);
    }

    public void m_86412_(PoseStack posStack, int mouseX, int mouseY, float partialTicks) {
        super.m_86412_(posStack, mouseX, mouseY, partialTicks);
        if (this.m_93696_() && this.m_142518_()) {
            this.suggestions.x = this.m_252754_() - 1;
            this.suggestions.y = this.m_252907_() + this.m_93694_() + 1;
            this.suggestions.m_86412_(posStack, mouseX, mouseY, partialTicks);
        }
    }

    public void m_93692_(boolean isFocused) {
        super.m_93692_(isFocused);
        this.suggestions.update(this.m_94155_());
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        boolean isOverText = super.m_5953_(mouseX, mouseY);
        if (this.m_93696_() && (isOverText || this.suggestions.m_5953_(mouseX, mouseY))) {
            return true;
        }
        return isOverText;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.suggestions.m_6050_(mouseX, mouseY, amount) && this.m_142518_()) {
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickType) {
        if (this.m_93696_() && this.suggestions.m_5953_(mouseX, mouseY) && this.m_142518_()) {
            return this.suggestions.m_6375_(mouseX, mouseY, clickType);
        }
        return super.m_6375_(mouseX, mouseY, clickType);
    }

    public boolean m_7933_(int keyCode, int keyB, int modifiers) {
        if (this.m_142518_()) {
            if (keyCode == 256 && this.m_93696_()) {
                this.m_93692_(false);
                return true;
            }
            if (this.suggestions.m_7933_(keyCode, keyB, modifiers)) {
                return true;
            }
        }
        return super.m_7933_(keyCode, keyB, modifiers);
    }

    public void m_94151_(Consumer<String> responder) {
        super.m_94151_(s -> {
            responder.accept((String)s);
            this.suggestions.update(this.m_94155_());
        });
    }

    public static class SuggestionComponent<T>
    extends GuiComponent
    implements Renderable,
    GuiEventListener {
        private final Minecraft mc = Minecraft.m_91087_();
        private final EditBox parent;
        private int maxLines;
        private final int absoluteMaxLines;
        private final Supplier<Collection<T>> allOptions;
        private final Function<T, String> toStringFunc;
        public int x;
        public int y;
        private int height = 10;
        private int width = 10;
        private List<String> currentOptions = new ArrayList<String>();
        private int lineRenderStart = 0;
        private int selectedLine = 0;

        public SuggestionComponent(EditBox parent, Supplier<Collection<T>> suggestions, Function<T, String> toString, int maxLines) {
            this.parent = parent;
            this.x = parent.m_252754_() - 1;
            this.y = parent.m_252907_() + parent.m_93694_() + 1;
            this.allOptions = suggestions;
            this.toStringFunc = toString;
            this.absoluteMaxLines = maxLines;
            this.maxLines = maxLines;
            this.update("");
        }

        public SuggestionComponent(EditBox parent, Collection<T> suggestions, Function<T, String> toString, int maxLines) {
            this(parent, (Supplier<Collection<T>>)Lazy.of(() -> suggestions), toString, maxLines);
        }

        public boolean m_93696_() {
            return false;
        }

        public void m_93692_(boolean isFocused) {
        }

        public List<String> retrieveAll() {
            List<String> all = this.allOptions.get().stream().map(this.toStringFunc).collect(Collectors.toList());
            this.maxLines = Math.min(all.size(), this.absoluteMaxLines);
            return all;
        }

        public void update(String input) {
            this.currentOptions.clear();
            List<String> all = this.retrieveAll();
            if (input.isEmpty()) {
                this.currentOptions.addAll(all);
            } else {
                all.stream().filter(s -> s.startsWith(input) || s.contains(":") && s.substring(s.indexOf(":") + 1).startsWith(input)).forEach(this.currentOptions::add);
                all.stream().filter(s -> !this.currentOptions.contains(s)).filter(s -> s.contains(input)).forEach(this.currentOptions::add);
            }
            this.currentOptions.sort(String::compareToIgnoreCase);
            int size = this.currentOptions.size();
            ArrayList<Object> putToTop = new ArrayList<Object>();
            for (int i = 0; i < size; ++i) {
                String s2 = this.currentOptions.get(i);
                if (ResourceLocation.m_135830_((String)s2)) {
                    ResourceLocation loc = new ResourceLocation(s2);
                    if (!loc.m_135815_().startsWith(input) && !loc.m_135815_().equals(input) && !s2.equals(input)) continue;
                    putToTop.add(putToTop.size(), s2);
                    continue;
                }
                if (!s2.startsWith(input)) continue;
                putToTop.add(putToTop.size(), s2);
            }
            this.currentOptions.removeAll(putToTop);
            this.currentOptions.addAll(0, putToTop);
            int maxWidth = 0;
            for (String op : this.currentOptions) {
                int w = this.mc.f_91062_.m_92895_(op);
                if (w <= maxWidth) continue;
                maxWidth = w;
            }
            this.width = maxWidth + 2;
            int lines = Math.min(this.maxLines, this.currentOptions.size());
            Objects.requireNonNull(this.mc.f_91062_);
            this.height = 9 * lines + lines * 2 + 4;
            this.selectedLine = 0;
            this.lineRenderStart = 0;
        }

        @Nullable
        public String getSelected() {
            if (this.selectedLine < this.currentOptions.size() && this.selectedLine > -1) {
                return this.currentOptions.get(this.selectedLine);
            }
            return null;
        }

        public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            int size = this.currentOptions.size();
            if (size < 1) {
                return;
            }
            if (this.maxLines > 0) {
                GuiComponent.m_93172_((PoseStack)poseStack, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)FastColor.ARGB32.m_13660_((int)200, (int)10, (int)10, (int)10));
                Font font = this.mc.f_91062_;
                for (int line = 0; line < this.maxLines; ++line) {
                    int renderLine = line + this.lineRenderStart;
                    if (renderLine >= size) continue;
                    Objects.requireNonNull(font);
                    SuggestionComponent.m_93236_((PoseStack)poseStack, (Font)font, (String)this.currentOptions.get(renderLine), (int)(this.x + 1), (int)(this.y + 4 + line * (9 + 2)), (int)(renderLine == this.selectedLine ? ChatFormatting.AQUA.m_126665_() : ChatFormatting.DARK_GREEN.m_126665_()));
                }
                if (size > this.maxLines) {
                    int startX = this.x + this.width;
                    int h = 6;
                    int startY = this.y + (int)((double)this.selectedLine / (double)size * (double)(this.height - h));
                    Objects.requireNonNull(this.mc.f_91062_);
                    GuiComponent.m_93172_((PoseStack)poseStack, (int)startX, (int)startY, (int)(startX + 2), (int)(startY + 9 + h), (int)Integer.MAX_VALUE);
                }
            }
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, -10.0f);
            SuggestionComponent.m_93236_((PoseStack)poseStack, (Font)this.mc.f_91062_, (String)this.getSelected(), (int)(this.x + 5), (int)(this.y - this.parent.m_93694_() / 2 - 5), (int)SGText.TRANSPARENT_GRAY);
            poseStack.m_85849_();
        }

        public boolean m_6050_(double mouseX, double mouseY, double amount) {
            if (this.currentOptions.size() > 1) {
                int dir;
                int n = dir = amount < 0.0 ? -1 : 1;
                if (dir < 0) {
                    this.moveSelectorDown();
                } else if (dir > 0) {
                    this.moveSelectorUp();
                }
                return true;
            }
            return false;
        }

        public boolean m_7933_(int keyCode, int keyB, int modifiers) {
            if (keyCode == 258) {
                String selectedVal = this.getSelected();
                if (selectedVal != null && !this.parent.m_94155_().equals(selectedVal)) {
                    this.parent.m_94144_(selectedVal);
                    return true;
                }
            } else {
                if (keyCode == 264) {
                    this.moveSelectorDown();
                    return true;
                }
                if (keyCode == 265) {
                    this.moveSelectorUp();
                    return true;
                }
            }
            return false;
        }

        public boolean m_6375_(double mouseX, double mouseY, int clickType) {
            double d = mouseY - (double)this.y - 2.0;
            Objects.requireNonNull(this.mc.f_91062_);
            int clickedLine = (int)(d / (double)(9 + 2));
            this.selectedLine = Math.min(Math.max(0, clickedLine), this.maxLines - 1) + this.lineRenderStart;
            String selected = this.getSelected();
            if (selected != null) {
                this.parent.m_94144_(selected);
                return true;
            }
            return false;
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return mouseX > (double)this.x && mouseX < (double)(this.x + this.width) && mouseY > (double)this.y && mouseY < (double)(this.y + this.height);
        }

        public void moveSelectorDown() {
            if (this.selectedLine < this.currentOptions.size() - 1) {
                ++this.selectedLine;
                if (this.selectedLine > this.lineRenderStart + this.maxLines - 1) {
                    ++this.lineRenderStart;
                }
            } else {
                this.selectedLine = 0;
                this.lineRenderStart = 0;
            }
        }

        public void moveSelectorUp() {
            if (this.selectedLine > 0) {
                --this.selectedLine;
                if (this.selectedLine < this.lineRenderStart) {
                    --this.lineRenderStart;
                }
            } else {
                this.selectedLine = this.currentOptions.size() - 1;
                if (this.selectedLine > this.lineRenderStart + this.maxLines - 1) {
                    this.lineRenderStart = this.currentOptions.size() - this.maxLines;
                }
            }
        }
    }
}

