/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolBounds;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.SmartBoundingBox;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.network.ActionHistoryPacket;
import com.legacy.structure_gel.core.network.LeftClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.MiddleClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.network.RightClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.UpdateBuildingToolPacket;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;

public final class BuildingToolItem
extends Item {
    private static final String MODE_KEY = "tool_mode";
    private static final String POSES_KEY = "poses";
    private static final String PALLETE_KEY = "pallete";
    private static final String STATE_KEY = "state";
    private static final String WEIGHT_KEY = "weight";
    private static final String PROPERTIES_KEY = "properties";
    private static final String CORNER_KEY = "selected_corner";
    private static final String CORNER_DIST_KEY = "selected_corner_distance";
    private static final String MOVE_BOUNDS_KEY = "move_bounds";
    private static final String REACH_DISTANCE_MODIFIER_KEY = "reach_distance";
    private static final UUID REACH_UUID = UUID.fromString("d247f451-91f5-4819-8bc4-c3ad0baf94fe");
    private final BiFunction<BuildingToolMode, String, Component> nameCache = Util.m_143821_((mode, name) -> Component.m_237113_((String)name).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_(mode.getComponent()));
    private static final Component NO_PERMISSION = Component.m_237115_((String)"info.structure_gel.building_tool.message.no_permission").m_130940_(ChatFormatting.RED);
    private static final String INFO_NAME = "item.structure_gel.building_tool.info.";
    public static final String BLOCK_PALLETE_NAME = "info.structure_gel.building_tool.block_pallete";

    @OnlyIn(value=Dist.CLIENT)
    private void clientInit() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(event -> {
            BlockPos blockPos;
            HitResult patt4751$temp = Minecraft.m_91087_().f_91077_;
            if (patt4751$temp instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)patt4751$temp;
                blockPos = blockHit.m_82425_();
            } else {
                blockPos = null;
            }
            this.onLeftClickEvent((PlayerInteractEvent)event, blockPos);
        });
        bus.addListener(event -> this.onLeftClickEvent((PlayerInteractEvent)event, event.getPos()));
        bus.addListener(event -> {
            BlockPos blockPos;
            HitResult patt5083$temp = Minecraft.m_91087_().f_91077_;
            if (patt5083$temp instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)patt5083$temp;
                blockPos = blockHit.m_82425_();
            } else {
                blockPos = null;
            }
            this.onRightClickEvent((PlayerInteractEvent)event, blockPos);
        });
        bus.addListener(event -> this.onRightClickEvent((PlayerInteractEvent)event, event.getPos()));
        bus.addListener(event -> this.processKeyPress((InputEvent.Key)event));
        bus.addListener(event -> this.processMousePress((InputEvent.MouseButton.Pre)event));
        bus.addListener(event -> this.onMouseScroll((InputEvent.MouseScrollingEvent)event));
        bus.addListener(event -> this.tick((TickEvent.PlayerTickEvent)event));
    }

    @Nullable
    public static Pair<InteractionHand, ItemStack> getBuildingTool(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
            return Pair.of((Object)InteractionHand.MAIN_HAND, (Object)stack);
        }
        stack = player.m_21206_();
        if (stack.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
            return Pair.of((Object)InteractionHand.OFF_HAND, (Object)stack);
        }
        return null;
    }

    public BuildingToolItem(Item.Properties properties) {
        super(properties);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientInit());
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            return ImmutableMultimap.of((Object)((Attribute)ForgeMod.REACH_DISTANCE.get()), (Object)new AttributeModifier(REACH_UUID, "building_tool_reach", (double)(BuildingToolItem.getReachDistanceModifier(stack) + BuildingToolItem.getMode(stack).getReachDistance(stack)), AttributeModifier.Operation.ADDITION));
        }
        return ImmutableMultimap.of();
    }

    public boolean m_6777_(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processKeyPress(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        int action = event.getAction();
        if (action == 1 || action == 2) {
            Pair<InteractionHand, ItemStack> tool;
            if (mc.f_91074_ != null && (tool = BuildingToolItem.getBuildingTool((Player)mc.f_91074_)) != null) {
                InteractionHand hand = (InteractionHand)tool.getFirst();
                ItemStack stack = (ItemStack)tool.getSecond();
                this.processModdedKeyMapping(hand, stack, (InputEvent)event);
                return;
            }
            this.voidModdedKeyMapping();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processMousePress(InputEvent.MouseButton.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        int action = event.getAction();
        if (action == 1 || action == 2) {
            Pair<InteractionHand, ItemStack> tool;
            if (mc.f_91074_ != null && (tool = BuildingToolItem.getBuildingTool((Player)mc.f_91074_)) != null) {
                InteractionHand hand = (InteractionHand)tool.getFirst();
                ItemStack stack = (ItemStack)tool.getSecond();
                if (event.getButton() == mc.f_91066_.f_92097_.getKey().m_84873_() && mc.f_91080_ == null && this.hasPermission(stack, (Player)mc.f_91074_)) {
                    BlockPos hitPos;
                    HitResult hitResult = mc.f_91077_;
                    if (hitResult instanceof BlockHitResult) {
                        BlockHitResult blockHit = (BlockHitResult)hitResult;
                        v0 = blockHit.m_82425_();
                    } else {
                        v0 = hitPos = null;
                    }
                    if (hitPos != null) {
                        this.onMiddleClick(stack, (Player)mc.f_91074_, hitPos);
                        mc.f_91074_.m_6674_(hand);
                        PacketHandler.sendToServer(new MiddleClickBuildingToolPacket(hand, hitPos));
                        if (event.isCancelable()) {
                            event.setCanceled(true);
                        }
                    }
                }
                this.processModdedKeyMapping(hand, stack, (InputEvent)event);
                return;
            }
            this.voidModdedKeyMapping();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processModdedKeyMapping(InteractionHand hand, ItemStack stack, InputEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        while (((KeyMapping)ClientProxy.UNDO_KEY.get()).m_90859_()) {
            if (mc.f_91080_ != null || !this.hasPermission(stack, (Player)mc.f_91074_)) continue;
            PacketHandler.sendToServer(ActionHistoryPacket.undo(true));
        }
        while (((KeyMapping)ClientProxy.REDO_KEY.get()).m_90859_()) {
            if (mc.f_91080_ != null || !this.hasPermission(stack, (Player)mc.f_91074_)) continue;
            PacketHandler.sendToServer(ActionHistoryPacket.redo(true));
        }
        while (((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get()).m_90859_()) {
            if (!this.hasPermission(stack, (Player)mc.f_91074_)) continue;
            BuildingToolBounds.releaseGrabbedCorner(stack, (Player)mc.f_91074_);
            PacketHandler.sendToServer(ActionHistoryPacket.releaseGrabbedCorner(hand));
            StructureGelMod.proxy.openBuildingToolScreen(stack, hand);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void voidModdedKeyMapping() {
        while (((KeyMapping)ClientProxy.UNDO_KEY.get()).m_90859_()) {
        }
        while (((KeyMapping)ClientProxy.REDO_KEY.get()).m_90859_()) {
        }
        while (((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get()).m_90859_()) {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            int scrollDelta;
            Pair<InteractionHand, ItemStack> tool = BuildingToolItem.getBuildingTool((Player)mc.f_91074_);
            if (tool == null) {
                return;
            }
            InteractionHand hand = (InteractionHand)tool.getFirst();
            ItemStack stack = (ItemStack)tool.getSecond();
            if (mc.f_91080_ == null && mc.f_91066_.f_92091_.m_90857_() && this.hasPermission(stack, (Player)mc.f_91074_) && (scrollDelta = (int)event.getScrollDelta()) != 0) {
                if (BuildingToolItem.getSelectedCorner(stack) == null) {
                    int reach = BuildingToolItem.setReachDistanceModifier(stack, BuildingToolItem.getReachDistanceModifier(stack) + scrollDelta);
                    PacketHandler.sendToServer(UpdateBuildingToolPacket.builder().hand(hand).reachDistance(reach).build());
                    mc.f_91074_.m_5661_((Component)Component.m_237110_((String)"info.structure_gel.building_tool.message.set_reach", (Object[])new Object[]{reach}), true);
                } else {
                    float cornerDistance = BuildingToolItem.setSelectedCornerDistance(this.m_7968_(), BuildingToolItem.getSelectedCornerDistance(stack) + (float)scrollDelta);
                    PacketHandler.sendToServer(UpdateBuildingToolPacket.builder().hand(hand).cornerReachDistance(cornerDistance).build());
                    DecimalFormat formatter = new DecimalFormat("0.##");
                    mc.f_91074_.m_5661_((Component)Component.m_237110_((String)"info.structure_gel.building_tool.message.set_reach", (Object[])new Object[]{formatter.format(cornerDistance)}), true);
                }
                event.setCanceled(true);
            }
        }
    }

    public void tick(TickEvent.PlayerTickEvent event) {
        if (event.player != null && event.phase == TickEvent.Phase.START) {
            Pair<InteractionHand, ItemStack> tool = BuildingToolItem.getBuildingTool(event.player);
            if (tool == null) {
                return;
            }
            ItemStack stack = (ItemStack)tool.getSecond();
            if (BuildingToolBounds.tick(stack, event.player)) {
                return;
            }
        }
    }

    public boolean onRightClick(ItemStack stack, InteractionHand hand, Player player, BlockPos clickedPos, Direction clickedFace) {
        if (this.hasPermission(stack, player)) {
            BuildingToolMode mode = BuildingToolItem.getMode(stack);
            Level level = player.f_19853_;
            player.m_6674_(hand);
            if (BuildingToolBounds.handleBoundingBoxClick(stack, player)) {
                return true;
            }
            if (level.m_8055_(clickedPos).m_60795_()) {
                mode.onRightClickAir(level, player, clickedPos, stack);
            } else {
                mode.onRightClickBlock(level, player, clickedPos, stack, clickedFace);
            }
            return true;
        }
        return false;
    }

    private void onRightClickEvent(PlayerInteractEvent event, @Nullable BlockPos pos) {
        if (pos != null) {
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            if (player != null && player.f_19853_.f_46443_ && this.hasPermission(stack, player)) {
                Direction clickedFace = event.getFace();
                if (clickedFace == null) {
                    clickedFace = Direction.UP;
                }
                if (this.onRightClick(stack, event.getHand(), player, pos, clickedFace) && event.isCancelable()) {
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
                PacketHandler.sendToServer(new RightClickBuildingToolPacket(event.getHand(), pos, clickedFace));
            }
        }
    }

    public boolean onLeftClick(ItemStack stack, Player player, BlockPos clickedPos, Direction clickedFace) {
        if (this.hasPermission(stack, player) && (!player.f_20911_ || player.f_20913_ > 1)) {
            if (BuildingToolItem.getSelectedCorner(stack) != null) {
                return false;
            }
            BuildingToolItem.getMode(stack).onLeftClick(player.f_19853_, player, clickedPos, stack, clickedFace);
            return true;
        }
        return false;
    }

    private void onLeftClickEvent(PlayerInteractEvent event, @Nullable BlockPos pos) {
        if (pos != null) {
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            if (player != null && player.f_19853_.f_46443_ && this.hasPermission(stack, player)) {
                Direction clickedFace = event.getFace();
                if (clickedFace == null) {
                    clickedFace = Direction.UP;
                }
                if (this.onLeftClick(stack, player, pos, clickedFace) && event.isCancelable()) {
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
                PacketHandler.sendToServer(new LeftClickBuildingToolPacket(event.getHand(), pos, clickedFace));
            }
        }
    }

    public void onMiddleClick(ItemStack stack, Player player, BlockPos clickedPos) {
        if (clickedPos != null && this.hasPermission(stack, player)) {
            Level level = player.f_19853_;
            BuildingToolMode mode = BuildingToolItem.getMode(stack);
            if (level.m_8055_(clickedPos).m_60795_()) {
                mode.onMiddleClickAir(level, player, clickedPos, stack);
            } else {
                mode.onMiddleClickBlock(level, player, clickedPos, stack);
            }
        }
    }

    public Component m_7626_(ItemStack stack) {
        BuildingToolMode mode = BuildingToolItem.getMode(stack);
        Component name = super.m_7626_(stack);
        if (mode == BuildingToolModes.NONE) {
            return name;
        }
        return this.nameCache.apply(mode, name.getString());
    }

    private boolean hasPermission(ItemStack stack, Player player) {
        if (stack.m_150930_((Item)this)) {
            boolean hasPermission = player.m_7500_();
            if (!hasPermission && !player.m_5833_()) {
                player.m_5661_(NO_PERMISSION, true);
            }
            return hasPermission;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag showAdvanced) {
        BuildingToolMode mode = BuildingToolItem.getMode(stack);
        if (Screen.m_96638_()) {
            if (mode != BuildingToolModes.NONE) {
                list.add(SGText.applyKeybindFilter((Component)Component.m_237110_((String)mode.getDescKey(), (Object[])mode.getDescArgs())));
                list.add((Component)SGText.NEW_LINE);
                list.add((Component)SGText.BULLET_POINT.m_6881_().m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237115_((String)BLOCK_PALLETE_NAME).m_130948_(SGText.VALUE_LABEL_STYLE)).m_7220_((Component)Component.m_237113_((String)(": " + BuildingToolItem.getPalleteString(BuildingToolItem.getPallete(stack))))));
                for (ToolModeProperty<?> property : mode.getProperties().values()) {
                    list.add((Component)SGText.BULLET_POINT.m_6881_().m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)property.getNameComponent().getString()).m_130948_(SGText.VALUE_LABEL_STYLE)).m_7220_((Component)Component.m_237113_((String)(": " + property.getValueComponent(BuildingToolItem.getProperty(stack, property)).getString()))));
                }
                list.add((Component)SGText.NEW_LINE);
            } else {
                String buildingToolKey = SGText.keybindString((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get());
                list.add(SGText.applyKeybindFilter((Component)Component.m_237110_((String)"info.structure_gel.building_tool_description", (Object[])new Object[]{buildingToolKey})));
                list.add((Component)SGText.NEW_LINE);
            }
        } else if (Screen.m_96637_()) {
            Options options = Minecraft.m_91087_().f_91066_;
            String buildingToolKey = SGText.keybindString((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get());
            String middleClick = SGText.keybindString(options.f_92097_);
            String control = SGText.keybindString(options.f_92091_);
            String undo = SGText.keybindString((KeyMapping)ClientProxy.UNDO_KEY.get());
            String redo = SGText.keybindString((KeyMapping)ClientProxy.REDO_KEY.get());
            list.add(SGText.applyKeybindFilter((Component)Component.m_237110_((String)"item.structure_gel.building_tool.info.open_gui", (Object[])new Object[]{buildingToolKey})));
            list.add(SGText.applyKeybindFilter((Component)Component.m_237110_((String)"item.structure_gel.building_tool.info.select_block", (Object[])new Object[]{middleClick})));
            list.add(SGText.applyKeybindFilter((Component)Component.m_237110_((String)"item.structure_gel.building_tool.info.zoom_reach", (Object[])new Object[]{control})));
            list.add(SGText.applyKeybindFilter((Component)Component.m_237110_((String)"item.structure_gel.building_tool.info.undo_and_redo", (Object[])new Object[]{undo, redo})));
            list.add((Component)SGText.NEW_LINE);
        } else {
            list.add(SGText.applyKeybindFilter((Component)Component.m_237115_((String)"info.structure_gel.hold_shift")));
            list.add(SGText.applyKeybindFilter((Component)Component.m_237115_((String)"info.structure_gel.hold_control")));
        }
    }

    public static String getPalleteString(WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete) {
        List states = pallete.m_146338_().stream().sorted((o1, o2) -> Integer.compare(o2.m_142631_().m_146281_(), o1.m_142631_().m_146281_())).toList();
        if (states.isEmpty()) {
            states = SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50016_.m_49966_(), 1).m_146270_().m_146338_();
        }
        StringBuilder palleteStr = new StringBuilder();
        float totalWeight = WeightedRandom.m_146312_(states);
        for (WeightedEntry.Wrapper state : states) {
            int percent = Math.round((float)state.m_142631_().m_146281_() / totalWeight * 100.0f);
            palleteStr.append("\n   " + percent + "% " + ((BlockState)state.m_146310_()).m_60734_().m_49954_().getString());
        }
        return palleteStr.toString();
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (!other.m_41619_() && clickAction == ClickAction.SECONDARY) {
            BuildingToolItem.setPallete(stack, BuildingToolItem.readPalleteFrom(other));
            player.m_5496_(SoundEvents.f_12019_, 0.8f, 0.9f + player.m_9236_().m_213780_().m_188501_() * 0.2f);
            return true;
        }
        return false;
    }

    public static BuildingToolMode getMode(ItemStack stack) {
        BuildingToolMode mode;
        String modeS;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(MODE_KEY, 8) && ResourceLocation.m_135830_((String)(modeS = tag.m_128461_(MODE_KEY))) && (mode = BuildingToolModes.REGISTRY.get(new ResourceLocation(modeS))) != null) {
            return mode;
        }
        return BuildingToolModes.NONE;
    }

    public static void setMode(ItemStack stack, BuildingToolMode mode) {
        stack.m_41784_().m_128359_(MODE_KEY, mode.getName().toString());
        stack.m_41784_().m_128473_(PROPERTIES_KEY);
    }

    public static Optional<BlockPos> getPos(ItemStack stack, int index) {
        int[] coords;
        String indexKey;
        CompoundTag poses;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(POSES_KEY, 10) && (poses = tag.m_128469_(POSES_KEY)).m_128425_(indexKey = Integer.toString(index), 11) && (coords = poses.m_128465_(indexKey)).length == 3) {
            return Optional.of(new BlockPos(coords[0], coords[1], coords[2]));
        }
        return Optional.empty();
    }

    public static boolean hasCompleteSelection(ItemStack stack) {
        return BuildingToolItem.getPos(stack, 0).isPresent() && BuildingToolItem.getPos(stack, 1).isPresent();
    }

    public static boolean setPos(ItemStack stack, int index, Vec3i pos) {
        if (BuildingToolItem.getPos(stack, index).equals(Optional.of(pos))) {
            return false;
        }
        CompoundTag tag = stack.m_41784_();
        CompoundTag posesTag = tag.m_128469_(POSES_KEY);
        posesTag.m_128385_(Integer.toString(index), new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        tag.m_128365_(POSES_KEY, (Tag)posesTag);
        return true;
    }

    public static void clearPoses(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(POSES_KEY, 10)) {
            tag.m_128365_(POSES_KEY, (Tag)new CompoundTag());
        }
        BuildingToolItem.setSelectedCorner(stack, null);
    }

    public static WeightedRandomList<WeightedEntry.Wrapper<BlockState>> getPallete(ItemStack stack) {
        WeightedRandomList ret = WeightedRandomList.m_146332_();
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(PALLETE_KEY, 9)) {
            ListTag palleteTag = tag.m_128437_(PALLETE_KEY, 10);
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
            for (Tag t : palleteTag) {
                CompoundTag stateTag;
                if (!(t instanceof CompoundTag) || !(stateTag = (CompoundTag)t).m_128425_(STATE_KEY, 10) || !stateTag.m_128425_(WEIGHT_KEY, 3)) continue;
                try {
                    BlockState state = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)stateTag.m_128469_(STATE_KEY));
                    int weight = stateTag.m_128451_(WEIGHT_KEY);
                    builder.m_146271_((Object)state, weight);
                }
                catch (Exception e) {
                    StructureGelMod.LOGGER.error("Couldn't read block state from tag.", stateTag.m_7916_());
                }
            }
            ret = builder.m_146270_();
        }
        if (ret.m_146337_()) {
            ret = SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50016_.m_49966_(), 1).m_146270_();
        }
        return ret;
    }

    public static void setPallete(ItemStack stack, WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete) {
        ListTag palleteList = new ListTag();
        for (WeightedEntry.Wrapper state : pallete.m_146338_()) {
            CompoundTag stateTag = new CompoundTag();
            stateTag.m_128365_(STATE_KEY, (Tag)NbtUtils.m_129202_((BlockState)((BlockState)state.m_146310_())));
            stateTag.m_128405_(WEIGHT_KEY, state.m_142631_().m_146281_());
            palleteList.add((Object)stateTag);
        }
        stack.m_41784_().m_128365_(PALLETE_KEY, (Tag)palleteList);
    }

    public static WeightedRandomList<WeightedEntry.Wrapper<BlockState>> readPalleteFrom(Level level, BlockPos pos) {
        Container readFrom;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof Container && !(readFrom = (Container)blockEntity).m_7983_()) {
            HashMap<Item, Integer> stacks = new HashMap<Item, Integer>();
            int size = readFrom.m_6643_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = readFrom.m_8020_(i);
                int count = stack.m_41613_();
                stacks.compute(stack.m_41720_(), (item, c) -> c == null ? count : c + count);
            }
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete = BuildingToolItem.readPalleteFrom(stacks);
            if (!pallete.m_146337_()) {
                return pallete;
            }
        }
        return SimpleWeightedRandomList.m_146263_().m_146271_((Object)level.m_8055_(pos), 1).m_146270_();
    }

    public static WeightedRandomList<WeightedEntry.Wrapper<BlockState>> readPalleteFrom(ItemStack readFrom) {
        Optional<BlockState> opState;
        CompoundTag tag = BlockItem.m_186336_((ItemStack)readFrom);
        if (tag != null) {
            WeightedRandomList<WeightedEntry.Wrapper<BlockState>> pallete;
            HashMap<Item, Integer> stacks = new HashMap<Item, Integer>();
            if (tag.m_128425_("Items", 9)) {
                NonNullList contents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)contents);
                if (contents.isEmpty()) {
                    return BuildingToolItem.readPalleteFrom(Map.of(readFrom.m_41720_(), readFrom.m_41613_()));
                }
                for (ItemStack stack : contents) {
                    int count = stack.m_41613_();
                    stacks.compute(stack.m_41720_(), (i, c) -> c == null ? count : c + count);
                }
            }
            if (!(pallete = BuildingToolItem.readPalleteFrom(stacks)).m_146337_()) {
                return pallete;
            }
        }
        if ((opState = BuildingToolItem.getStateForItem(readFrom.m_41720_(), true)).isPresent()) {
            return SimpleWeightedRandomList.m_146263_().m_146271_((Object)opState.get(), 1).m_146270_();
        }
        return WeightedRandomList.m_146332_();
    }

    public static WeightedRandomList<WeightedEntry.Wrapper<BlockState>> readPalleteFrom(Map<Item, Integer> items) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        for (Map.Entry<Item, Integer> entry : items.entrySet()) {
            Optional<BlockState> opState = BuildingToolItem.getStateForItem(entry.getKey(), false);
            if (!opState.isPresent()) continue;
            builder.m_146271_((Object)opState.get(), entry.getValue().intValue());
        }
        return builder.m_146270_();
    }

    public static Optional<ItemStack> getItemForBlock(BlockState state) {
        ItemStack stack = null;
        Block block = state.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            stack = liquidBlock.getFluid().m_6859_().m_7968_();
        } else {
            stack = block.m_5456_().m_7968_();
        }
        if (stack.m_150930_(Items.f_41852_)) {
            stack = Items.f_42446_.m_7968_();
        }
        return Optional.ofNullable(stack);
    }

    public static Optional<BlockState> getStateForItem(Item item, boolean includeAir) {
        BlockState state = null;
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            state = blockItem.m_40614_().m_49966_();
        } else if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            state = bucket.getFluid().m_76145_().m_76188_();
        } else if (item instanceof SolidBucketItem) {
            SolidBucketItem solidBucket = (SolidBucketItem)item;
            state = solidBucket.m_40614_().m_49966_();
        } else if (includeAir) {
            state = Blocks.f_50016_.m_49966_();
        }
        return Optional.ofNullable(state);
    }

    public static void clearPallete(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(PALLETE_KEY, 9)) {
            tag.m_128473_(PALLETE_KEY);
        }
    }

    public static <T> T getProperty(ItemStack stack, ToolModeProperty<T> property) {
        String key;
        CompoundTag propertiesTag;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(PROPERTIES_KEY, 10) && (propertiesTag = tag.m_128469_(PROPERTIES_KEY)).m_128425_(key = property.getKey(), 8)) {
            return property.read(propertiesTag.m_128461_(key));
        }
        return property.getDefaultValue();
    }

    public static <T> void setProperty(ItemStack stack, ToolModeProperty<T> property, T value) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag propertiesTag = tag.m_128469_(PROPERTIES_KEY);
        propertiesTag.m_128359_(property.getKey(), property.write(value));
        tag.m_128365_(PROPERTIES_KEY, (Tag)propertiesTag);
    }

    public static int getReachDistanceModifier(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(REACH_DISTANCE_MODIFIER_KEY, 3)) {
            return tag.m_128451_(REACH_DISTANCE_MODIFIER_KEY);
        }
        return 0;
    }

    public static int setReachDistanceModifier(ItemStack stack, int reachDistanceModifier) {
        reachDistanceModifier = Mth.m_14045_((int)reachDistanceModifier, (int)ToolModeProperty.REACH_DISTANCE.min(), (int)ToolModeProperty.REACH_DISTANCE.max());
        stack.m_41784_().m_128405_(REACH_DISTANCE_MODIFIER_KEY, reachDistanceModifier);
        return reachDistanceModifier;
    }

    @Nullable
    public static SmartBoundingBox.CornerType getSelectedCorner(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(CORNER_KEY, 3)) {
            int cornerID = tag.m_128451_(CORNER_KEY);
            SmartBoundingBox.CornerType[] types = SmartBoundingBox.CornerType.values();
            if (cornerID > -1 && cornerID < types.length) {
                return types[cornerID];
            }
        }
        return null;
    }

    public static void setSelectedCorner(ItemStack stack, @Nullable SmartBoundingBox.CornerType cornerType) {
        stack.m_41784_().m_128405_(CORNER_KEY, cornerType == null ? -1 : cornerType.ordinal());
    }

    public static float getSelectedCornerDistance(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(CORNER_DIST_KEY, 5)) {
            return tag.m_128457_(CORNER_DIST_KEY);
        }
        return 3.0f;
    }

    public static float setSelectedCornerDistance(ItemStack stack, float cornerDistance) {
        cornerDistance = Mth.m_14036_((float)cornerDistance, (float)1.0f, (float)ToolModeProperty.REACH_DISTANCE.max().intValue());
        stack.m_41784_().m_128350_(CORNER_DIST_KEY, cornerDistance);
        return cornerDistance;
    }

    public static boolean isMovingBounds(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(MOVE_BOUNDS_KEY, 1)) {
            return tag.m_128471_(MOVE_BOUNDS_KEY);
        }
        return false;
    }

    public static void setMovingBounds(ItemStack stack, boolean moveBounds) {
        stack.m_41784_().m_128379_(MOVE_BOUNDS_KEY, moveBounds);
    }
}

