/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public record RightClickBuildingToolPacket(InteractionHand hand, @Nullable BlockPos pos, Direction clickedFace) {
    public static void encoder(RightClickBuildingToolPacket packet, FriendlyByteBuf buff) {
        buff.writeBoolean(packet.hand == InteractionHand.MAIN_HAND);
        buff.writeBoolean(packet.pos != null);
        if (packet.pos != null) {
            buff.m_130064_(packet.pos);
        }
        buff.m_130068_((Enum)packet.clickedFace);
    }

    public static RightClickBuildingToolPacket decoder(FriendlyByteBuf buff) {
        InteractionHand hand = buff.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        boolean isPosPresent = buff.readBoolean();
        BlockPos pos = isPosPresent ? buff.m_130135_() : null;
        Direction clickedFace = (Direction)buff.m_130066_(Direction.class);
        return new RightClickBuildingToolPacket(hand, pos, clickedFace);
    }

    public static void handler(RightClickBuildingToolPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (packet.pos == null) {
                return;
            }
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            ItemStack stack = sender.m_21120_(packet.hand);
            if (stack.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
                SGRegistry.Items.BUILDING_TOOL.get().onRightClick(stack, packet.hand, (Player)sender, packet.pos, packet.clickedFace);
            }
        });
        context.get().setPacketHandled(true);
    }
}

