/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.kambrik.ext.math;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0013\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0001\u001a\u0010\u0010\u0006\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00010\u0007\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\r*\u00020\u0001\u001a-\u0010\u000f\u001a\u00020\u0001*\u00020\u00012!\u0010\u0010\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\t0\u0011\u001a\u0015\u0010\u0015\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u0017\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0086\u0002\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0001\u001a\u0015\u0010\u0019\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\tH\u0086\u0002\u001a\u0015\u0010\u0019\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0086\u0002\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u0001\u001a\r\u0010\u001d\u001a\u00020\u0001*\u00020\u0001H\u0086\u0002\u00a8\u0006\u001e"}, d2={"max", "Lnet/minecraft/util/math/Vec3d;", "vecA", "vecB", "min", "abs", "average", "", "axisValue", "", "axis", "Lnet/minecraft/util/math/Direction$Axis;", "ceil", "Lnet/minecraft/util/math/Vec3i;", "floor", "map", "func", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "it", "minus", "other", "plus", "rounded", "times", "num", "toArray", "", "unaryMinus", "Kambrik"})
@SourceDebugExtension(value={"SMAP\nExtVec3d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtVec3d.kt\nio/ejekta/kambrik/ext/math/ExtVec3dKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n2661#2,7:92\n*S KotlinDebug\n*F\n+ 1 ExtVec3d.kt\nio/ejekta/kambrik/ext/math/ExtVec3dKt\n*L\n44#1:92,7\n*E\n"})
public final class ExtVec3dKt {
    @NotNull
    public static final Vec3 unaryMinus(@NotNull Vec3 $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        return new Vec3(-$this$unaryMinus.f_82479_, -$this$unaryMinus.f_82480_, -$this$unaryMinus.f_82481_);
    }

    @NotNull
    public static final Vec3 plus(@NotNull Vec3 $this$plus, @NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Vec3 vec3 = $this$plus.m_82549_(other);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"this.add(other)");
        return vec3;
    }

    @NotNull
    public static final Vec3 minus(@NotNull Vec3 $this$minus, @NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Vec3 vec3 = $this$minus.m_82546_(other);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"this.subtract(other)");
        return vec3;
    }

    @NotNull
    public static final Vec3 times(@NotNull Vec3 $this$times, @NotNull Vec3 other) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Vec3 vec3 = $this$times.m_82559_(other);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"this.multiply(other)");
        return vec3;
    }

    @NotNull
    public static final Vec3 times(@NotNull Vec3 $this$times, double num) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Vec3 vec3 = $this$times.m_82490_(num);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"multiply(num)");
        return vec3;
    }

    @NotNull
    public static final double[] toArray(@NotNull Vec3 $this$toArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toArray, (String)"<this>");
        double[] dArray = new double[]{$this$toArray.f_82479_, $this$toArray.f_82480_, $this$toArray.f_82481_};
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Vec3 average(@NotNull List<? extends Vec3> $this$average) {
        Intrinsics.checkNotNullParameter($this$average, (String)"<this>");
        if ($this$average.isEmpty()) {
            throw new Exception("Cannot average an empty list of Vec3d! Must contain at least one element!");
        }
        Iterable $this$reduce$iv = $this$average;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void b;
            Vec3 vec3 = (Vec3)iterator$iv.next();
            Vec3 a = (Vec3)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)a.m_82549_((Vec3)b), (String)"a.add(b)");
        }
        Vec3 summed = (Vec3)accumulator$iv;
        Vec3 vec3 = summed.m_82490_(1.0 / (double)$this$average.size());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"{\n        val summed = t\u2026ultiply(1.0 / size)\n    }");
        return vec3;
    }

    @NotNull
    public static final Vec3 max(@NotNull Vec3 vecA, @NotNull Vec3 vecB) {
        Intrinsics.checkNotNullParameter((Object)vecA, (String)"vecA");
        Intrinsics.checkNotNullParameter((Object)vecB, (String)"vecB");
        return new Vec3(Math.max(vecA.f_82479_, vecB.f_82479_), Math.max(vecA.f_82480_, vecB.f_82480_), Math.max(vecA.f_82481_, vecB.f_82481_));
    }

    @NotNull
    public static final Vec3 min(@NotNull Vec3 vecA, @NotNull Vec3 vecB) {
        Intrinsics.checkNotNullParameter((Object)vecA, (String)"vecA");
        Intrinsics.checkNotNullParameter((Object)vecB, (String)"vecB");
        return new Vec3(Math.min(vecA.f_82479_, vecB.f_82479_), Math.min(vecA.f_82480_, vecB.f_82480_), Math.min(vecA.f_82481_, vecB.f_82481_));
    }

    public static final double axisValue(@NotNull Vec3 $this$axisValue, @NotNull Direction.Axis axis) {
        Intrinsics.checkNotNullParameter((Object)$this$axisValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        return axis.m_6150_($this$axisValue.f_82479_, $this$axisValue.f_82480_, $this$axisValue.f_82481_);
    }

    @NotNull
    public static final Vec3 abs(@NotNull Vec3 $this$abs) {
        Intrinsics.checkNotNullParameter((Object)$this$abs, (String)"<this>");
        return new Vec3(Math.abs($this$abs.f_82479_), Math.abs($this$abs.f_82480_), Math.abs($this$abs.f_82481_));
    }

    @NotNull
    public static final Vec3i ceil(@NotNull Vec3 $this$ceil) {
        Intrinsics.checkNotNullParameter((Object)$this$ceil, (String)"<this>");
        return (Vec3i)new BlockPos((int)Math.ceil($this$ceil.f_82479_), (int)Math.ceil($this$ceil.f_82480_), (int)Math.ceil($this$ceil.f_82481_));
    }

    @NotNull
    public static final Vec3i floor(@NotNull Vec3 $this$floor) {
        Intrinsics.checkNotNullParameter((Object)$this$floor, (String)"<this>");
        return (Vec3i)new BlockPos((int)Math.floor($this$floor.f_82479_), (int)Math.floor($this$floor.f_82480_), (int)Math.floor($this$floor.f_82481_));
    }

    @NotNull
    public static final Vec3 map(@NotNull Vec3 $this$map, @NotNull Function1<? super Double, Double> func) {
        Intrinsics.checkNotNullParameter((Object)$this$map, (String)"<this>");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        return new Vec3(((Number)func.invoke((Object)$this$map.f_82479_)).doubleValue(), ((Number)func.invoke((Object)$this$map.f_82480_)).doubleValue(), ((Number)func.invoke((Object)$this$map.f_82481_)).doubleValue());
    }

    @NotNull
    public static final Vec3 rounded(@NotNull Vec3 $this$rounded) {
        Intrinsics.checkNotNullParameter((Object)$this$rounded, (String)"<this>");
        return new Vec3(Math.rint($this$rounded.f_82479_), Math.rint($this$rounded.f_82480_), Math.rint($this$rounded.f_82481_));
    }
}

