/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Arrays;
import java.util.Objects;
import net.darkhax.bookshelf.api.util.AttributeHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class ItemStackHelper {
    public static double getAttackDamage(ItemStack stack) {
        return ItemStackHelper.getAttackDamage(stack, MobType.f_21640_);
    }

    public static double getAttackDamage(ItemStack stack, Entity target) {
        MobType mobType;
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            mobType = living.m_6336_();
        } else {
            mobType = MobType.f_21640_;
        }
        return ItemStackHelper.getAttackDamage(stack, mobType);
    }

    public static double getAttackDamage(ItemStack stack, MobType targetType) {
        double damage = AttributeHelper.getAttackDamage(stack);
        double bonusEnchantmentDamage = EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)targetType);
        return damage + bonusEnchantmentDamage;
    }

    public static ItemStack[] getTabItems(CreativeModeTab tab) {
        return (ItemStack[])tab.m_260957_().toArray(ItemStack[]::new);
    }

    public static boolean areStacksEquivalent(ItemStack first, ItemStack second) {
        return first.m_41619_() == second.m_41619_() && first.m_41613_() == second.m_41613_() && Objects.equals(first.m_41783_(), second.m_41783_());
    }

    public static void setLore(ItemStack stack, Component ... lines) {
        CompoundTag displayTag = stack.m_41698_("display");
        ListTag loreList = new ListTag();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)line))));
        displayTag.m_128365_("Lore", (Tag)loreList);
    }

    public static void appendLore(ItemStack stack, Component ... lines) {
        CompoundTag displayTag = stack.m_41698_("display");
        ListTag loreList = displayTag.m_128441_("Lore") ? displayTag.m_128437_("Lore", 8) : new ListTag();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)line))));
        displayTag.m_128365_("Lore", (Tag)loreList);
    }
}

