/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.mixin.accessors.client.AccessorFontManager;
import net.darkhax.bookshelf.mixin.accessors.client.AccessorMinecraft;
import net.darkhax.bookshelf.mixin.accessors.entity.AccessorEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public final class TextHelper {
    public static final ResourceLocation FONT_ALT = new ResourceLocation("minecraft", "alt");
    public static final ResourceLocation FONT_DEFAULT = new ResourceLocation("minecraft", "default");
    public static final ResourceLocation FONT_ILLAGER = new ResourceLocation("minecraft", "illageralt");
    public static final ResourceLocation FONT_UNIFORM = new ResourceLocation("minecraft", "uniform");

    public static MutableComponent getFormatedTime(int ticks, boolean includeHover) {
        MutableComponent component = Component.m_237113_((String)StringUtil.m_14404_((int)ticks));
        if (includeHover) {
            component = TextHelper.setHover(component, (Component)Component.m_237110_((String)"text.bookshelf.ticks", (Object[])new Object[]{ticks}));
        }
        return component;
    }

    public static <T extends Component> T setHover(T component, Component hoverInfo) {
        return TextHelper.setHover(component, HoverEvent.Action.f_130831_, hoverInfo);
    }

    public static <T extends Component> T setHover(T component, ItemStack hoverInfo) {
        return TextHelper.setHover(component, HoverEvent.Action.f_130832_, new HoverEvent.ItemStackInfo(hoverInfo));
    }

    public static <T extends Component> T setHover(T component, Entity hoverInfo) {
        if (hoverInfo instanceof AccessorEntity) {
            AccessorEntity accessor = (AccessorEntity)hoverInfo;
            return TextHelper.setHover(component, accessor.bookshelf$createHoverEvent());
        }
        return TextHelper.setHover(component, HoverEvent.Action.f_130833_, new HoverEvent.EntityTooltipInfo(hoverInfo.m_6095_(), hoverInfo.m_20148_(), hoverInfo.m_7755_()));
    }

    public static <T extends Component, AT, A extends HoverEvent.Action<AT>> T setHover(T component, A action, AT arg) {
        return TextHelper.setHover(component, new HoverEvent(action, arg));
    }

    public static <T extends Component> T setHover(T component, HoverEvent hoverInfo) {
        if (component instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)component;
            mutable.m_130938_(style -> style.m_131144_(hoverInfo));
        }
        return component;
    }

    public static Component applyFont(Component text, ResourceLocation font) {
        if (text instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)text;
            mutable.m_130938_(style -> style.m_131150_(font));
        }
        text.m_7360_().forEach(sib -> TextHelper.applyFont(sib, font));
        return text;
    }

    public static Set<ResourceLocation> getRegisteredFonts() {
        if (!Services.PLATFORM.isPhysicalClient()) {
            return Collections.emptySet();
        }
        return ((AccessorFontManager)((AccessorMinecraft)Minecraft.m_91087_()).bookshelf$getFontManager()).bookshelf$getFonts().keySet();
    }

    @Nullable
    public static MutableComponent lookupTranslationWithAlias(ResourceLocation id, String ... keys) {
        for (String key : keys) {
            MutableComponent lookupResult = TextHelper.lookupTranslation(key.formatted(id.m_135827_(), id.m_135815_()), new Object[0]);
            if (lookupResult == null) continue;
            return lookupResult;
        }
        return null;
    }

    @Nullable
    public static MutableComponent lookupTranslationWithAlias(String[] keys, Object ... params) {
        for (String key : keys) {
            MutableComponent lookupResult = TextHelper.lookupTranslation(key, params);
            if (lookupResult == null) continue;
            return lookupResult;
        }
        return null;
    }

    @Nullable
    public static MutableComponent lookupTranslation(String key, Object ... args) {
        return TextHelper.lookupTranslation(key, (String s, Object[] o) -> null, args);
    }

    @Nullable
    public static MutableComponent lookupTranslation(String key, MutableComponent fallback, Object ... args) {
        return TextHelper.lookupTranslation(key, (String s, Object[] o) -> fallback, args);
    }

    @Nullable
    public static MutableComponent lookupTranslation(String key, BiFunction<String, Object[], MutableComponent> fallback, Object ... args) {
        if (I18n.m_118936_((String)key)) {
            return Component.m_237110_((String)key, (Object[])args);
        }
        return fallback != null ? fallback.apply(key, args) : null;
    }

    public static MutableComponent setCopyText(MutableComponent component, String copy) {
        return component.m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, copy)));
    }

    public static MutableComponent textWithCopy(String text) {
        return Component.m_237113_((String)text).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text)));
    }
}

