/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.datagen;

import com.mrcrayfish.goblintraders.datagen.GoblinLootTableProvider;
import com.mrcrayfish.goblintraders.datagen.GoblinTradeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="goblintraders", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGeneration.registerCommonProviders(event.includeServer(), event.getGenerator(), event.getLookupProvider());
    }

    private static void registerCommonProviders(boolean server, DataGenerator generator, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        PackOutput output = generator.getPackOutput();
        generator.addProvider(server, (DataProvider)new GoblinTradeProvider(output, lookupProvider));
        generator.addProvider(server, (DataProvider)new GoblinLootTableProvider(output));
    }
}

