/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mrcrayfish.goblintraders.trades.GoblinTrade;
import com.mrcrayfish.goblintraders.trades.TradeSerializer;
import com.mrcrayfish.goblintraders.trades.type.ITradeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class BasicTrade
implements ITradeType<GoblinTrade> {
    public static final Serializer SERIALIZER = new Serializer();
    private final ItemStack offerStack;
    private final ItemStack paymentStack;
    private final ItemStack secondaryPaymentStack;
    private final float priceMultiplier;
    private final int maxTrades;
    private final int experience;
    private final EnchantmentInstance[] enchantments;
    private final Collection<MobEffectInstance> mobEffects;

    public BasicTrade(ItemStack offerStack, ItemStack paymentStack, ItemStack secondaryPaymentStack, float priceMultiplier, int maxTrades, int experience, EnchantmentInstance[] enchantments, Collection<MobEffectInstance> mobEffects) {
        this.offerStack = offerStack;
        this.paymentStack = paymentStack;
        this.secondaryPaymentStack = secondaryPaymentStack;
        this.priceMultiplier = priceMultiplier;
        this.maxTrades = maxTrades;
        this.experience = experience;
        this.enchantments = enchantments;
        this.mobEffects = mobEffects;
    }

    @Override
    public GoblinTrade createVillagerTrade() {
        ItemStack offerStack = this.offerStack.m_41777_();
        if (this.enchantments.length > 0) {
            if (offerStack.m_41720_() == Items.f_42690_) {
                EnchantmentHelper.m_44865_(Stream.of(this.enchantments).collect(Collectors.toMap(o -> o.f_44947_, e -> e.f_44948_)), (ItemStack)offerStack);
            } else {
                for (EnchantmentInstance data : this.enchantments) {
                    offerStack.m_41663_(data.f_44947_, data.f_44948_);
                }
            }
        }
        if (this.mobEffects.size() > 0) {
            PotionUtils.m_43552_((ItemStack)offerStack, this.mobEffects);
        }
        return new GoblinTrade(offerStack, this.paymentStack.m_41777_(), this.secondaryPaymentStack.m_41777_(), this.maxTrades, this.experience, this.priceMultiplier);
    }

    @Override
    public JsonObject serialize() {
        return SERIALIZER.serialize(this);
    }

    public static class Serializer
    extends TradeSerializer<BasicTrade> {
        Serializer() {
            super(new ResourceLocation("goblintraders", "basic"));
        }

        @Override
        public BasicTrade deserialize(JsonObject object) {
            Builder builder = Builder.create();
            builder.setOfferStack(CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)object, (String)"offer_item"), (boolean)true));
            builder.setPaymentStack(CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)object, (String)"payment_item"), (boolean)true));
            if (GsonHelper.m_13900_((JsonObject)object, (String)"secondary_payment_item")) {
                builder.setSecondaryPaymentStack(CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)object, (String)"secondary_payment_item"), (boolean)true));
            }
            builder.setPriceMultiplier(GsonHelper.m_13820_((JsonObject)object, (String)"price_multiplier", (float)0.05f));
            builder.setMaxTrades(GsonHelper.m_13824_((JsonObject)object, (String)"max_trades", (int)12));
            builder.setExperience(GsonHelper.m_13824_((JsonObject)object, (String)"experience", (int)0));
            if (GsonHelper.m_13900_((JsonObject)object, (String)"enchantments")) {
                Collection<EnchantmentInstance> enchantments = this.getEnchantments(GsonHelper.m_13933_((JsonObject)object, (String)"enchantments"));
                for (EnchantmentInstance enchantment : enchantments) {
                    builder.addEnchantment(enchantment);
                }
            }
            if (GsonHelper.m_13900_((JsonObject)object, (String)"potion_effects")) {
                Collection<MobEffectInstance> effects = this.getPotionEffects(GsonHelper.m_13933_((JsonObject)object, (String)"potion_effects"));
                for (MobEffectInstance effect : effects) {
                    builder.addPotionEffect(effect);
                }
            }
            return builder.build();
        }

        @Override
        public JsonObject serialize(BasicTrade trade) {
            JsonObject object = super.serialize(trade);
            object.add("offer_item", (JsonElement)this.serializeItemStack(trade.offerStack));
            object.add("payment_item", (JsonElement)this.serializeItemStack(trade.paymentStack));
            if (!trade.secondaryPaymentStack.m_41619_()) {
                object.add("secondary_payment_item", (JsonElement)this.serializeItemStack(trade.secondaryPaymentStack));
            }
            if (trade.priceMultiplier != 0.05f) {
                object.addProperty("price_multiplier", (Number)Float.valueOf(trade.priceMultiplier));
            }
            if (trade.maxTrades != 12) {
                object.addProperty("max_trades", (Number)trade.maxTrades);
            }
            if (trade.experience != 0) {
                object.addProperty("experience", (Number)trade.experience);
            }
            if (trade.enchantments.length > 0) {
                JsonArray enchantmentArray = new JsonArray();
                for (EnchantmentInstance enchantment : trade.enchantments) {
                    enchantmentArray.add((JsonElement)this.serializeEnchantment(enchantment));
                }
                object.add("enchantments", (JsonElement)enchantmentArray);
            }
            if (trade.mobEffects.size() > 0) {
                JsonArray effectArray = new JsonArray();
                for (MobEffectInstance effect : trade.mobEffects) {
                    effectArray.add((JsonElement)this.serializePotionEffect(effect));
                }
                object.add("potion_effects", (JsonElement)effectArray);
            }
            return object;
        }

        private JsonObject serializeItemStack(ItemStack stack) {
            JsonObject object = new JsonObject();
            object.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_())).toString());
            object.addProperty("count", (Number)stack.m_41613_());
            if (stack.m_41782_()) {
                object.addProperty("nbt", Objects.requireNonNull(stack.m_41783_()).toString());
            }
            return object;
        }

        private JsonObject serializeEnchantment(EnchantmentInstance enchantment) {
            JsonObject object = new JsonObject();
            object.addProperty("id", Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantment.f_44947_)).toString());
            object.addProperty("level", (Number)enchantment.f_44948_);
            return object;
        }

        private JsonObject serializePotionEffect(MobEffectInstance effect) {
            JsonObject object = new JsonObject();
            object.addProperty("id", Objects.requireNonNull(ForgeRegistries.MOB_EFFECTS.getKey((Object)effect.m_19544_())).toString());
            object.addProperty("duration", (Number)effect.m_19557_());
            object.addProperty("amplifier", (Number)effect.m_19564_());
            object.addProperty("show_particles", Boolean.valueOf(effect.m_19572_()));
            return object;
        }

        private Collection<EnchantmentInstance> getEnchantments(JsonArray enchantmentArray) {
            ArrayList<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>();
            for (JsonElement enchantmentElement : enchantmentArray) {
                JsonObject enchantmentObject = enchantmentElement.getAsJsonObject();
                String id = GsonHelper.m_13906_((JsonObject)enchantmentObject, (String)"id");
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(id));
                if (enchantment == null) continue;
                int level = GsonHelper.m_13824_((JsonObject)enchantmentObject, (String)"level", (int)1);
                enchantments.add(new EnchantmentInstance(enchantment, level));
            }
            return enchantments;
        }

        private Collection<MobEffectInstance> getPotionEffects(JsonArray effectsArray) {
            ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
            for (JsonElement effectElement : effectsArray) {
                JsonObject effectObject = effectElement.getAsJsonObject();
                String id = GsonHelper.m_13906_((JsonObject)effectObject, (String)"id");
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(id));
                if (effect == null) continue;
                int duration = GsonHelper.m_13824_((JsonObject)effectObject, (String)"duration", (int)1);
                int amplifier = GsonHelper.m_13824_((JsonObject)effectObject, (String)"amplifier", (int)1);
                boolean showParticles = GsonHelper.m_13855_((JsonObject)effectObject, (String)"show_particles", (boolean)true);
                effects.add(new MobEffectInstance(effect, duration, amplifier, false, showParticles));
            }
            return effects;
        }
    }

    public static class Builder {
        private ItemStack offerStack;
        private ItemStack paymentStack;
        private ItemStack secondaryPaymentStack = ItemStack.f_41583_;
        private float priceMultiplier = 0.0f;
        private int maxTrades = 12;
        private int experience = 10;
        private List<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>();
        private List<MobEffectInstance> modEffects = new ArrayList<MobEffectInstance>();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public BasicTrade build() {
            return new BasicTrade(this.offerStack, this.paymentStack, this.secondaryPaymentStack, this.priceMultiplier, this.maxTrades, this.experience, this.enchantments.toArray(new EnchantmentInstance[0]), this.modEffects);
        }

        public Builder setOfferStack(ItemStack offerStack) {
            this.offerStack = offerStack;
            return this;
        }

        public Builder setPaymentStack(ItemStack paymentStack) {
            this.paymentStack = paymentStack;
            return this;
        }

        public Builder setSecondaryPaymentStack(ItemStack secondaryPaymentStack) {
            this.secondaryPaymentStack = secondaryPaymentStack;
            return this;
        }

        public Builder setPriceMultiplier(float priceMultiplier) {
            this.priceMultiplier = priceMultiplier;
            return this;
        }

        public Builder setMaxTrades(int maxTrades) {
            this.maxTrades = maxTrades;
            return this;
        }

        public Builder setExperience(int experience) {
            this.experience = experience;
            return this;
        }

        public Builder addEnchantment(EnchantmentInstance enchantment) {
            this.enchantments.add(enchantment);
            return this;
        }

        public Builder addPotionEffect(MobEffectInstance effect) {
            this.modEffects.add(effect);
            return this;
        }
    }
}

