/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.entities;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.CachedMap;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.entities.DummyPlayer;
import de.maxhenkel.corpse.entities.DummySkeleton;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class CorpseRenderer
extends EntityRenderer<CorpseEntity> {
    private final CachedMap<CorpseEntity, DummyPlayer> players = new CachedMap(10000L);
    private final CachedMap<CorpseEntity, DummySkeleton> skeletons = new CachedMap(10000L);
    private static final Minecraft MC = Minecraft.m_91087_();

    public CorpseRenderer(EntityRendererProvider.Context renderer) {
        super(renderer);
    }

    public ResourceLocation getTextureLocation(CorpseEntity entity) {
        return null;
    }

    public void render(CorpseEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLightIn) {
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLightIn);
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-entity.m_146908_()));
        if (((Boolean)Main.SERVER_CONFIG.spawnCorpseOnFace.get()).booleanValue()) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            matrixStack.m_85837_(0.0, -1.0, -0.125625);
        } else {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            matrixStack.m_85837_(0.0, -1.0, 0.125625);
        }
        if (entity.isSkeleton()) {
            DummySkeleton skeleton = this.skeletons.get(entity, () -> new DummySkeleton(entity.f_19853_, entity.getEquipment()));
            this.getRenderer(skeleton).m_7392_((Entity)skeleton, entityYaw, 1.0f, matrixStack, buffer, packedLightIn);
        } else {
            AbstractClientPlayer abstractClientPlayerEntity = (AbstractClientPlayer)this.players.get(entity, () -> new DummyPlayer((ClientLevel)entity.f_19853_, new GameProfile(entity.getCorpseUUID().orElse(new UUID(0L, 0L)), entity.getCorpseName()), entity.getEquipment(), entity.getCorpseModel()));
            this.getRenderer(abstractClientPlayerEntity).m_7392_((Entity)abstractClientPlayerEntity, 0.0f, 1.0f, matrixStack, buffer, packedLightIn);
        }
        matrixStack.m_85849_();
    }

    private <T extends Entity> EntityRenderer<? super T> getRenderer(T entity) {
        return MC.m_91290_().m_114382_(entity);
    }
}

