/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.integration.waila;

import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.entities.CorpseEntity;
import de.maxhenkel.corpse.gui.DeathHistoryScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class HUDHandlerCorpse
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    public static final ResourceLocation OBJECT_NAME_TAG = new ResourceLocation("jade", "object_name");
    public static final HUDHandlerCorpse INSTANCE = new HUDHandlerCorpse();
    private static final ResourceLocation UID = new ResourceLocation("corpse", "corpse");

    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof CorpseEntity) {
            Death death;
            long timestamp;
            CorpseEntity corpse = (CorpseEntity)entity;
            iTooltip.remove(OBJECT_NAME_TAG);
            iTooltip.add((Component)corpse.m_5446_().m_6881_().m_130940_(ChatFormatting.WHITE));
            CompoundTag data = entityAccessor.getServerData();
            if (data.m_128441_("Death") && (timestamp = (death = Death.fromNBT(data.m_128469_("Death"))).getTimestamp()) > 0L) {
                iTooltip.add((Component)Component.m_237110_((String)"tooltip.corpse.death_date", (Object[])new Object[]{DeathHistoryScreen.getDate(timestamp)}));
            }
            if (data.m_128441_("ItemCount")) {
                iTooltip.add((Component)Component.m_237110_((String)"tooltip.corpse.item_count", (Object[])new Object[]{data.m_128451_("ItemCount")}));
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, ServerPlayer serverPlayer, Level level, Entity entity, boolean b) {
        if (entity instanceof CorpseEntity) {
            CorpseEntity corpse = (CorpseEntity)entity;
            Death death = corpse.getDeath();
            compoundTag.m_128365_("Death", (Tag)death.toNBT(false));
            compoundTag.m_128405_("ItemCount", (int)death.getAllItems().stream().filter(itemStack -> !itemStack.m_41619_()).count());
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }
}

