/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.piece;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.PlacementConfiguration;
import xiroc.dungeoncrawl.dungeon.model.ModelSelector;
import xiroc.dungeoncrawl.dungeon.piece.DungeonPiece;
import xiroc.dungeoncrawl.init.ModStructurePieceTypes;

public class DungeonNodeConnector
extends DungeonPiece {
    public DungeonNodeConnector() {
        super(ModStructurePieceTypes.NODE_CONNECTOR);
    }

    public DungeonNodeConnector(CompoundTag nbt) {
        super(ModStructurePieceTypes.NODE_CONNECTOR, nbt);
    }

    public void m_213694_(WorldGenLevel worldIn, StructureManager p_230383_2_, ChunkGenerator p_230383_3_, RandomSource randomIn, BoundingBox structureBoundingBoxIn, ChunkPos p_230383_6_, BlockPos p_230383_7_) {
        if (this.model == null) {
            DungeonCrawl.LOGGER.warn("Missing model for {}", (Object)this);
            return;
        }
        BlockPos pos = new BlockPos(this.x, this.y + this.model.getOffset(this.f_73379_).m_123342_(), this.z);
        this.buildModel(this.model, (LevelAccessor)worldIn, structureBoundingBoxIn, pos, randomIn, PlacementConfiguration.CORRIDOR, this.theme, this.secondaryTheme, this.stage, this.f_73379_, false, false);
        this.placeFeatures((LevelAccessor)worldIn, structureBoundingBoxIn, this.theme, this.secondaryTheme, randomIn, this.stage);
        this.decorate((LevelAccessor)worldIn, pos, this.theme, randomIn, structureBoundingBoxIn, this.f_73383_, this.model);
    }

    @Override
    public int getDungeonPieceType() {
        return 11;
    }

    @Override
    public void setupModel(DungeonBuilder builder, ModelSelector modelSelector, List<DungeonPiece> pieces, RandomSource rand) {
        this.model = modelSelector.nodeConnectors.roll(rand);
    }

    @Override
    protected boolean hasPillarAt(BlockPos pos) {
        if (this.f_73379_ == Rotation.NONE || this.f_73379_ == Rotation.CLOCKWISE_180) {
            return pos.m_123341_() % 6 == 0 && pos.m_123343_() % 3 == 0;
        }
        return pos.m_123341_() % 3 == 0 && pos.m_123343_() % 6 == 0;
    }

    public void adjustPositionAndBounds() {
        if (this.model == null) {
            return;
        }
        if (this.f_73379_ == Rotation.NONE || this.f_73379_ == Rotation.CLOCKWISE_180) {
            int minZ = this.z - (this.model.length - 3) / 2;
            this.f_73383_ = new BoundingBox(this.x, this.y, minZ, this.x + 4, this.y + this.model.height - 1, minZ + this.model.length - 1);
        } else {
            int minX = this.x - (this.model.length - 3) / 2;
            this.f_73383_ = new BoundingBox(minX, this.y, this.z, minX + this.model.length - 1, this.y + this.model.height - 1, this.z + 4);
        }
        this.setWorldPosition(this.f_73383_.m_162395_(), this.f_73383_.m_162396_(), this.f_73383_.m_162398_());
    }

    @Override
    public void createBoundingBox() {
        if (this.model != null) {
            this.f_73383_ = this.model.createBoundingBoxWithOffset(this.x, this.y, this.z, this.f_73379_);
        }
    }
}

