/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.client.render.model.CreativeBlockModel;
import team.creative.creativecore.client.render.model.CreativeItemModel;
import team.creative.creativecore.client.render.model.CreativeModelLoader;
import team.creative.creativecore.common.config.gui.ConfigGuiLayer;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.gui.IScaleableGuiScreen;
import team.creative.creativecore.common.gui.integration.ContainerIntegration;
import team.creative.creativecore.common.gui.integration.ContainerScreenIntegration;
import team.creative.creativecore.common.gui.integration.GuiEventHandler;
import team.creative.creativecore.common.gui.integration.GuiScreenIntegration;
import team.creative.creativecore.common.gui.style.GuiStyle;
import team.creative.creativecore.common.util.registry.LocatedHandlerRegistry;

public class CreativeCoreClient {
    private static Minecraft mc = Minecraft.m_91087_();
    public static final LocatedHandlerRegistry<CreativeBlockModel> BLOCK_MODEL_TYPES = new LocatedHandlerRegistry<Object>(null);
    public static final LocatedHandlerRegistry<CreativeItemModel> ITEM_MODEL_TYPES = new LocatedHandlerRegistry<Object>(null);
    private static final ItemColor ITEM_COLOR = (stack, tint) -> tint;

    public static void load(IEventBus bus) {
        bus.addListener(CreativeCoreClient::init);
        bus.addListener(CreativeCoreClient::modelEvent);
    }

    public static void registerClientConfig(String modid) {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((a, b) -> {
            ICreativeConfigHolder holder = CreativeConfigRegistry.ROOT.followPath(modid);
            if (holder != null && !holder.isEmpty(Side.CLIENT)) {
                return new GuiScreenIntegration(new ConfigGuiLayer(holder, Side.CLIENT));
            }
            return null;
        }));
    }

    public static void registerBlockModel(ResourceLocation location, CreativeBlockModel renderer) {
        BLOCK_MODEL_TYPES.register(location, renderer);
    }

    public static void registerItemModel(ResourceLocation location, CreativeItemModel renderer) {
        ITEM_MODEL_TYPES.register(location, renderer);
    }

    public static void registerItemColor(ItemColors colors, Item item) {
        colors.m_92689_(ITEM_COLOR, new ItemLike[]{item});
    }

    public static float getFrameTime() {
        if (mc.m_91104_()) {
            return 1.0f;
        }
        return mc.m_91296_();
    }

    @SubscribeEvent
    public static void commands(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"cmdclientconfig").executes(x -> {
            try {
                GuiEventHandler.queueScreen(new GuiScreenIntegration(new ConfigGuiLayer(CreativeConfigRegistry.ROOT, Side.CLIENT)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 1;
        }));
    }

    public static void init(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(CreativeCoreClient.class);
        MinecraftForge.EVENT_BUS.register(GuiEventHandler.class);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        GuiStyle.reload();
        Minecraft minecraft = Minecraft.m_91087_();
        ReloadableResourceManager reloadableResourceManager = (ReloadableResourceManager)minecraft.m_91098_();
        reloadableResourceManager.m_7217_((PreparableReloadListener)new SimplePreparableReloadListener(){

            protected Object m_5944_(ResourceManager p_10796_, ProfilerFiller p_10797_) {
                return GuiStyle.class;
            }

            protected void m_5787_(Object p_10793_, ResourceManager p_10794_, ProfilerFiller p_10795_) {
                GuiStyle.reload();
            }
        });
        MenuScreens.m_96206_(CreativeCore.GUI_CONTAINER, (MenuScreens.ScreenConstructor)new MenuScreens.ScreenConstructor<ContainerIntegration, ContainerScreenIntegration>(){

            public ContainerScreenIntegration create(ContainerIntegration container, Inventory inventory, Component p_create_3_) {
                return new ContainerScreenIntegration(container, inventory);
            }
        });
    }

    public static void modelEvent(ModelEvent.RegisterGeometryLoaders event) {
        event.register("rendered", (IGeometryLoader)new CreativeModelLoader());
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        Screen screen;
        if (event.phase == TickEvent.Phase.START && (screen = Minecraft.m_91087_().f_91080_) instanceof IScaleableGuiScreen) {
            IScaleableGuiScreen gui = (IScaleableGuiScreen)screen;
            gui.clientTick();
        }
    }
}

