/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.converation;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.converation.ConfigTypeArray;
import team.creative.creativecore.common.config.converation.ConfigTypeList;
import team.creative.creativecore.common.config.converation.ConfigTypeNamedList;
import team.creative.creativecore.common.config.converation.ConfigTypePermission;
import team.creative.creativecore.common.config.gui.IGuiConfigParent;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.ConfigHolderObject;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.config.holder.ICreativeConfigHolder;
import team.creative.creativecore.common.config.premade.MobEffectConfig;
import team.creative.creativecore.common.config.premade.NamedList;
import team.creative.creativecore.common.config.premade.Permission;
import team.creative.creativecore.common.config.premade.RegistryObjectConfig;
import team.creative.creativecore.common.config.premade.SelectableConfig;
import team.creative.creativecore.common.config.premade.SoundConfig;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBox;
import team.creative.creativecore.common.gui.controls.collection.GuiComboBoxMapped;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButton;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.text.TextListBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

public abstract class ConfigTypeConveration<T> {
    private static final NumberFormat numberFormat = ConfigTypeConveration.createFormat();
    private static HashMap<Class, Supplier> typeCreators = new HashMap();
    private static HashMap<Class, ConfigTypeConveration> types = new HashMap();
    private static PairList<Predicate<Class>, ConfigTypeConveration> specialTypes = new PairList();
    public static final ICreativeConfigHolder fakeParent = new ICreativeConfigHolder(){

        @Override
        public ConfigSynchronization synchronization() {
            return ConfigSynchronization.UNIVERSAL;
        }

        @Override
        public JsonObject save(boolean saveDefault, boolean ignoreRestart, Side side) {
            return null;
        }

        @Override
        public void restoreDefault(Side side, boolean ignoreRestart) {
        }

        @Override
        public String[] path() {
            return new String[0];
        }

        @Override
        public ICreativeConfigHolder parent() {
            return null;
        }

        @Override
        public Collection<String> names() {
            return null;
        }

        @Override
        public void load(boolean loadDefault, boolean ignoreRestart, JsonObject json, Side side) {
        }

        @Override
        public boolean isEmptyWithoutForce(Side side) {
            return false;
        }

        @Override
        public boolean isEmpty(Side side) {
            return false;
        }

        @Override
        public boolean isDefault(Side side) {
            return false;
        }

        @Override
        public ConfigKey getField(String key) {
            return null;
        }

        @Override
        public Object get(String key) {
            return null;
        }

        @Override
        public Collection<? extends ConfigKey> fields() {
            return null;
        }

        @Override
        public void configured(Side side) {
        }
    };
    public static ConfigTypeConveration<ConfigHolderObject> holderConveration;

    private static NumberFormat createFormat() {
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        format.setMaximumFractionDigits(Integer.MAX_VALUE);
        format.setGroupingUsed(false);
        return format;
    }

    public static <T, U extends T> void registerTypeCreator(Class<U> clazz, Supplier<T> type) {
        typeCreators.put(clazz, type);
    }

    public static <T, U extends T> ConfigTypeConveration<T> registerType(Class<U> clazz, ConfigTypeConveration<T> type) {
        types.put(clazz, type);
        return type;
    }

    public static void registerSpecialType(Predicate<Class> predicate, ConfigTypeConveration type) {
        specialTypes.add(predicate, type);
    }

    public static boolean has(Class typeClass) {
        if (types.containsKey(typeClass)) {
            return true;
        }
        if (typeClass.isAnnotationPresent(CreativeConfig.class)) {
            return false;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return true;
        }
        return false;
    }

    public static ConfigTypeConveration get(Class typeClass) {
        ConfigTypeConveration converation = types.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).value;
        }
        throw new RuntimeException("Could not find converation for " + typeClass.getName());
    }

    public static ConfigTypeConveration getUnsafe(Class typeClass) {
        ConfigTypeConveration converation = types.get(typeClass);
        if (converation != null) {
            return converation;
        }
        for (int i = 0; i < specialTypes.size(); ++i) {
            if (!((Predicate)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).key).test(typeClass)) continue;
            return (ConfigTypeConveration)((Pair)ConfigTypeConveration.specialTypes.get((int)i)).value;
        }
        return null;
    }

    public static Object read(Class typeClass, Object defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
        return ConfigTypeConveration.get(typeClass).readElement(defaultValue, loadDefault, ignoreRestart, element, side, key);
    }

    public static JsonElement write(Class typeClass, Object value, Object defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
        return ConfigTypeConveration.get(typeClass).writeElement(value, defaultValue, saveDefault, ignoreRestart, side, key);
    }

    public static Object createObject(Class clazz) {
        Supplier supplier = typeCreators.get(clazz);
        if (supplier != null) {
            return supplier.get();
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return null;
        }
    }

    public abstract T readElement(T var1, boolean var2, boolean var3, JsonElement var4, Side var5, @Nullable ConfigKey.ConfigKeyField var6);

    public abstract JsonElement writeElement(T var1, T var2, boolean var3, boolean var4, Side var5, @Nullable ConfigKey.ConfigKeyField var6);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void createControls(GuiParent var1, IGuiConfigParent var2, @Nullable ConfigKey.ConfigKeyField var3, Class var4);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void loadValue(T var1, GuiParent var2, IGuiConfigParent var3, @Nullable ConfigKey.ConfigKeyField var4);

    @OnlyIn(value=Dist.CLIENT)
    public void restoreDefault(T value, GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key) {
        this.loadValue(value, parent, configParent, key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldSave(T value, GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key) {
        return !key.get().equals(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract T saveValue(GuiParent var1, IGuiConfigParent var2, Class var3, @Nullable ConfigKey.ConfigKeyField var4);

    public abstract T set(ConfigKey.ConfigKeyField var1, T var2);

    @OnlyIn(value=Dist.CLIENT)
    public T save(GuiParent parent, IGuiConfigParent configParent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
        T value = this.saveValue(parent, configParent, clazz, key);
        if (value != null && key != null) {
            return this.set(key, value);
        }
        return value;
    }

    public boolean areEqual(T one, T two, @Nullable ConfigKey.ConfigKeyField key) {
        return one.equals(two);
    }

    public static Object parseObject(ICreativeConfigHolder parent, ConfigSynchronization synchronization, String key, Object object) {
        if (ConfigTypeConveration.has(object.getClass())) {
            return object;
        }
        return new ConfigHolderObject(parent, synchronization, key, object);
    }

    static {
        SimpleConfigTypeConveration<Boolean> booleanType = new SimpleConfigTypeConveration<Boolean>(){

            @Override
            public Boolean readElement(Boolean defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isBoolean()) {
                    return element.getAsBoolean();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Boolean value, Boolean defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz) {
                parent.add(new GuiStateButton("data", 0, ChatFormatting.RED + "false", ChatFormatting.GREEN + "true").setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(Boolean value, GuiParent parent) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                button.setState(value != false ? 1 : 0);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected Boolean saveValue(GuiParent parent, Class clazz) {
                GuiStateButton button = (GuiStateButton)parent.get("data");
                return button.getState() == 1;
            }

            @Override
            public Boolean set(ConfigKey.ConfigKeyField key, Boolean value) {
                return value;
            }
        };
        ConfigTypeConveration.registerType(Boolean.TYPE, booleanType);
        ConfigTypeConveration.registerType(Boolean.class, booleanType);
        ConfigTypeConveration.registerTypeCreator(Boolean.TYPE, () -> false);
        ConfigTypeConveration.registerTypeCreator(Boolean.class, () -> Boolean.FALSE);
        SimpleConfigTypeConveration<Number> numberType = new SimpleConfigTypeConveration<Number>(){

            @Override
            public Number readElement(Number defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    Class<?> clazz = defaultValue.getClass();
                    if (clazz == Float.class || clazz == Float.TYPE) {
                        return Float.valueOf(element.getAsFloat());
                    }
                    if (clazz == Double.class || clazz == Double.TYPE) {
                        return element.getAsDouble();
                    }
                    if (clazz == Byte.class || clazz == Byte.TYPE) {
                        return element.getAsByte();
                    }
                    if (clazz == Short.class || clazz == Short.TYPE) {
                        return element.getAsShort();
                    }
                    if (clazz == Integer.class || clazz == Integer.TYPE) {
                        return element.getAsInt();
                    }
                    if (clazz == Long.class || clazz == Long.TYPE) {
                        return element.getAsLong();
                    }
                    return element.getAsNumber();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Number value, Number defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            public boolean isDecimal(Class clazz) {
                return clazz == Float.class || clazz == Float.TYPE || clazz == Double.class || clazz == Double.TYPE;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key, Class clazz) {
                boolean decimal = this.isDecimal(clazz);
                if (key != null) {
                    if (decimal) {
                        CreativeConfig.DecimalRange decRange = key.field.getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null && decRange.slider()) {
                            parent.add(new GuiSlider("data", decRange.min(), decRange.min(), decRange.max()).setExpandableX());
                            return;
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field.getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null && intRange.slider()) {
                            parent.add(new GuiSteppedSlider("data", intRange.min(), intRange.min(), intRange.max()).setExpandableX());
                            return;
                        }
                    }
                }
                GuiTextfield textfield = (GuiTextfield)new GuiTextfield("data").setDim(30, 8).setExpandableX();
                if (decimal) {
                    textfield.setFloatOnly();
                } else {
                    textfield.setNumbersIncludingNegativeOnly();
                }
                parent.add(textfield);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(Number value, GuiParent parent) {
                Object control = parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    button.setValue(value.intValue());
                } else if (control instanceof GuiSlider) {
                    GuiSlider button = (GuiSlider)control;
                    button.setValue(value.doubleValue());
                } else {
                    ((GuiTextfield)control).setText(numberFormat.format(value));
                }
            }

            public Number parseDecimal(Class clazz, double decimal) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    return Float.valueOf((float)decimal);
                }
                return decimal;
            }

            public Number parseInt(Class clazz, int number) {
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    return (byte)number;
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    return (short)number;
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    return (long)number;
                }
                return number;
            }

            public Number parseNumber(Class clazz, String text) {
                if (clazz == Float.class || clazz == Float.TYPE) {
                    try {
                        return Float.valueOf(Float.parseFloat(text));
                    }
                    catch (NumberFormatException e) {
                        return Float.valueOf(0.0f);
                    }
                }
                if (clazz == Double.class || clazz == Double.TYPE) {
                    try {
                        return Double.parseDouble(text);
                    }
                    catch (NumberFormatException e) {
                        return 0.0;
                    }
                }
                if (clazz == Byte.class || clazz == Byte.TYPE) {
                    try {
                        return Byte.parseByte(text);
                    }
                    catch (NumberFormatException e) {
                        return (byte)0;
                    }
                }
                if (clazz == Short.class || clazz == Short.TYPE) {
                    try {
                        return Short.parseShort(text);
                    }
                    catch (NumberFormatException e) {
                        return (short)0;
                    }
                }
                if (clazz == Integer.class || clazz == Integer.TYPE) {
                    try {
                        return Integer.parseInt(text);
                    }
                    catch (NumberFormatException e) {
                        return 0;
                    }
                }
                if (clazz == Long.class || clazz == Long.TYPE) {
                    try {
                        return Long.parseLong(text);
                    }
                    catch (NumberFormatException e) {
                        return 0L;
                    }
                }
                return 0;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected Number saveValue(GuiParent parent, Class clazz) {
                Object text;
                Object control = parent.get("data");
                if (control instanceof GuiSteppedSlider) {
                    GuiSteppedSlider button = (GuiSteppedSlider)control;
                    text = "" + (int)button.value;
                } else if (control instanceof GuiSlider) {
                    GuiSlider button = (GuiSlider)control;
                    text = "" + button.value;
                } else {
                    text = ((GuiTextfield)control).getText();
                }
                return this.parseNumber(clazz, (String)text);
            }

            @Override
            public Number set(ConfigKey.ConfigKeyField key, Number value) {
                Class clazz = key.getType();
                boolean decimal = this.isDecimal(clazz);
                if (key != null) {
                    if (decimal) {
                        CreativeConfig.DecimalRange decRange = key.field.getAnnotation(CreativeConfig.DecimalRange.class);
                        if (decRange != null) {
                            return this.parseDecimal(clazz, Mth.m_14008_((double)value.doubleValue(), (double)decRange.min(), (double)decRange.max()));
                        }
                    } else {
                        CreativeConfig.IntRange intRange = key.field.getAnnotation(CreativeConfig.IntRange.class);
                        if (intRange != null) {
                            return this.parseInt(clazz, Mth.m_14045_((int)value.intValue(), (int)intRange.min(), (int)intRange.max()));
                        }
                    }
                }
                return value;
            }
        };
        ConfigTypeConveration.registerType(Byte.TYPE, numberType);
        ConfigTypeConveration.registerType(Byte.class, numberType);
        ConfigTypeConveration.registerType(Short.TYPE, numberType);
        ConfigTypeConveration.registerType(Short.class, numberType);
        ConfigTypeConveration.registerType(Integer.TYPE, numberType);
        ConfigTypeConveration.registerType(Integer.class, numberType);
        ConfigTypeConveration.registerType(Long.TYPE, numberType);
        ConfigTypeConveration.registerType(Long.class, numberType);
        ConfigTypeConveration.registerType(Float.TYPE, numberType);
        ConfigTypeConveration.registerType(Float.class, numberType);
        ConfigTypeConveration.registerType(Double.TYPE, numberType);
        ConfigTypeConveration.registerType(Double.class, numberType);
        ConfigTypeConveration.registerTypeCreator(Byte.TYPE, () -> (byte)0);
        ConfigTypeConveration.registerTypeCreator(Byte.class, () -> (byte)0);
        ConfigTypeConveration.registerTypeCreator(Short.TYPE, () -> (short)0);
        ConfigTypeConveration.registerTypeCreator(Short.class, () -> (short)0);
        ConfigTypeConveration.registerTypeCreator(Integer.TYPE, () -> 0);
        ConfigTypeConveration.registerTypeCreator(Integer.class, () -> 0);
        ConfigTypeConveration.registerTypeCreator(Long.TYPE, () -> 0L);
        ConfigTypeConveration.registerTypeCreator(Long.class, () -> 0L);
        ConfigTypeConveration.registerTypeCreator(Float.TYPE, () -> Float.valueOf(0.0f));
        ConfigTypeConveration.registerTypeCreator(Float.class, () -> Float.valueOf(0.0f));
        ConfigTypeConveration.registerTypeCreator(Double.TYPE, () -> 0.0);
        ConfigTypeConveration.registerTypeCreator(Double.class, () -> 0.0);
        ConfigTypeConveration.registerType(String.class, new SimpleConfigTypeConveration<String>(){

            @Override
            public String readElement(String defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return element.getAsString();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(String value, String defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz) {
                parent.add(new GuiTextfield("data").setDim(30, 8).setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(String value, GuiParent parent) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                button.setText(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected String saveValue(GuiParent parent, Class clazz) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                return button.getText();
            }

            @Override
            public String set(ConfigKey.ConfigKeyField key, String value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(String.class, () -> "");
        ConfigTypeConveration.registerType(ResourceLocation.class, new SimpleConfigTypeConveration<ResourceLocation>(){

            @Override
            public ResourceLocation readElement(ResourceLocation defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return new ResourceLocation(element.getAsString());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ResourceLocation value, ResourceLocation defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.toString());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz) {
                parent.add(new GuiTextfield("data").setDim(30, 8).setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(ResourceLocation value, GuiParent parent) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                button.setText(value.toString());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ResourceLocation saveValue(GuiParent parent, Class clazz) {
                GuiTextfield button = (GuiTextfield)parent.get("data");
                return new ResourceLocation(button.getText());
            }

            @Override
            public ResourceLocation set(ConfigKey.ConfigKeyField key, ResourceLocation value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(ResourceLocation.class, () -> new ResourceLocation(""));
        ConfigTypeConveration.registerType(SoundConfig.class, new ConfigTypeConveration<SoundConfig>(){

            @Override
            public SoundConfig readElement(SoundConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    return new SoundConfig(new ResourceLocation(element.getAsJsonObject().get("sound").getAsString()), element.getAsJsonObject().get("volume").getAsFloat(), element.getAsJsonObject().get("pitch").getAsFloat());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(SoundConfig value, SoundConfig defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey.ConfigKeyField key) {
                JsonObject json = new JsonObject();
                json.addProperty("sound", value.event.toString());
                json.addProperty("volume", (Number)Float.valueOf(value.volume));
                json.addProperty("pitch", (Number)Float.valueOf(value.pitch));
                return json;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key, Class clazz) {
                parent.flow = GuiFlow.STACK_Y;
                parent.add(new GuiTextfield("search").setDim(30, 14).setExpandableX());
                parent.add(new GuiComboBoxMapped<ResourceLocation>("sound", new TextMapBuilder<ResourceLocation>().addComponent(BuiltInRegistries.f_256894_.m_6566_(), x -> {
                    if (x.m_135827_().equals("minecraft")) {
                        return Component.m_237113_((String)x.m_135815_());
                    }
                    return Component.m_237113_((String)x.toString());
                })));
                GuiParent hBox = new GuiParent(GuiFlow.STACK_X);
                hBox.add(new GuiLabel("volumeLabel").setTranslate("gui.volume"));
                hBox.add(new GuiSlider("volume", 1.0, 0.0, 1.0).setDim(40, 10));
                hBox.add(new GuiLabel("pitchLabel").setTranslate("gui.pitch"));
                hBox.add(new GuiSlider("pitch", 1.0, 0.5, 2.0).setDim(40, 10));
                parent.add(hBox);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(SoundConfig value, GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("sound");
                GuiSlider volume = (GuiSlider)parent.get("volume");
                GuiSlider pitch = (GuiSlider)parent.get("pitch");
                box.select(value.event);
                volume.setValue(value.volume);
                pitch.setValue(value.pitch);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected SoundConfig saveValue(GuiParent parent, IGuiConfigParent configParent, Class clazz, ConfigKey.ConfigKeyField key) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("sound");
                GuiSlider volume = (GuiSlider)parent.get("volume");
                GuiSlider pitch = (GuiSlider)parent.get("pitch");
                return new SoundConfig((ResourceLocation)box.getSelected(), (float)volume.value, (float)pitch.value);
            }

            @Override
            public SoundConfig set(ConfigKey.ConfigKeyField key, SoundConfig value) {
                return value;
            }
        });
        ConfigTypeConveration.registerTypeCreator(SoundConfig.class, () -> new SoundConfig(new ResourceLocation("missing")));
        ConfigTypeConveration.registerType(RegistryObjectConfig.class, new ConfigTypeConveration<RegistryObjectConfig>(){

            @Override
            public RegistryObjectConfig readElement(RegistryObjectConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey.ConfigKeyField key) {
                if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                    return new RegistryObjectConfig(defaultValue.registry, new ResourceLocation(element.getAsString()));
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(RegistryObjectConfig value, RegistryObjectConfig defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey.ConfigKeyField key) {
                return new JsonPrimitive(value.location.toString());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key, Class clazz) {
                RegistryObjectConfig value = (RegistryObjectConfig)key.getDefault();
                parent.add(new GuiComboBoxMapped<ResourceLocation>("sound", new TextMapBuilder<ResourceLocation>().addComponent(value.registry.m_6566_(), x -> {
                    if (x.m_135827_().equals("minecraft")) {
                        return Component.m_237113_((String)x.m_135815_());
                    }
                    return Component.m_237113_((String)x.toString());
                })));
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(RegistryObjectConfig value, GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key) {
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("sound");
                box.select(value.location);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected RegistryObjectConfig saveValue(GuiParent parent, IGuiConfigParent configParent, Class clazz, ConfigKey.ConfigKeyField key) {
                RegistryObjectConfig object = (RegistryObjectConfig)key.getDefault();
                GuiComboBoxMapped box = (GuiComboBoxMapped)parent.get("sound");
                return new RegistryObjectConfig(object.registry, (ResourceLocation)box.getSelected());
            }

            @Override
            public RegistryObjectConfig set(ConfigKey.ConfigKeyField key, RegistryObjectConfig value) {
                return value;
            }
        });
        ConfigTypeConveration.registerType(SelectableConfig.class, new ConfigTypeConveration<SelectableConfig>(){

            @Override
            public SelectableConfig readElement(SelectableConfig defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, ConfigKey.ConfigKeyField key) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isNumber()) {
                    defaultValue.select(element.getAsInt());
                } else {
                    defaultValue.reset();
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(SelectableConfig value, SelectableConfig defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, ConfigKey.ConfigKeyField key) {
                return new JsonPrimitive((Number)value.getSelected());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key, Class clazz) {
                SelectableConfig value = (SelectableConfig)key.get();
                configParent.setCustomData(value.getSelected());
                parent.add(new GuiComboBox("data", new TextListBuilder().add(value.getArray(), x -> x.toString())).setExpandableX());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(SelectableConfig value, GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                box.select(value.getSelected());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void restoreDefault(SelectableConfig value, GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key) {
                value.reset();
                this.loadValue(value, parent, configParent, key);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected SelectableConfig saveValue(GuiParent parent, IGuiConfigParent configParent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                SelectableConfig config = (SelectableConfig)key.get();
                GuiComboBox box = (GuiComboBox)parent.get("data");
                config.select(box.getIndex());
                return config;
            }

            @Override
            public SelectableConfig set(ConfigKey.ConfigKeyField key, SelectableConfig value) {
                return value;
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public boolean shouldSave(SelectableConfig value, GuiParent parent, IGuiConfigParent configParent, ConfigKey.ConfigKeyField key) {
                return value.getSelected() != ((Integer)configParent.getCustomData()).intValue();
            }
        });
        ConfigTypeConveration.registerType(NamedList.class, new ConfigTypeNamedList());
        ConfigTypeConveration.registerType(Permission.class, new ConfigTypePermission());
        ConfigTypeConveration.registerTypeCreator(MobEffectConfig.class, () -> new MobEffectConfig((Registry<MobEffect>)BuiltInRegistries.f_256974_, new ResourceLocation("minecraft", "slowness"), 2, 1));
        holderConveration = ConfigTypeConveration.registerType(ConfigHolderObject.class, new ConfigTypeConveration<ConfigHolderObject>(){

            @Override
            public ConfigHolderObject readElement(ConfigHolderObject defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    defaultValue.load(loadDefault, ignoreRestart, (JsonObject)element, side);
                } else {
                    defaultValue.restoreDefault(side, ignoreRestart);
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ConfigHolderObject value, ConfigHolderObject defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                return value.save(saveDefault, ignoreRestart, side);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key, Class clazz) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(ConfigHolderObject value, GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ConfigHolderObject saveValue(GuiParent parent, IGuiConfigParent configParent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                return null;
            }

            @Override
            public ConfigHolderObject set(ConfigKey.ConfigKeyField key, ConfigHolderObject value) {
                return null;
            }
        });
        ConfigTypeConveration.registerType(ConfigHolderDynamic.class, new ConfigTypeConveration<ConfigHolderDynamic>(){

            @Override
            public ConfigHolderDynamic readElement(ConfigHolderDynamic defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                if (element.isJsonObject()) {
                    defaultValue.load(loadDefault, ignoreRestart, (JsonObject)element, side);
                } else {
                    defaultValue.restoreDefault(side, ignoreRestart);
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(ConfigHolderDynamic value, ConfigHolderDynamic defaultValue, boolean saveDefault, boolean ignoreRestart, Side side, @Nullable ConfigKey.ConfigKeyField key) {
                return value.save(saveDefault, ignoreRestart, side);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key, Class clazz) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(ConfigHolderDynamic value, GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key) {
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected ConfigHolderDynamic saveValue(GuiParent parent, IGuiConfigParent configParent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
                return null;
            }

            @Override
            public ConfigHolderDynamic set(ConfigKey.ConfigKeyField key, ConfigHolderDynamic value) {
                return null;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> {
            if (x.isArray()) {
                if (ConfigTypeConveration.has(x.getComponentType())) {
                    return true;
                }
                throw new RuntimeException("Array with holders are not permitted");
            }
            return false;
        }, new ConfigTypeArray());
        ConfigTypeConveration.registerSpecialType(x -> x.isEnum(), new SimpleConfigTypeConveration<Enum>(){

            @Override
            public Enum readElement(Enum defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    return Enum.valueOf(defaultValue.getDeclaringClass(), element.getAsString());
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(Enum value, Enum defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.name());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz) {
                parent.add(new GuiComboBox("data", new TextListBuilder().add(clazz.getEnumConstants(), x -> ((Enum)x).name())));
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(Enum value, GuiParent parent) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                box.select(value.ordinal());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected Enum saveValue(GuiParent parent, Class clazz) {
                GuiComboBox box = (GuiComboBox)parent.get("data");
                return (Enum)clazz.getEnumConstants()[box.getIndex()];
            }

            @Override
            public Enum set(ConfigKey.ConfigKeyField key, Enum value) {
                return value;
            }
        });
        ConfigTypeConveration.registerSpecialType(x -> List.class.isAssignableFrom((Class<?>)x) || x == ArrayList.class, new ConfigTypeList());
    }

    public static abstract class SimpleConfigTypeConveration<T>
    extends ConfigTypeConveration<T> {
        @Override
        public T readElement(T defaultValue, boolean loadDefault, boolean ignoreRestart, JsonElement element, Side side, @Nullable ConfigKey.ConfigKeyField key) {
            return this.readElement(defaultValue, loadDefault, element);
        }

        public abstract T readElement(T var1, boolean var2, JsonElement var3);

        @Override
        public JsonElement writeElement(T value, T defaultValue, boolean ignoreRestart, boolean saveDefault, Side side, @Nullable ConfigKey.ConfigKeyField key) {
            return this.writeElement(value, defaultValue, saveDefault);
        }

        public abstract JsonElement writeElement(T var1, T var2, boolean var3);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void createControls(GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key, Class clazz) {
            this.createControls(parent, clazz);
        }

        @OnlyIn(value=Dist.CLIENT)
        public abstract void createControls(GuiParent var1, Class var2);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void loadValue(T value, GuiParent parent, IGuiConfigParent configParent, @Nullable ConfigKey.ConfigKeyField key) {
            this.loadValue(value, parent);
        }

        @OnlyIn(value=Dist.CLIENT)
        public abstract void loadValue(T var1, GuiParent var2);

        @Override
        @OnlyIn(value=Dist.CLIENT)
        protected T saveValue(GuiParent parent, IGuiConfigParent configParent, Class clazz, @Nullable ConfigKey.ConfigKeyField key) {
            return this.saveValue(parent, clazz);
        }

        @OnlyIn(value=Dist.CLIENT)
        protected abstract T saveValue(GuiParent var1, Class var2);
    }
}

